/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.message;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSStreamMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.message.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.message.AMQPNativeInboundTransformer;
import org.apache.activemq.artemis.protocol.amqp.converter.message.EncodedMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.message.InboundTransformer;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class JMSMappingInboundTransformer
extends InboundTransformer {
    public JMSMappingInboundTransformer(IDGenerator idGenerator) {
        super(idGenerator);
    }

    @Override
    public String getTransformerName() {
        return "jms";
    }

    @Override
    public InboundTransformer getFallbackTransformer() {
        return new AMQPNativeInboundTransformer(this.idGenerator);
    }

    @Override
    public ServerJMSMessage transform(EncodedMessage encodedMessage) throws Exception {
        ServerJMSMessage transformedMessage = null;
        try {
            Message amqpMessage = encodedMessage.decode();
            transformedMessage = this.createServerMessage(amqpMessage);
            this.populateMessage(transformedMessage, amqpMessage);
        }
        catch (Exception ex) {
            for (InboundTransformer transformer = this.getFallbackTransformer(); transformer != null; transformer = transformer.getFallbackTransformer()) {
                try {
                    transformedMessage = transformer.transform(encodedMessage);
                    break;
                }
                catch (Exception e) {
                    continue;
                }
            }
        }
        if (transformedMessage != null && encodedMessage.getMessageFormat() != 0L) {
            transformedMessage.setLongProperty("JMS_AMQP_MESSAGE_FORMAT", encodedMessage.getMessageFormat());
        }
        return transformedMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ServerJMSMessage createServerMessage(Message message) throws Exception {
        ServerJMSMessage result;
        Section body = message.getBody();
        if (body == null) {
            Charset charset;
            result = AMQPMessageSupport.isContentType("application/x-java-serialized-object", message) ? AMQPMessageSupport.createObjectMessage(this.idGenerator) : (AMQPMessageSupport.isContentType("application/octet-stream", message) || AMQPMessageSupport.isContentType(null, message) ? AMQPMessageSupport.createBytesMessage(this.idGenerator) : ((charset = AMQPMessageSupport.getCharsetForTextualContent(message.getContentType())) != null ? AMQPMessageSupport.createTextMessage(this.idGenerator) : AMQPMessageSupport.createMessage(this.idGenerator)));
            result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)1);
            return result;
        } else if (body instanceof Data) {
            Binary payload = ((Data)body).getValue();
            if (AMQPMessageSupport.isContentType("application/x-java-serialized-object", message)) {
                result = AMQPMessageSupport.createObjectMessage(this.idGenerator, payload.getArray(), payload.getArrayOffset(), payload.getLength());
            } else if (AMQPMessageSupport.isContentType("application/octet-stream", message)) {
                result = AMQPMessageSupport.createBytesMessage(this.idGenerator, payload.getArray(), payload.getArrayOffset(), payload.getLength());
            } else {
                Charset charset = AMQPMessageSupport.getCharsetForTextualContent(message.getContentType());
                if (StandardCharsets.UTF_8.equals(charset)) {
                    ByteBuffer buf = ByteBuffer.wrap(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                    try {
                        CharBuffer chars = charset.newDecoder().decode(buf);
                        result = AMQPMessageSupport.createTextMessage(this.idGenerator, String.valueOf(chars));
                    }
                    catch (CharacterCodingException e) {
                        result = AMQPMessageSupport.createBytesMessage(this.idGenerator, payload.getArray(), payload.getArrayOffset(), payload.getLength());
                    }
                } else {
                    result = AMQPMessageSupport.createBytesMessage(this.idGenerator, payload.getArray(), payload.getArrayOffset(), payload.getLength());
                }
            }
            result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)2);
            return result;
        } else if (body instanceof AmqpSequence) {
            AmqpSequence sequence = (AmqpSequence)body;
            ServerJMSStreamMessage m = AMQPMessageSupport.createStreamMessage(this.idGenerator);
            for (Object item : sequence.getValue()) {
                m.writeObject(item);
            }
            result = m;
            result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)3);
            return result;
        } else {
            if (!(body instanceof AmqpValue)) throw new RuntimeException("Unexpected body type: " + body.getClass());
            Object value = ((AmqpValue)body).getValue();
            if (value == null || value instanceof String) {
                result = AMQPMessageSupport.createTextMessage(this.idGenerator, (String)value);
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", value == null ? (short)4 : 5);
                return result;
            } else if (value instanceof Binary) {
                Binary payload = (Binary)value;
                result = AMQPMessageSupport.isContentType("application/x-java-serialized-object", message) ? AMQPMessageSupport.createObjectMessage(this.idGenerator, payload) : AMQPMessageSupport.createBytesMessage(this.idGenerator, payload.getArray(), payload.getArrayOffset(), payload.getLength());
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)6);
                return result;
            } else if (value instanceof List) {
                ServerJMSStreamMessage m = AMQPMessageSupport.createStreamMessage(this.idGenerator);
                for (Object item : (List)value) {
                    m.writeObject(item);
                }
                result = m;
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)8);
                return result;
            } else {
                if (!(value instanceof Map)) throw new ActiveMQAMQPInternalErrorException("Unable to encode to ActiveMQ JMS Message");
                result = AMQPMessageSupport.createMapMessage(this.idGenerator, (Map)value);
                result.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)7);
            }
        }
        return result;
    }
}

