/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.message;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSBytesMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMapMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSObjectMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSStreamMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSTextMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.message.AMQPMessageIdHelper;
import org.apache.activemq.artemis.protocol.amqp.converter.message.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.message.OutboundTransformer;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.AMQPDefinedTypes;
import org.apache.qpid.proton.codec.Decoder;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.jboss.logging.Logger;

public class JMSMappingOutboundTransformer
extends OutboundTransformer {
    private static final Logger logger = Logger.getLogger(JMSMappingOutboundTransformer.class);
    public static final Symbol JMS_DEST_TYPE_MSG_ANNOTATION = Symbol.valueOf((String)"x-opt-jms-dest");
    public static final Symbol JMS_REPLY_TO_TYPE_MSG_ANNOTATION = Symbol.valueOf((String)"x-opt-jms-reply-to");
    public static final byte QUEUE_TYPE = 0;
    public static final byte TOPIC_TYPE = 1;
    public static final byte TEMP_QUEUE_TYPE = 2;
    public static final byte TEMP_TOPIC_TYPE = 3;
    private static final ThreadLocal<EncoderDecoderPair> tlsCodec = new ThreadLocal<EncoderDecoderPair>(){

        @Override
        protected EncoderDecoderPair initialValue() {
            return new EncoderDecoderPair();
        }
    };

    public JMSMappingOutboundTransformer(IDGenerator idGenerator) {
        super(idGenerator);
    }

    @Override
    public long transform(ServerJMSMessage message, WritableBuffer buffer) throws JMSException, UnsupportedEncodingException {
        long timeStamp;
        long expiration;
        String correlationId;
        Destination replyTo;
        Destination destination;
        String messageId;
        String type;
        byte priority;
        if (message == null) {
            return 0L;
        }
        long messageFormat = 0L;
        Header header = null;
        Properties properties = null;
        HashMap<Symbol, Object> daMap = null;
        HashMap<Symbol, Byte> maMap = null;
        HashMap<String, Object> apMap = null;
        HashMap<String, Object> footerMap = null;
        Section body = this.convertBody(message);
        if (message.getInnerMessage().isDurable()) {
            if (header == null) {
                header = new Header();
            }
            header.setDurable(Boolean.valueOf(true));
        }
        if ((priority = (byte)message.getJMSPriority()) != 4) {
            if (header == null) {
                header = new Header();
            }
            header.setPriority(UnsignedByte.valueOf((byte)priority));
        }
        if ((type = message.getJMSType()) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setSubject(type);
        }
        if ((messageId = message.getJMSMessageID()) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            try {
                properties.setMessageId(AMQPMessageIdHelper.INSTANCE.toIdObject(messageId));
            }
            catch (ActiveMQAMQPIllegalStateException e) {
                properties.setMessageId((Object)messageId);
            }
        }
        if ((destination = message.getJMSDestination()) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setTo(AMQPMessageSupport.toAddress(destination));
            if (maMap == null) {
                maMap = new HashMap<Symbol, Byte>();
            }
            maMap.put(JMS_DEST_TYPE_MSG_ANNOTATION, JMSMappingOutboundTransformer.destinationType(destination));
        }
        if ((replyTo = message.getJMSReplyTo()) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setReplyTo(AMQPMessageSupport.toAddress(replyTo));
            if (maMap == null) {
                maMap = new HashMap();
            }
            maMap.put(JMS_REPLY_TO_TYPE_MSG_ANNOTATION, JMSMappingOutboundTransformer.destinationType(replyTo));
        }
        if ((correlationId = message.getJMSCorrelationID()) != null) {
            if (properties == null) {
                properties = new Properties();
            }
            try {
                properties.setCorrelationId(AMQPMessageIdHelper.INSTANCE.toIdObject(correlationId));
            }
            catch (ActiveMQAMQPIllegalStateException e) {
                properties.setCorrelationId((Object)correlationId);
            }
        }
        if ((expiration = message.getJMSExpiration()) != 0L) {
            long ttl = expiration - System.currentTimeMillis();
            if (ttl < 0L) {
                ttl = 1L;
            }
            if (header == null) {
                header = new Header();
            }
            header.setTtl(new UnsignedInteger((int)ttl));
            if (properties == null) {
                properties = new Properties();
            }
            properties.setAbsoluteExpiryTime(new Date(expiration));
        }
        if ((timeStamp = message.getJMSTimestamp()) != 0L) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.setCreationTime(new Date(timeStamp));
        }
        Set keySet = MessageUtil.getPropertyNames((Message)message.getInnerMessage());
        for (String key : keySet) {
            Object objectProperty;
            if (key.startsWith("JMSX")) {
                if (key.equals("JMSXDeliveryCount")) {
                    int amqpDeliveryCount = message.getDeliveryCount() - 1;
                    if (amqpDeliveryCount <= 0) continue;
                    if (header == null) {
                        header = new Header();
                    }
                    header.setDeliveryCount(new UnsignedInteger(amqpDeliveryCount));
                    continue;
                }
                if (key.equals("JMSXUserID")) {
                    String value = message.getStringProperty(key);
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setUserId(new Binary(value.getBytes(StandardCharsets.UTF_8)));
                    continue;
                }
                if (key.equals("JMSXGroupID")) {
                    String value = message.getStringProperty(key);
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setGroupId(value);
                    continue;
                }
                if (key.equals("JMSXGroupSeq")) {
                    UnsignedInteger value = new UnsignedInteger(message.getIntProperty(key));
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setGroupSequence(value);
                    continue;
                }
            } else if (key.startsWith("JMS_AMQP_")) {
                if (key.equals("JMS_AMQP_MESSAGE_FORMAT")) {
                    messageFormat = message.getLongProperty("JMS_AMQP_MESSAGE_FORMAT");
                    continue;
                }
                if (key.equals("JMS_AMQP_NATIVE") || key.equals("JMS_AMQP_ORIGINAL_ENCODING")) continue;
                if (key.equals("JMS_AMQP_FirstAcquirer")) {
                    if (header == null) {
                        header = new Header();
                    }
                    header.setFirstAcquirer(Boolean.valueOf(message.getBooleanProperty(key)));
                    continue;
                }
                if (key.equals("JMS_AMQP_HEADER")) {
                    if (header != null) continue;
                    header = new Header();
                    continue;
                }
                if (key.startsWith("JMS_AMQP_PROPERTIES")) {
                    if (properties != null) continue;
                    properties = new Properties();
                    continue;
                }
                if (key.startsWith("JMS_AMQP_DA_")) {
                    if (daMap == null) {
                        daMap = new HashMap<Symbol, Object>();
                    }
                    String name = key.substring("JMS_AMQP_DA_".length());
                    daMap.put(Symbol.valueOf((String)name), message.getObjectProperty(key));
                    continue;
                }
                if (key.startsWith("JMS_AMQP_MA_")) {
                    if (maMap == null) {
                        maMap = new HashMap();
                    }
                    String name = key.substring("JMS_AMQP_MA_".length());
                    maMap.put(Symbol.valueOf((String)name), (Byte)message.getObjectProperty(key));
                    continue;
                }
                if (key.equals("JMS_AMQP_ContentType")) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setContentType(Symbol.getSymbol((String)message.getStringProperty(key)));
                    continue;
                }
                if (key.equals("JMS_AMQP_ContentEncoding")) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setContentEncoding(Symbol.getSymbol((String)message.getStringProperty(key)));
                    continue;
                }
                if (key.equals("JMS_AMQP_ReplyToGroupID")) {
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setReplyToGroupId(message.getStringProperty(key));
                    continue;
                }
                if (key.startsWith("JMS_AMQP_FT_")) {
                    if (footerMap == null) {
                        footerMap = new HashMap<String, Object>();
                    }
                    String name = key.substring("JMS_AMQP_FT_".length());
                    footerMap.put(name, message.getObjectProperty(key));
                    continue;
                }
            } else {
                if (key.equals("_AMQ_GROUP_ID")) {
                    String value = message.getStringProperty(key);
                    if (properties == null) {
                        properties = new Properties();
                    }
                    properties.setGroupId(value);
                    continue;
                }
                if (key.equals("NATIVE_MESSAGE_ID") || key.endsWith(Message.HDR_SCHEDULED_DELIVERY_TIME.toString()) || key.equals("amqp:type")) continue;
            }
            if (apMap == null) {
                apMap = new HashMap<String, Object>();
            }
            if ((objectProperty = message.getObjectProperty(key)) instanceof byte[]) {
                objectProperty = new Binary((byte[])objectProperty);
            }
            apMap.put(key, objectProperty);
        }
        EncoderImpl encoder = JMSMappingOutboundTransformer.tlsCodec.get().encoder;
        encoder.setByteBuffer(buffer);
        if (header != null) {
            encoder.writeObject((Object)header);
        }
        if (daMap != null) {
            encoder.writeObject((Object)new DeliveryAnnotations(daMap));
        }
        if (maMap != null) {
            encoder.writeObject((Object)new MessageAnnotations(maMap));
        }
        if (properties != null) {
            encoder.writeObject((Object)properties);
        }
        if (apMap != null) {
            encoder.writeObject((Object)new ApplicationProperties(apMap));
        }
        if (body != null) {
            encoder.writeObject((Object)body);
        }
        if (footerMap != null) {
            encoder.writeObject((Object)new Footer(footerMap));
        }
        return messageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Section convertBody(ServerJMSMessage message) throws JMSException {
        AmqpValue body = null;
        int orignalEncoding = 0;
        try {
            orignalEncoding = message.getShortProperty("JMS_AMQP_ORIGINAL_ENCODING");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (message instanceof ServerJMSBytesMessage) {
            Binary payload = this.getBinaryFromMessageBody((ServerJMSBytesMessage)message);
            if (payload == null) {
                payload = AMQPMessageSupport.EMPTY_BINARY;
            }
            switch (orignalEncoding) {
                case 1: {
                    break;
                }
                case 6: {
                    body = new AmqpValue((Object)payload);
                    break;
                }
                default: {
                    body = new Data(payload);
                    break;
                }
            }
        } else if (message instanceof ServerJMSTextMessage) {
            switch (orignalEncoding) {
                case 1: {
                    break;
                }
                case 2: {
                    body = new Data(this.getBinaryFromMessageBody((ServerJMSTextMessage)message));
                    break;
                }
                default: {
                    body = new AmqpValue((Object)((TextMessage)message).getText());
                    break;
                }
            }
        } else if (message instanceof ServerJMSMapMessage) {
            body = new AmqpValue(this.getMapFromMessageBody((ServerJMSMapMessage)message));
        } else if (message instanceof ServerJMSStreamMessage) {
            ArrayList<Object> list = new ArrayList<Object>();
            ServerJMSStreamMessage m = (ServerJMSStreamMessage)message;
            try {
                while (true) {
                    list.add(m.readObject());
                }
            }
            catch (MessageEOFException messageEOFException) {
                String amqpType;
                if (orignalEncoding == 0 && (amqpType = message.getStringProperty("amqp:type")) != null) {
                    orignalEncoding = amqpType.equals("amqp:list") ? 8 : 3;
                }
                switch (orignalEncoding) {
                    case 3: {
                        body = new AmqpSequence(list);
                        break;
                    }
                    default: {
                        body = new AmqpValue(list);
                        break;
                    }
                }
            }
        } else if (message instanceof ServerJMSObjectMessage) {
            Binary payload = this.getBinaryFromMessageBody((ServerJMSObjectMessage)message);
            if (payload == null) {
                payload = AMQPMessageSupport.EMPTY_BINARY;
            }
            switch (orignalEncoding) {
                case 6: {
                    body = new AmqpValue((Object)payload);
                    break;
                }
                default: {
                    body = new Data(payload);
                }
            }
            if (!message.propertyExists("JMS_AMQP_ContentType")) {
                message.setStringProperty("JMS_AMQP_ContentType", "application/x-java-serialized-object");
            }
        } else if (message instanceof ServerJMSMessage && orignalEncoding == 0) {
            MessageInternal internalMessage = message.getInnerMessage();
            int readerIndex = internalMessage.getBodyBuffer().readerIndex();
            try {
                SimpleString s = internalMessage.getBodyBuffer().readNullableSimpleString();
                if (s != null) {
                    body = new AmqpValue((Object)s.toString());
                }
            }
            catch (Throwable ignored) {
                logger.debug("Exception ignored during conversion, should be ok!", (Object)ignored.getMessage(), ignored);
            }
            finally {
                internalMessage.getBodyBuffer().readerIndex(readerIndex);
            }
        }
        return body;
    }

    private Binary getBinaryFromMessageBody(ServerJMSBytesMessage message) throws JMSException {
        byte[] data = new byte[(int)message.getBodyLength()];
        message.readBytes(data);
        message.reset();
        return new Binary(data);
    }

    private Binary getBinaryFromMessageBody(ServerJMSTextMessage message) throws JMSException {
        Binary result = null;
        String text = message.getText();
        if (text != null) {
            result = new Binary(text.getBytes(StandardCharsets.UTF_8));
        }
        return result;
    }

    private Binary getBinaryFromMessageBody(ServerJMSObjectMessage message) throws JMSException {
        message.getInnerMessage().getBodyBuffer().resetReaderIndex();
        int size = message.getInnerMessage().getBodyBuffer().readInt();
        byte[] bytes = new byte[size];
        message.getInnerMessage().getBodyBuffer().readBytes(bytes);
        return new Binary(bytes);
    }

    private Map<String, Object> getMapFromMessageBody(ServerJMSMapMessage message) throws JMSException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Enumeration names = message.getMapNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            Object value = message.getObject(key);
            if (value instanceof byte[]) {
                value = new Binary((byte[])value);
            }
            map.put(key, value);
        }
        return map;
    }

    private static byte destinationType(Destination destination) {
        if (destination instanceof Queue) {
            if (destination instanceof TemporaryQueue) {
                return 2;
            }
            return 0;
        }
        if (destination instanceof Topic) {
            if (destination instanceof TemporaryTopic) {
                return 3;
            }
            return 1;
        }
        throw new IllegalArgumentException("Unknown Destination Type passed to JMS Transformer.");
    }

    private static class EncoderDecoderPair {
        DecoderImpl decoder = new DecoderImpl();
        EncoderImpl encoder = new EncoderImpl(this.decoder);

        private EncoderDecoderPair() {
            AMQPDefinedTypes.registerAllTypes((Decoder)this.decoder, (EncoderImpl)this.encoder);
        }
    }
}

