/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersister;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPConverter;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;

public class AMQPMessage
extends RefCountMessage {
    final long messageFormat;
    ByteBuf data;
    boolean bufferValid;
    byte type;
    long messageID;
    String address;
    MessageImpl protonMessage;
    private volatile int memoryEstimate = -1;
    private long expiration = 0L;
    private int sendFrom = -1;
    private boolean parsedHeaders = false;
    private Header _header;
    private DeliveryAnnotations _deliveryAnnotations;
    private MessageAnnotations _messageAnnotations;
    private Properties _properties;
    private ApplicationProperties applicationProperties;
    private long scheduledTime = -1L;
    private String connectionID;

    public AMQPMessage(long messageFormat, byte[] data) {
        this.data = Unpooled.wrappedBuffer((byte[])data);
        this.messageFormat = messageFormat;
        this.bufferValid = true;
    }

    public AMQPMessage(long messageFormat) {
        this.messageFormat = messageFormat;
        this.bufferValid = false;
    }

    public AMQPMessage(long messageFormat, org.apache.qpid.proton.message.Message message) {
        this.messageFormat = messageFormat;
        this.protonMessage = (MessageImpl)message;
    }

    public AMQPMessage(org.apache.qpid.proton.message.Message message) {
        this(0L, message);
    }

    public MessageImpl getProtonMessage() {
        if (this.protonMessage == null) {
            this.protonMessage = (MessageImpl)Message.Factory.create();
            if (this.data != null) {
                this.data.readerIndex(0);
                this.protonMessage.decode(this.data.nioBuffer());
                this._header = this.protonMessage.getHeader();
                this.protonMessage.setHeader(null);
            }
        }
        return this.protonMessage;
    }

    private void initalizeObjects() {
        if (this.protonMessage == null && this.data == null) {
            this.sendFrom = -1;
            this._header = new Header();
            this._deliveryAnnotations = new DeliveryAnnotations(new HashMap());
            this._properties = new Properties();
            this.applicationProperties = new ApplicationProperties(new HashMap());
            this.protonMessage = (MessageImpl)Message.Factory.create();
            this.protonMessage.setApplicationProperties(this.applicationProperties);
            this.protonMessage.setDeliveryAnnotations(this._deliveryAnnotations);
        }
    }

    private Map getApplicationPropertiesMap() {
        ApplicationProperties appMap = this.getApplicationProperties();
        Map map = null;
        if (appMap != null) {
            map = appMap.getValue();
        }
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    private ApplicationProperties getApplicationProperties() {
        this.parseHeaders();
        return this.applicationProperties;
    }

    private void parseHeaders() {
        if (!this.parsedHeaders) {
            if (this.data == null) {
                this.initalizeObjects();
            } else {
                this.partialDecode(this.data.nioBuffer());
            }
            this.parsedHeaders = true;
        }
    }

    public Message setConnectionID(String connectionID) {
        this.connectionID = connectionID;
        return this;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public MessageAnnotations getMessageAnnotations() {
        this.parseHeaders();
        return this._messageAnnotations;
    }

    public Header getHeader() {
        this.parseHeaders();
        return this._header;
    }

    public Properties getProperties() {
        this.parseHeaders();
        return this._properties;
    }

    private Object getSymbol(String symbol) {
        return this.getSymbol(Symbol.getSymbol((String)symbol));
    }

    private Object getSymbol(Symbol symbol) {
        Map mapAnnotations;
        MessageAnnotations annotations = this.getMessageAnnotations();
        Map map = mapAnnotations = annotations != null ? annotations.getValue() : null;
        if (mapAnnotations != null) {
            return mapAnnotations.get(symbol);
        }
        return null;
    }

    private void setSymbol(String symbol, Object value) {
        this.setSymbol(Symbol.getSymbol((String)symbol), value);
    }

    private void setSymbol(Symbol symbol, Object value) {
        Map mapAnnotations;
        MessageAnnotations annotations = this.getMessageAnnotations();
        Map map = mapAnnotations = annotations != null ? annotations.getValue() : null;
        if (mapAnnotations != null) {
            mapAnnotations.put(symbol, value);
        }
    }

    public RoutingType getRouteType() {
        return null;
    }

    public SimpleString getGroupID() {
        this.parseHeaders();
        if (this._properties != null && this._properties.getGroupId() != null) {
            return SimpleString.toSimpleString((String)this._properties.getGroupId());
        }
        return null;
    }

    public Long getScheduledDeliveryTime() {
        if (this.scheduledTime < 0L) {
            Object objscheduledTime = this.getSymbol("x-opt-delivery-time");
            Object objdelay = this.getSymbol("x-opt-delivery-delay");
            this.scheduledTime = objscheduledTime != null && objscheduledTime instanceof Number ? ((Number)objscheduledTime).longValue() : (objdelay != null && objdelay instanceof Number ? System.currentTimeMillis() + ((Number)objdelay).longValue() : 0L);
        }
        return this.scheduledTime;
    }

    public AMQPMessage setScheduledDeliveryTime(Long time) {
        this.parseHeaders();
        this.setSymbol(AMQPMessageSupport.JMS_DELIVERY_TIME, (Object)time);
        return this;
    }

    public Persister<Message> getPersister() {
        return AMQPMessagePersister.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void partialDecode(ByteBuffer buffer) {
        DecoderImpl decoder = TLSEncode.getDecoder();
        decoder.setByteBuffer(buffer);
        buffer.position(0);
        this._header = null;
        this._deliveryAnnotations = null;
        this._messageAnnotations = null;
        this._properties = null;
        this.applicationProperties = null;
        Object section = null;
        try {
            if (buffer.hasRemaining()) {
                section = (Section)decoder.readObject();
            }
            if (section instanceof Header) {
                this.sendFrom = buffer.position();
                this._header = (Header)section;
                if (this._header.getTtl() != null) {
                    this.expiration = System.currentTimeMillis() + (long)this._header.getTtl().intValue();
                }
                section = buffer.hasRemaining() ? (Section)decoder.readObject() : null;
            } else {
                this.sendFrom = 0;
            }
            if (section instanceof DeliveryAnnotations) {
                this._deliveryAnnotations = (DeliveryAnnotations)section;
                this.sendFrom = buffer.position();
                section = buffer.hasRemaining() ? (Section)decoder.readObject() : null;
            }
            if (section instanceof MessageAnnotations) {
                this._messageAnnotations = (MessageAnnotations)section;
                section = buffer.hasRemaining() ? (Section)decoder.readObject() : null;
            }
            if (section instanceof Properties) {
                this._properties = (Properties)section;
                section = buffer.hasRemaining() ? (Section)decoder.readObject() : null;
            }
            if (section instanceof ApplicationProperties) {
                this.applicationProperties = (ApplicationProperties)section;
            }
        }
        finally {
            decoder.setByteBuffer(null);
        }
    }

    public long getMessageFormat() {
        return this.messageFormat;
    }

    public int getLength() {
        return this.data.array().length;
    }

    public byte[] getArray() {
        return this.data.array();
    }

    public void messageChanged() {
        this.bufferValid = false;
        this.data = null;
    }

    public ByteBuf getBuffer() {
        if (this.data == null) {
            return null;
        }
        return Unpooled.wrappedBuffer((ByteBuf)this.data);
    }

    public AMQPMessage setBuffer(ByteBuf buffer) {
        this.data = null;
        return this;
    }

    public Message copy() {
        this.checkBuffer();
        AMQPMessage newEncode = new AMQPMessage(this.messageFormat, this.data.array());
        return newEncode;
    }

    public Message copy(long newID) {
        this.checkBuffer();
        return this.copy().setMessageID(newID);
    }

    public long getMessageID() {
        return this.messageID;
    }

    public Message setMessageID(long id) {
        this.messageID = id;
        return this;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public AMQPMessage setExpiration(long expiration) {
        this.expiration = expiration;
        return this;
    }

    public Object getUserID() {
        Properties properties = this.getProperties();
        if (properties != null && properties.getMessageId() != null) {
            return properties.getMessageId();
        }
        return this;
    }

    public Message setUserID(Object userID) {
        return null;
    }

    public boolean isDurable() {
        if (this.getHeader() != null && this.getHeader().getDurable() != null) {
            return this.getHeader().getDurable();
        }
        return false;
    }

    public Object getDuplicateProperty() {
        return null;
    }

    public Message setDurable(boolean durable) {
        return null;
    }

    public String getAddress() {
        if (this.address == null) {
            Properties properties = this.getProtonMessage().getProperties();
            if (properties != null) {
                return properties.getTo();
            }
            return null;
        }
        return this.address;
    }

    public AMQPMessage setAddress(String address) {
        this.address = address;
        return this;
    }

    public AMQPMessage setAddress(SimpleString address) {
        return this.setAddress(address.toString());
    }

    public SimpleString getAddressSimpleString() {
        return SimpleString.toSimpleString((String)this.getAddress());
    }

    public long getTimestamp() {
        return 0L;
    }

    public Message setTimestamp(long timestamp) {
        return null;
    }

    public byte getPriority() {
        return 0;
    }

    public Message setPriority(byte priority) {
        return null;
    }

    public void receiveBuffer(ByteBuf buffer) {
    }

    private synchronized void checkBuffer() {
        if (!this.bufferValid) {
            ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1500);
            try {
                this.getProtonMessage().encode((WritableBuffer)new NettyWritable(buffer));
                byte[] bytes = new byte[buffer.writerIndex()];
                buffer.readBytes(bytes);
                this.data = Unpooled.wrappedBuffer((byte[])bytes);
            }
            finally {
                buffer.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBuffer(ByteBuf buffer, int deliveryCount) {
        this.checkBuffer();
        Header header = this.getHeader();
        if (header == null && deliveryCount > 0) {
            header = new Header();
        }
        if (header != null) {
            Header header2 = header;
            synchronized (header2) {
                header.setDeliveryCount(UnsignedInteger.valueOf((int)(deliveryCount - 1)));
                TLSEncode.getEncoder().setByteBuffer((WritableBuffer)new NettyWritable(buffer));
                TLSEncode.getEncoder().writeObject((Object)header);
                TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
            }
        }
        buffer.writeBytes(this.data, this.sendFrom, this.data.writerIndex() - this.sendFrom);
    }

    public Message putBooleanProperty(String key, boolean value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putByteProperty(String key, byte value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putBytesProperty(String key, byte[] value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putShortProperty(String key, short value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putCharProperty(String key, char value) {
        this.getApplicationPropertiesMap().put(key, Character.valueOf(value));
        return this;
    }

    public Message putIntProperty(String key, int value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putLongProperty(String key, long value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putFloatProperty(String key, float value) {
        this.getApplicationPropertiesMap().put(key, Float.valueOf(value));
        return this;
    }

    public Message putDoubleProperty(String key, double value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putBooleanProperty(SimpleString key, boolean value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putByteProperty(SimpleString key, byte value) {
        return this.putByteProperty(key.toString(), value);
    }

    public Message putBytesProperty(SimpleString key, byte[] value) {
        return this.putBytesProperty(key.toString(), value);
    }

    public Message putShortProperty(SimpleString key, short value) {
        return this.putShortProperty(key.toString(), value);
    }

    public Message putCharProperty(SimpleString key, char value) {
        return this.putCharProperty(key.toString(), value);
    }

    public Message putIntProperty(SimpleString key, int value) {
        return this.putIntProperty(key.toString(), value);
    }

    public Message putLongProperty(SimpleString key, long value) {
        return this.putLongProperty(key.toString(), value);
    }

    public Message putFloatProperty(SimpleString key, float value) {
        return this.putFloatProperty(key.toString(), value);
    }

    public Message putDoubleProperty(SimpleString key, double value) {
        return this.putDoubleProperty(key.toString(), value);
    }

    public Message putStringProperty(String key, String value) {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
        this.getApplicationPropertiesMap().put(key, value);
        return this;
    }

    public Message putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
        return this.putObjectProperty(key.toString(), value);
    }

    public Object removeProperty(String key) {
        return this.getApplicationPropertiesMap().remove(key);
    }

    public boolean containsProperty(String key) {
        return this.getApplicationPropertiesMap().containsKey(key);
    }

    public Boolean getBooleanProperty(String key) throws ActiveMQPropertyConversionException {
        return (Boolean)this.getApplicationPropertiesMap().get(key);
    }

    public Byte getByteProperty(String key) throws ActiveMQPropertyConversionException {
        return (Byte)this.getApplicationPropertiesMap().get(key);
    }

    public Double getDoubleProperty(String key) throws ActiveMQPropertyConversionException {
        return (Double)this.getApplicationPropertiesMap().get(key);
    }

    public Integer getIntProperty(String key) throws ActiveMQPropertyConversionException {
        return (Integer)this.getApplicationPropertiesMap().get(key);
    }

    public Long getLongProperty(String key) throws ActiveMQPropertyConversionException {
        return (Long)this.getApplicationPropertiesMap().get(key);
    }

    public Object getObjectProperty(String key) {
        if (key.equals(MessageUtil.TYPE_HEADER_NAME.toString())) {
            return this.getProperties().getSubject();
        }
        if (key.equals(MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString())) {
            return this.getConnectionID();
        }
        return this.getApplicationPropertiesMap().get(key);
    }

    public Short getShortProperty(String key) throws ActiveMQPropertyConversionException {
        return (Short)this.getApplicationPropertiesMap().get(key);
    }

    public Float getFloatProperty(String key) throws ActiveMQPropertyConversionException {
        return (Float)this.getApplicationPropertiesMap().get(key);
    }

    public String getStringProperty(String key) throws ActiveMQPropertyConversionException {
        if (key.equals(MessageUtil.TYPE_HEADER_NAME.toString())) {
            return this.getProperties().getSubject();
        }
        if (key.equals(MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString())) {
            return this.getConnectionID();
        }
        return (String)this.getApplicationPropertiesMap().get(key);
    }

    public Object removeDeliveryAnnotationProperty(SimpleString key) {
        this.parseHeaders();
        if (this._deliveryAnnotations == null || this._deliveryAnnotations.getValue() == null) {
            return null;
        }
        return this._deliveryAnnotations.getValue().remove(key.toString());
    }

    public Object getDeliveryAnnotationProperty(SimpleString key) {
        return null;
    }

    public SimpleString getSimpleStringProperty(String key) throws ActiveMQPropertyConversionException {
        return SimpleString.toSimpleString((String)((String)this.getApplicationPropertiesMap().get(key)));
    }

    public byte[] getBytesProperty(String key) throws ActiveMQPropertyConversionException {
        return (byte[])this.getApplicationPropertiesMap().get(key);
    }

    public Object removeProperty(SimpleString key) {
        return this.removeProperty(key.toString());
    }

    public boolean containsProperty(SimpleString key) {
        return this.containsProperty(key.toString());
    }

    public Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getBooleanProperty(key.toString());
    }

    public Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getByteProperty(key.toString());
    }

    public Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getDoubleProperty(key.toString());
    }

    public Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getIntProperty(key.toString());
    }

    public Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getLongProperty(key.toString());
    }

    public Object getObjectProperty(SimpleString key) {
        return this.getObjectProperty(key.toString());
    }

    public Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getShortProperty(key.toString());
    }

    public Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getFloatProperty(key.toString());
    }

    public String getStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getStringProperty(key.toString());
    }

    public SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getSimpleStringProperty(key.toString());
    }

    public byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getBytesProperty(key.toString());
    }

    public Message putStringProperty(SimpleString key, SimpleString value) {
        return this.putStringProperty(key.toString(), value.toString());
    }

    public int getEncodeSize() {
        return 0;
    }

    public Set<SimpleString> getPropertyNames() {
        HashSet<SimpleString> values = new HashSet<SimpleString>();
        for (Object k : this.getApplicationPropertiesMap().keySet()) {
            values.add(SimpleString.toSimpleString((String)k.toString()));
        }
        return values;
    }

    public int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = 352 + (this.data != null ? this.data.capacity() : 0);
        }
        return this.memoryEstimate;
    }

    public ICoreMessage toCore() {
        try {
            return AMQPConverter.getInstance().toCore(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public SimpleString getReplyTo() {
        if (this.getProperties() != null) {
            return SimpleString.toSimpleString((String)this.getProperties().getReplyTo());
        }
        return null;
    }

    public AMQPMessage setReplyTo(SimpleString address) {
        if (this.getProperties() != null) {
            this.getProperties().setReplyTo(address != null ? address.toString() : null);
        }
        return this;
    }

    public int getPersistSize() {
        this.checkBuffer();
        return this.data.array().length + 4;
    }

    public void persist(ActiveMQBuffer targetRecord) {
        this.checkBuffer();
        targetRecord.writeInt(this.data.array().length);
        targetRecord.writeBytes(this.data.array());
    }

    public void reloadPersistence(ActiveMQBuffer record) {
        int size = record.readInt();
        byte[] recordArray = new byte[size];
        record.readBytes(recordArray);
        this.data = Unpooled.wrappedBuffer((byte[])recordArray);
        this.bufferValid = true;
    }
}

