/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.channel.ChannelPipeline;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPConnectionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;

public class ProtonProtocolManager
implements ProtocolManager<Interceptor>,
NotificationListener {
    private static final List<String> websocketRegistryNames = Arrays.asList("amqp");
    private final ActiveMQServer server;
    private final ProtonProtocolManagerFactory factory;
    private final Map<SimpleString, RoutingType> prefixes = new HashMap<SimpleString, RoutingType>();
    private String pubSubPrefix = "topic://";
    private int maxFrameSize = -1;

    public ProtonProtocolManager(ProtonProtocolManagerFactory factory, ActiveMQServer server) {
        this.factory = factory;
        this.server = server;
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    public void onNotification(Notification notification) {
    }

    public ProtocolManagerFactory<Interceptor> getFactory() {
        return this.factory;
    }

    public void updateInterceptors(List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) {
    }

    public boolean acceptsNoHandshake() {
        return false;
    }

    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection remotingConnection) {
        AMQPConnectionCallback connectionCallback = new AMQPConnectionCallback(this, remotingConnection, this.server.getExecutorFactory().getExecutor(), this.server);
        long ttl = ActiveMQClient.DEFAULT_CONNECTION_TTL;
        if (this.server.getConfiguration().getConnectionTTLOverride() != -1L) {
            ttl = this.server.getConfiguration().getConnectionTTLOverride();
        }
        String id = this.server.getConfiguration().getName();
        AMQPConnectionContext amqpConnection = new AMQPConnectionContext(connectionCallback, id, (int)ttl, this.getMaxFrameSize(), 65535, this.server.getExecutorFactory().getExecutor(), this.server.getScheduledPool());
        Executor executor = this.server.getExecutorFactory().getExecutor();
        ActiveMQProtonRemotingConnection delegate = new ActiveMQProtonRemotingConnection(this, amqpConnection, remotingConnection, executor);
        connectionCallback.setProtonConnectionDelegate(delegate);
        ConnectionEntry entry = new ConnectionEntry((RemotingConnection)delegate, executor, System.currentTimeMillis(), ttl);
        return entry;
    }

    public void removeHandler(String name) {
    }

    public void handleBuffer(RemotingConnection connection, ActiveMQBuffer buffer) {
        ActiveMQProtonRemotingConnection protonConnection = (ActiveMQProtonRemotingConnection)connection;
        protonConnection.bufferReceived(protonConnection.getID(), buffer);
    }

    public void addChannelHandlers(ChannelPipeline pipeline) {
    }

    public boolean isProtocol(byte[] array) {
        return array.length >= 4 && array[0] == 65 && array[1] == 77 && array[2] == 81 && array[3] == 80;
    }

    public void handshake(NettyServerConnection connection, ActiveMQBuffer buffer) {
    }

    public List<String> websocketSubprotocolIdentifiers() {
        return websocketRegistryNames;
    }

    public String getPubSubPrefix() {
        return this.pubSubPrefix;
    }

    public void setPubSubPrefix(String pubSubPrefix) {
        this.pubSubPrefix = pubSubPrefix;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    public void setAnycastPrefix(String anycastPrefix) {
        for (String prefix : anycastPrefix.split(",")) {
            this.prefixes.put(SimpleString.toSimpleString((String)prefix), RoutingType.ANYCAST);
        }
    }

    public void setMulticastPrefix(String multicastPrefix) {
        for (String prefix : multicastPrefix.split(",")) {
            this.prefixes.put(SimpleString.toSimpleString((String)prefix), RoutingType.MULTICAST);
        }
    }

    public Map<SimpleString, RoutingType> getPrefixes() {
        return this.prefixes;
    }
}

