/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.UnsignedLong;

public class AMQPMessageIdHelper {
    public static final AMQPMessageIdHelper INSTANCE = new AMQPMessageIdHelper();
    public static final String AMQP_STRING_PREFIX = "AMQP_STRING:";
    public static final String AMQP_UUID_PREFIX = "AMQP_UUID:";
    public static final String AMQP_ULONG_PREFIX = "AMQP_ULONG:";
    public static final String AMQP_BINARY_PREFIX = "AMQP_BINARY:";
    private static final int AMQP_UUID_PREFIX_LENGTH = "AMQP_UUID:".length();
    private static final int AMQP_ULONG_PREFIX_LENGTH = "AMQP_ULONG:".length();
    private static final int AMQP_STRING_PREFIX_LENGTH = "AMQP_STRING:".length();
    private static final int AMQP_BINARY_PREFIX_LENGTH = "AMQP_BINARY:".length();
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();

    public String toBaseMessageIdString(Object messageId) {
        if (messageId == null) {
            return null;
        }
        if (messageId instanceof String) {
            String stringId = (String)messageId;
            if (this.hasTypeEncodingPrefix(stringId)) {
                return AMQP_STRING_PREFIX + stringId;
            }
            return stringId;
        }
        if (messageId instanceof UUID) {
            return AMQP_UUID_PREFIX + messageId.toString();
        }
        if (messageId instanceof UnsignedLong) {
            return AMQP_ULONG_PREFIX + messageId.toString();
        }
        if (messageId instanceof Binary) {
            ByteBuffer dup = ((Binary)messageId).asByteBuffer();
            byte[] bytes = new byte[dup.remaining()];
            dup.get(bytes);
            String hex = this.convertBinaryToHexString(bytes);
            return AMQP_BINARY_PREFIX + hex;
        }
        throw new IllegalArgumentException("Unsupported type provided: " + messageId.getClass());
    }

    public Object toIdObject(String baseId) throws ActiveMQAMQPIllegalStateException {
        if (baseId == null) {
            return null;
        }
        try {
            if (this.hasAmqpUuidPrefix(baseId)) {
                String uuidString = this.strip(baseId, AMQP_UUID_PREFIX_LENGTH);
                return UUID.fromString(uuidString);
            }
            if (this.hasAmqpUlongPrefix(baseId)) {
                String longString = this.strip(baseId, AMQP_ULONG_PREFIX_LENGTH);
                return UnsignedLong.valueOf((String)longString);
            }
            if (this.hasAmqpStringPrefix(baseId)) {
                return this.strip(baseId, AMQP_STRING_PREFIX_LENGTH);
            }
            if (this.hasAmqpBinaryPrefix(baseId)) {
                String hexString = this.strip(baseId, AMQP_BINARY_PREFIX_LENGTH);
                byte[] bytes = this.convertHexStringToBinary(hexString);
                return new Binary(bytes);
            }
            return baseId;
        }
        catch (IllegalArgumentException e) {
            throw new ActiveMQAMQPIllegalStateException("Unable to convert ID value");
        }
    }

    public byte[] convertHexStringToBinary(String hexString) throws IllegalArgumentException {
        int length = hexString.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("The provided hex String must be an even length, but was of length " + length + ": " + hexString);
        }
        byte[] binary = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            char highBitsChar = hexString.charAt(i);
            char lowBitsChar = hexString.charAt(i + 1);
            int highBits = this.hexCharToInt(highBitsChar, hexString) << 4;
            int lowBits = this.hexCharToInt(lowBitsChar, hexString);
            binary[i / 2] = (byte)(highBits + lowBits);
        }
        return binary;
    }

    public String convertBinaryToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            int highBitsInt = b >> 4 & 0xF;
            int lowBitsInt = b & 0xF;
            builder.append(HEX_CHARS[highBitsInt]);
            builder.append(HEX_CHARS[lowBitsInt]);
        }
        return builder.toString();
    }

    private boolean hasTypeEncodingPrefix(String stringId) {
        return this.hasAmqpBinaryPrefix(stringId) || this.hasAmqpUuidPrefix(stringId) || this.hasAmqpUlongPrefix(stringId) || this.hasAmqpStringPrefix(stringId);
    }

    private boolean hasAmqpStringPrefix(String stringId) {
        return stringId.startsWith(AMQP_STRING_PREFIX);
    }

    private boolean hasAmqpUlongPrefix(String stringId) {
        return stringId.startsWith(AMQP_ULONG_PREFIX);
    }

    private boolean hasAmqpUuidPrefix(String stringId) {
        return stringId.startsWith(AMQP_UUID_PREFIX);
    }

    private boolean hasAmqpBinaryPrefix(String stringId) {
        return stringId.startsWith(AMQP_BINARY_PREFIX);
    }

    private String strip(String id, int numChars) {
        return id.substring(numChars);
    }

    private int hexCharToInt(char ch, String orig) throws IllegalArgumentException {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("The provided hex string contains non-hex character '" + ch + "': " + orig);
    }
}

