/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonDeliveryHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.util.DeliveryUtil;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;
import org.jboss.logging.Logger;

public class ProtonServerReceiverContext
extends ProtonInitializable
implements ProtonDeliveryHandler {
    private static final Logger log = Logger.getLogger(ProtonServerReceiverContext.class);
    protected final AMQPConnectionContext connection;
    protected final AMQPSessionContext protonSession;
    protected final Receiver receiver;
    protected String address;
    protected final AMQPSessionCallback sessionSPI;
    private static int maxCreditAllocation = 100;
    private static int minCreditRefresh = 30;
    private TerminusExpiryPolicy expiryPolicy;

    public ProtonServerReceiverContext(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection, AMQPSessionContext protonSession, Receiver receiver) {
        this.connection = connection;
        this.protonSession = protonSession;
        this.receiver = receiver;
        this.sessionSPI = sessionSPI;
    }

    @Override
    public void onFlow(int credits, boolean drain) {
        this.flow(Math.min(credits, maxCreditAllocation), maxCreditAllocation);
    }

    @Override
    public void initialise() throws Exception {
        super.initialise();
        Target target = (Target)this.receiver.getRemoteTarget();
        if (target != null) {
            List<Symbol> list;
            if (target.getDynamic()) {
                this.address = this.sessionSPI.tempQueueName();
                try {
                    this.sessionSPI.createTemporaryQueue(this.address, RoutingType.ANYCAST);
                }
                catch (Exception e) {
                    throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                }
                this.expiryPolicy = target.getExpiryPolicy() != null ? target.getExpiryPolicy() : TerminusExpiryPolicy.LINK_DETACH;
                target.setAddress(this.address);
            } else {
                this.address = target.getAddress();
                if (this.address != null && !this.address.isEmpty()) {
                    try {
                        if (!this.sessionSPI.bindingQuery(this.address)) {
                            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist();
                        }
                    }
                    catch (ActiveMQAMQPNotFoundException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
                    }
                }
            }
            Symbol[] remoteDesiredCapabilities = this.receiver.getRemoteDesiredCapabilities();
            if (remoteDesiredCapabilities != null && (list = Arrays.asList(remoteDesiredCapabilities)).contains(AmqpSupport.DELAYED_DELIVERY)) {
                this.receiver.setOfferedCapabilities(new Symbol[]{AmqpSupport.DELAYED_DELIVERY});
            }
        }
        this.flow(maxCreditAllocation, minCreditRefresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(Delivery delivery) throws ActiveMQAMQPException {
        ByteBuf buffer = null;
        try {
            Object txState;
            Receiver receiver = (Receiver)delivery.getLink();
            if (!delivery.isReadable()) {
                return;
            }
            if (delivery.isPartial()) {
                return;
            }
            buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(10240);
            Transaction tx = null;
            Object object = this.connection.getLock();
            synchronized (object) {
                DeliveryUtil.readDelivery(receiver, buffer);
                receiver.advance();
            }
            byte[] data = new byte[buffer.writerIndex()];
            buffer.readBytes(data);
            if (delivery.getRemoteState() instanceof TransactionalState) {
                txState = (TransactionalState)delivery.getRemoteState();
                tx = this.sessionSPI.getTransaction(txState.getTxnId());
            }
            this.sessionSPI.serverSend(tx, receiver, delivery, this.address, delivery.getMessageFormat(), data);
            txState = this.connection.getLock();
            synchronized (txState) {
                this.flow(maxCreditAllocation, minCreditRefresh);
            }
        }
        catch (Exception e) {
            log.warn((Object)e.getMessage(), (Throwable)e);
            Rejected rejected = new Rejected();
            ErrorCondition condition = new ErrorCondition();
            condition.setCondition(Symbol.valueOf((String)"failed"));
            condition.setDescription(e.getMessage());
            rejected.setError(condition);
            delivery.disposition((DeliveryState)rejected);
            delivery.settle();
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    @Override
    public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
        this.protonSession.removeReceiver(this.receiver);
        Target target = (Target)this.receiver.getRemoteTarget();
        if (target != null && target.getDynamic() && (target.getExpiryPolicy() == TerminusExpiryPolicy.LINK_DETACH || target.getExpiryPolicy() == TerminusExpiryPolicy.SESSION_END)) {
            try {
                this.sessionSPI.removeTemporaryQueue(target.getAddress());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void close(ErrorCondition condition) throws ActiveMQAMQPException {
        this.receiver.setCondition(condition);
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flow(int credits, int threshold) {
        if (this.sessionSPI != null) {
            this.sessionSPI.offerProducerCredit(this.address, credits, threshold, this.receiver);
        } else {
            Object object = this.connection.getLock();
            synchronized (object) {
                this.receiver.flow(credits);
                this.connection.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drain(int credits) {
        Object object = this.connection.getLock();
        synchronized (object) {
            this.receiver.drain(credits);
        }
        this.connection.flush();
    }

    public int drained() {
        return this.receiver.drained();
    }

    public boolean isDraining() {
        return this.receiver.draining();
    }
}

