/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.Events;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASL;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.jboss.logging.Logger;

public class ProtonHandler
extends ProtonInitializable {
    private static final Logger log = Logger.getLogger(ProtonHandler.class);
    private static final byte SASL = 3;
    private static final byte BARE = 0;
    private final Transport transport = Proton.transport();
    private final Connection connection = Proton.connection();
    private final Collector collector = Proton.collector();
    private final Executor dispatchExecutor;
    private final Runnable dispatchRunnable = new Runnable(){

        @Override
        public void run() {
            ProtonHandler.this.dispatch();
        }
    };
    private ArrayList<EventHandler> handlers = new ArrayList();
    private Sasl serverSasl;
    private Sasl clientSasl;
    private final Object lock = new Object();
    private final long creationTime;
    private Map<String, ServerSASL> saslHandlers;
    private SASLResult saslResult;
    protected volatile boolean dataReceived;
    protected boolean receivedFirstPacket = false;
    private int offset = 0;

    public ProtonHandler(Executor dispatchExecutor) {
        this.dispatchExecutor = dispatchExecutor;
        this.creationTime = System.currentTimeMillis();
        this.transport.bind(this.connection);
        this.connection.collect(this.collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tick(boolean firstTick) {
        Object object = this.lock;
        synchronized (object) {
            if (!firstTick) {
                try {
                    if (this.connection.getLocalState() != EndpointState.CLOSED) {
                        long rescheduleAt = this.transport.tick(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
                        if (this.transport.isClosed()) {
                            throw new IllegalStateException("Channel was inactive for to long");
                        }
                        return rescheduleAt;
                    }
                }
                catch (Exception e) {
                    this.transport.close();
                    this.connection.setCondition(new ErrorCondition());
                }
                return 0L;
            }
            return this.transport.tick(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int capacity() {
        Object object = this.lock;
        synchronized (object) {
            return this.transport.capacity();
        }
    }

    public Object getLock() {
        return this.lock;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ProtonHandler addEventHandler(EventHandler handler) {
        this.handlers.add(handler);
        return this;
    }

    public void createServerSASL(ServerSASL[] handlers) {
        this.serverSasl = this.transport.sasl();
        this.saslHandlers = new HashMap<String, ServerSASL>();
        String[] names = new String[handlers.length];
        int count = 0;
        for (ServerSASL handler : handlers) {
            this.saslHandlers.put(handler.getName(), handler);
            names[count++] = handler.getName();
        }
        this.serverSasl.server();
        this.serverSasl.setMechanisms(names);
    }

    public SASLResult getSASLResult() {
        return this.saslResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputBuffer(ByteBuf buffer) {
        this.dataReceived = true;
        Object object = this.lock;
        synchronized (object) {
            while (buffer.readableBytes() > 0) {
                int capacity = this.transport.capacity();
                if (!this.receivedFirstPacket) {
                    try {
                        byte auth = buffer.getByte(4);
                        if (auth == 3 || auth == 0) {
                            this.dispatchAuth(auth == 3);
                            capacity = this.transport.capacity();
                        }
                    }
                    catch (Throwable e) {
                        log.debug((Object)e.getMessage(), e);
                    }
                    this.receivedFirstPacket = true;
                }
                if (capacity > 0) {
                    ByteBuffer tail = this.transport.tail();
                    int min = Math.min(capacity, buffer.readableBytes());
                    tail.limit(min);
                    buffer.readBytes(tail);
                    this.flush();
                    continue;
                }
                if (capacity == 0) {
                    log.debugf("abandoning: readableBytes=%d", buffer.readableBytes());
                    break;
                }
                log.debugf("transport closed, discarding: readableBytes=%d, capacity=%d", buffer.readableBytes(), this.transport.capacity());
                break;
            }
        }
    }

    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputDone(int bytes) {
        Object object = this.lock;
        synchronized (object) {
            this.transport.pop(bytes);
            this.offset -= bytes;
            if (this.offset < 0) {
                throw new IllegalStateException("You called outputDone for more bytes than you actually received. numberOfBytes=" + bytes + ", outcome result=" + this.offset);
            }
        }
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf outputBuffer() {
        Object object = this.lock;
        synchronized (object) {
            int pending = this.transport.pending();
            if (pending < 0) {
                return null;
            }
            int size = pending - this.offset;
            if (size < 0) {
                throw new IllegalStateException("negative size: " + pending);
            }
            if (size == 0) {
                return null;
            }
            ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer(size);
            ByteBuffer head = this.transport.head();
            head.position(this.offset);
            head.limit(this.offset + size);
            buffer.writeBytes(head);
            this.offset += size;
            return buffer;
        }
    }

    public void flush() {
        this.flush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(boolean wait) {
        Object object = this.lock;
        synchronized (object) {
            this.transport.process();
            this.checkServerSASL();
        }
        if (wait) {
            this.dispatch();
        } else {
            this.dispatchExecutor.execute(this.dispatchRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ErrorCondition errorCondition) {
        Object object = this.lock;
        synchronized (object) {
            if (errorCondition != null) {
                this.connection.setCondition(errorCondition);
            }
            this.connection.close();
        }
        this.flush(true);
    }

    protected void checkServerSASL() {
        if (this.serverSasl != null && this.serverSasl.getRemoteMechanisms().length > 0) {
            ServerSASL mechanism = this.saslHandlers.get(this.serverSasl.getRemoteMechanisms()[0]);
            if (mechanism != null) {
                byte[] dataSASL = new byte[this.serverSasl.pending()];
                this.serverSasl.recv(dataSASL, 0, dataSASL.length);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Working on sasl::" + (dataSASL != null && dataSASL.length > 0 ? ByteUtil.bytesToHex((byte[])dataSASL, (int)2) : "Anonymous")));
                }
                this.saslResult = mechanism.processSASL(dataSASL);
                if (this.saslResult != null && this.saslResult.isSuccess()) {
                    this.serverSasl.done(Sasl.SaslOutcome.PN_SASL_OK);
                    this.serverSasl = null;
                    this.saslHandlers.clear();
                    this.saslHandlers = null;
                } else {
                    this.serverSasl.done(Sasl.SaslOutcome.PN_SASL_AUTH);
                }
                this.serverSasl = null;
            } else {
                this.serverSasl.done(Sasl.SaslOutcome.PN_SASL_SYS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event popEvent() {
        Object object = this.lock;
        synchronized (object) {
            Event ev = this.collector.peek();
            if (ev != null) {
                ev = ev.copy();
                this.collector.pop();
            }
            return ev;
        }
    }

    private void dispatchAuth(boolean sasl) {
        for (EventHandler h : this.handlers) {
            h.onAuthInit(this, this.getConnection(), sasl);
        }
    }

    private void dispatch() {
        Event ev;
        while ((ev = this.popEvent()) != null) {
            for (EventHandler h : this.handlers) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Handling " + ev + " towards " + h));
                }
                try {
                    Events.dispatch(ev, h);
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                    this.connection.setCondition(new ErrorCondition());
                }
            }
        }
        for (EventHandler h : this.handlers) {
            try {
                h.onTransport(this.transport);
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage(), (Throwable)e);
                this.connection.setCondition(new ErrorCondition());
            }
        }
    }

    public void open(String containerId, Map<Symbol, Object> connectionProperties) {
        this.transport.open();
        this.connection.setContainer(containerId);
        this.connection.setProperties(connectionProperties);
        this.connection.open();
        this.flush();
    }
}

