/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQAddressExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.message.impl.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.SecurityAuth;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerProducer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPConnectionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPResourceLimitExceededException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerReceiverContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.transaction.ProtonTransactionHandler;
import org.apache.activemq.artemis.protocol.amqp.sasl.PlainSASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.activemq.artemis.utils.RunnableEx;
import org.apache.activemq.artemis.utils.SelectorTranslator;
import org.apache.activemq.artemis.utils.SimpleIDGenerator;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Receiver;
import org.jboss.logging.Logger;

public class AMQPSessionCallback
implements SessionCallback {
    private static final Logger logger = Logger.getLogger(AMQPSessionCallback.class);
    private static final Symbol PRIORITY = Symbol.getSymbol((String)"priority");
    protected final IDGenerator consumerIDGenerator = new SimpleIDGenerator(0L);
    private final AMQPConnectionCallback protonSPI;
    private final ProtonProtocolManager manager;
    private final StorageManager storageManager;
    private final AMQPConnectionContext connection;
    private final Connection transportConnection;
    private ServerSession serverSession;
    private final OperationContext operationContext;
    private AMQPSessionContext protonSession;
    private final Executor sessionExecutor;
    private final boolean directDeliver;
    private CoreMessageObjectPools coreMessageObjectPools = new CoreMessageObjectPools();
    private final AddressQueryCache<AddressQueryResult> addressQueryCache = new AddressQueryCache();
    private ProtonTransactionHandler transactionHandler;

    public AMQPSessionCallback(AMQPConnectionCallback protonSPI, ProtonProtocolManager manager, AMQPConnectionContext connection, Connection transportConnection, Executor executor, OperationContext operationContext) {
        this.protonSPI = protonSPI;
        this.manager = manager;
        this.storageManager = manager.getServer().getStorageManager();
        this.connection = connection;
        this.transportConnection = transportConnection;
        this.sessionExecutor = executor;
        this.operationContext = operationContext;
        this.directDeliver = manager.isDirectDeliver();
    }

    public boolean isWritable(ReadyListener callback, Object protocolContext) {
        ProtonServerSenderContext senderContext = (ProtonServerSenderContext)protocolContext;
        return this.transportConnection.isWritable(callback) && senderContext.getSender().getLocalState() != EndpointState.CLOSED;
    }

    public void withinContext(RunnableEx run) throws Exception {
        OperationContext context = this.recoverContext();
        try {
            run.run();
        }
        finally {
            this.resetContext(context);
        }
    }

    public void afterIO(IOCallback ioCallback) {
        OperationContext context = this.recoverContext();
        try {
            this.manager.getServer().getStorageManager().afterCompleteOperations(ioCallback);
        }
        finally {
            this.resetContext(context);
        }
    }

    public void browserFinished(ServerConsumer consumer) {
    }

    public boolean supportsDirectDelivery() {
        return this.manager.isDirectDeliver();
    }

    public void init(AMQPSessionContext protonSession, SASLResult saslResult) throws Exception {
        this.protonSession = protonSession;
        String name = UUIDGenerator.getInstance().generateStringUUID();
        String user = null;
        String passcode = null;
        if (saslResult != null) {
            user = saslResult.getUser();
            if (saslResult instanceof PlainSASLResult) {
                passcode = ((PlainSASLResult)saslResult).getPassword();
            }
        }
        this.serverSession = this.manager.getServer().createSession(name, user, passcode, 102400, (RemotingConnection)this.protonSPI.getProtonConnectionDelegate(), false, false, false, true, (String)null, (SessionCallback)this, true, this.operationContext, this.manager.getPrefixes());
    }

    public void afterDelivery() throws Exception {
    }

    public void start() {
    }

    public Object createSender(ProtonServerSenderContext protonSender, SimpleString queue, String filter, boolean browserOnly) throws Exception {
        long consumerID = this.consumerIDGenerator.generateID();
        filter = SelectorTranslator.convertToActiveMQFilterString((String)filter);
        int priority = this.getPriority(protonSender.getSender().getRemoteProperties());
        ServerConsumer consumer = this.serverSession.createConsumer(consumerID, queue, SimpleString.toSimpleString((String)filter), priority, browserOnly, false, null);
        consumer.setStarted(true);
        consumer.setProtocolContext((Object)protonSender);
        return consumer;
    }

    private int getPriority(Map<Symbol, Object> properties) {
        Number value = properties == null ? (Number)null : (Number)((Number)properties.get(PRIORITY));
        return value == null ? ActiveMQDefaultConfiguration.getDefaultConsumerPriority() : value.intValue();
    }

    public void startSender(Object brokerConsumer) throws Exception {
        ServerConsumer serverConsumer = (ServerConsumer)brokerConsumer;
        serverConsumer.receiveCredits(-1);
    }

    public void createTemporaryQueue(SimpleString queueName, RoutingType routingType) throws Exception {
        this.createTemporaryQueue(queueName, queueName, routingType, null);
    }

    public void createTemporaryQueue(SimpleString address, SimpleString queueName, RoutingType routingType, SimpleString filter) throws Exception {
        try {
            this.serverSession.createQueue(address, queueName, routingType, filter, true, false);
        }
        catch (ActiveMQSecurityException se) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingTempDestination(se.getMessage());
        }
    }

    public void createUnsharedDurableQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter) throws Exception {
        try {
            this.serverSession.createQueue(address, queueName, routingType, filter, false, true, 1, false, false);
        }
        catch (ActiveMQSecurityException se) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingConsumer(se.getMessage());
        }
    }

    public void createSharedDurableQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter) throws Exception {
        try {
            this.serverSession.createQueue(address, queueName, routingType, filter, false, true, -1, false, false);
        }
        catch (ActiveMQSecurityException se) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingConsumer(se.getMessage());
        }
    }

    public void createSharedVolatileQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter) throws Exception {
        try {
            this.serverSession.createQueue(address, queueName, routingType, filter, false, false, -1, true, true);
        }
        catch (ActiveMQSecurityException se) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.securityErrorCreatingConsumer(se.getMessage());
        }
        catch (ActiveMQQueueExistsException activeMQQueueExistsException) {
            // empty catch block
        }
    }

    public QueueQueryResult queueQuery(SimpleString queueName, RoutingType routingType, boolean autoCreate) throws Exception {
        QueueQueryResult queueQueryResult = this.serverSession.executeQueueQuery(queueName);
        if (!queueQueryResult.isExists() && queueQueryResult.isAutoCreateQueues() && autoCreate) {
            try {
                this.serverSession.createQueue(queueName, queueName, routingType, null, false, true, true);
            }
            catch (ActiveMQQueueExistsException activeMQQueueExistsException) {
                // empty catch block
            }
            queueQueryResult = this.serverSession.executeQueueQuery(queueName);
        }
        if (queueQueryResult.isExists() && !queueQueryResult.isAutoCreated() && routingType != null && queueQueryResult.getRoutingType() != routingType) {
            throw new IllegalStateException("Incorrect Routing Type for queue, expecting: " + routingType);
        }
        return queueQueryResult;
    }

    public boolean checkAddressAndAutocreateIfPossible(SimpleString address, RoutingType routingType) throws Exception {
        boolean result = false;
        SimpleString unPrefixedAddress = this.serverSession.removePrefix(address);
        AddressSettings addressSettings = (AddressSettings)this.manager.getServer().getAddressSettingsRepository().getMatch(unPrefixedAddress.toString());
        if (routingType == RoutingType.MULTICAST) {
            if (this.manager.getServer().getAddressInfo(unPrefixedAddress) == null) {
                if (addressSettings.isAutoCreateAddresses()) {
                    try {
                        this.serverSession.createAddress(address, routingType, true);
                    }
                    catch (ActiveMQAddressExistsException activeMQAddressExistsException) {
                        // empty catch block
                    }
                    result = true;
                }
            } else {
                result = true;
            }
        } else if (routingType == RoutingType.ANYCAST) {
            if (this.manager.getServer().locateQueue(unPrefixedAddress) == null) {
                if (addressSettings.isAutoCreateQueues()) {
                    try {
                        this.serverSession.createQueue(address, address, routingType, null, false, true, true);
                    }
                    catch (ActiveMQQueueExistsException activeMQQueueExistsException) {
                        // empty catch block
                    }
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    public AddressQueryResult addressQuery(SimpleString addressName, RoutingType routingType, boolean autoCreate) throws Exception {
        AddressQueryResult addressQueryResult = this.addressQueryCache.getResult(addressName);
        if (addressQueryResult != null) {
            return addressQueryResult;
        }
        addressQueryResult = this.serverSession.executeAddressQuery(addressName);
        if (!addressQueryResult.isExists() && addressQueryResult.isAutoCreateAddresses() && autoCreate) {
            try {
                this.serverSession.createAddress(addressName, routingType, true);
            }
            catch (ActiveMQQueueExistsException activeMQQueueExistsException) {
                // empty catch block
            }
            addressQueryResult = this.serverSession.executeAddressQuery(addressName);
        }
        this.addressQueryCache.setResult(addressName, addressQueryResult);
        return addressQueryResult;
    }

    public void closeSender(Object brokerConsumer) throws Exception {
        ServerConsumer consumer = (ServerConsumer)brokerConsumer;
        consumer.close(false, true);
        consumer.getQueue().recheckRefCount(this.serverSession.getSessionContext());
    }

    public String tempQueueName() {
        return UUIDGenerator.getInstance().generateStringUUID();
    }

    public void close() throws Exception {
        if (this.serverSession != null) {
            this.sessionExecutor.execute(() -> {
                OperationContext context = this.recoverContext();
                try {
                    try {
                        this.serverSession.close(false);
                    }
                    catch (Exception e) {
                        logger.warn((Object)e.getMessage(), (Throwable)e);
                    }
                }
                finally {
                    this.resetContext(context);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(Transaction transaction, Object brokerConsumer, Message message) throws Exception {
        if (transaction == null) {
            transaction = this.serverSession.getCurrentTransaction();
        }
        OperationContext oldContext = this.recoverContext();
        try {
            ((ServerConsumer)brokerConsumer).individualAcknowledge(transaction, message.getMessageID());
        }
        finally {
            this.resetContext(oldContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Object brokerConsumer, Message message, boolean updateCounts) throws Exception {
        OperationContext oldContext = this.recoverContext();
        try {
            ((ServerConsumer)brokerConsumer).individualCancel(message.getMessageID(), updateCounts, true);
            ((ServerConsumer)brokerConsumer).getQueue().forceDelivery();
        }
        finally {
            this.resetContext(oldContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reject(Object brokerConsumer, Message message) throws Exception {
        OperationContext oldContext = this.recoverContext();
        try {
            ((ServerConsumer)brokerConsumer).reject(message.getMessageID());
        }
        finally {
            this.resetContext(oldContext);
        }
    }

    public void resumeDelivery(Object consumer) {
        ((ServerConsumer)consumer).receiveCredits(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serverSend(ProtonServerReceiverContext context, Transaction transaction, Receiver receiver, Delivery delivery, SimpleString address, int messageFormat, ReadableBuffer data, RoutingContext routingContext) throws Exception {
        AMQPMessage message = new AMQPMessage((long)messageFormat, data, null, this.coreMessageObjectPools);
        if (address != null) {
            message.setAddress(address);
        } else {
            address = message.getAddressSimpleString();
            if (address == null) {
                this.rejectMessage(delivery, Symbol.valueOf((String)"failed"), "Missing 'to' field for message sent to an anonymous producer");
                return;
            }
        }
        RoutingType routingType = context.getRoutingType(receiver, address);
        if (!this.checkAddressAndAutocreateIfPossible(address, routingType)) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist();
        }
        OperationContext oldcontext = this.recoverContext();
        try {
            PagingStore store = this.manager.getServer().getPagingManager().getPageStore(message.getAddressSimpleString());
            if (store != null && store.isRejectingMessages()) {
                String amqpAddress = delivery.getLink().getTarget().getAddress();
                ActiveMQAMQPResourceLimitExceededException e = new ActiveMQAMQPResourceLimitExceededException("Address is full: " + amqpAddress);
                if (!delivery.remotelySettled()) throw e;
                if (transaction == null) return;
                transaction.markAsRollbackOnly((ActiveMQException)e);
                return;
            } else {
                this.serverSend(context, transaction, (Message)message, delivery, receiver, routingContext);
            }
            return;
        }
        finally {
            this.resetContext(oldcontext);
        }
    }

    private void rejectMessage(final Delivery delivery, Symbol errorCondition, String errorMessage) {
        ErrorCondition condition = new ErrorCondition();
        condition.setCondition(errorCondition);
        condition.setDescription(errorMessage);
        final Rejected rejected = new Rejected();
        rejected.setError(condition);
        this.afterIO(new IOCallback(){

            public void done() {
                AMQPSessionCallback.this.connection.runLater(() -> {
                    delivery.disposition((DeliveryState)rejected);
                    delivery.settle();
                    AMQPSessionCallback.this.connection.flush();
                });
            }

            public void onError(int errorCode, String errorMessage) {
            }
        });
    }

    private void serverSend(final ProtonServerReceiverContext context, Transaction transaction, Message message, final Delivery delivery, final Receiver receiver, RoutingContext routingContext) throws Exception {
        message.setConnectionID(receiver.getSession().getConnection().getRemoteContainer());
        this.invokeIncoming((AMQPMessage)message, (ActiveMQProtonRemotingConnection)this.transportConnection.getProtocolConnection());
        this.serverSession.send(transaction, message, this.directDeliver, false, routingContext);
        this.afterIO(new IOCallback(){

            public void done() {
                AMQPSessionCallback.this.connection.runLater(() -> {
                    if (delivery.getRemoteState() instanceof TransactionalState) {
                        TransactionalState txAccepted = new TransactionalState();
                        txAccepted.setOutcome((Outcome)Accepted.getInstance());
                        txAccepted.setTxnId(((TransactionalState)delivery.getRemoteState()).getTxnId());
                        delivery.disposition((DeliveryState)txAccepted);
                    } else {
                        delivery.disposition((DeliveryState)Accepted.getInstance());
                    }
                    delivery.settle();
                    context.flow();
                    AMQPSessionCallback.this.connection.flush();
                });
            }

            public void onError(int errorCode, String errorMessage) {
                AMQPSessionCallback.this.connection.runNow(() -> {
                    receiver.setCondition(new ErrorCondition(AmqpError.ILLEGAL_STATE, errorCode + ":" + errorMessage));
                    AMQPSessionCallback.this.connection.flush();
                });
            }
        });
    }

    public void flow(SimpleString address, Runnable runnable) {
        try {
            PagingManager pagingManager = this.manager.getServer().getPagingManager();
            if (address == null) {
                pagingManager.checkMemory(runnable);
            } else {
                PagingStore store = this.manager.getServer().getPagingManager().getPageStore(address);
                if (store != null) {
                    store.checkMemory(runnable);
                } else {
                    runnable.run();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteQueue(SimpleString queueName) throws Exception {
        this.manager.getServer().destroyQueue(queueName);
    }

    public void resetContext(OperationContext oldContext) {
        this.storageManager.setContext(oldContext);
    }

    public OperationContext recoverContext() {
        OperationContext oldContext = this.storageManager.getContext();
        this.manager.getServer().getStorageManager().setContext(this.serverSession.getSessionContext());
        return oldContext;
    }

    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    public boolean updateDeliveryCountAfterCancel(ServerConsumer consumer, MessageReference ref, boolean failed) {
        return false;
    }

    public void sendProducerCreditsFailMessage(int credits, SimpleString address) {
    }

    public int sendMessage(MessageReference ref, Message message, ServerConsumer consumer, int deliveryCount) {
        ProtonServerSenderContext plugSender = (ProtonServerSenderContext)consumer.getProtocolContext();
        try {
            return plugSender.deliverMessage(ref, consumer);
        }
        catch (Exception e) {
            this.connection.runNow(() -> {
                plugSender.getSender().setCondition(new ErrorCondition(AmqpError.INTERNAL_ERROR, e.getMessage()));
                this.connection.flush();
            });
            throw new IllegalStateException("Can't deliver message " + e, e);
        }
    }

    public int sendLargeMessage(MessageReference ref, Message message, ServerConsumer consumer, long bodySize, int deliveryCount) {
        return 0;
    }

    public int sendLargeMessageContinuation(ServerConsumer consumer, byte[] body, boolean continues, boolean requiresResponse) {
        return 0;
    }

    public void closed() {
    }

    public void disconnect(ServerConsumer consumer, SimpleString queueName) {
        ErrorCondition ec = new ErrorCondition(AmqpSupport.RESOURCE_DELETED, "Queue was deleted: " + queueName);
        this.connection.runNow(() -> {
            try {
                ((ProtonServerSenderContext)consumer.getProtocolContext()).close(ec);
                this.connection.flush();
            }
            catch (ActiveMQAMQPException e) {
                logger.error((Object)("Error closing link for " + consumer.getQueue().getAddress()));
            }
        });
    }

    public boolean hasCredits(ServerConsumer consumer) {
        ProtonServerSenderContext plugSender = (ProtonServerSenderContext)consumer.getProtocolContext();
        if (plugSender != null) {
            return plugSender.hasCredits();
        }
        return false;
    }

    public Transaction getCurrentTransaction() {
        if (this.transactionHandler != null) {
            return this.transactionHandler.getCurrentTransaction();
        }
        return null;
    }

    public Transaction getTransaction(Binary txid, boolean remove) throws ActiveMQAMQPException {
        return this.protonSPI.getTransaction(txid, remove);
    }

    public Binary newTransaction() {
        return this.protonSPI.newTransaction();
    }

    public SimpleString getMatchingQueue(SimpleString address, RoutingType routingType) throws Exception {
        return this.serverSession.getMatchingQueue(address, routingType);
    }

    public SimpleString getMatchingQueue(SimpleString address, SimpleString queueName, RoutingType routingType) throws Exception {
        return this.serverSession.getMatchingQueue(address, queueName, routingType);
    }

    public AddressInfo getAddress(SimpleString address) {
        return this.serverSession.getAddress(address);
    }

    public void removeTemporaryQueue(SimpleString address) throws Exception {
        this.serverSession.deleteQueue(address);
    }

    public RoutingType getDefaultRoutingType(SimpleString address) {
        return ((AddressSettings)this.manager.getServer().getAddressSettingsRepository().getMatch(address.toString())).getDefaultAddressRoutingType();
    }

    public void check(SimpleString address, CheckType checkType, SecurityAuth session) throws Exception {
        this.manager.getServer().getSecurityStore().check(address, checkType, session);
    }

    public void invokeIncoming(AMQPMessage message, ActiveMQProtonRemotingConnection connection) {
        this.protonSPI.invokeIncomingInterceptors(message, connection);
    }

    public void invokeOutgoing(AMQPMessage message, ActiveMQProtonRemotingConnection connection) {
        this.protonSPI.invokeOutgoingInterceptors(message, connection);
    }

    public void addProducer(ServerProducer serverProducer) {
        this.serverSession.addProducer(serverProducer);
    }

    public void removeProducer(String name) {
        this.serverSession.removeProducer(name);
    }

    public void setTransactionHandler(ProtonTransactionHandler transactionHandler) {
        this.transactionHandler = transactionHandler;
    }

    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    public ProtonTransactionHandler getTransactionHandler() {
        return this.transactionHandler;
    }

    static interface CreditRunnable
    extends Runnable {
        public boolean isRun();
    }

    class AddressQueryCache<T> {
        SimpleString address;
        T result;

        AddressQueryCache() {
        }

        public synchronized T getResult(SimpleString parameterAddress) {
            if (this.address != null && this.address.equals((Object)parameterAddress)) {
                return this.result;
            }
            this.result = null;
            this.address = null;
            return null;
        }

        public synchronized void setResult(SimpleString parameterAddress, T result) {
            this.address = parameterAddress;
            this.result = result;
        }
    }
}

