/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersister;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersisterV2;
import org.apache.activemq.artemis.protocol.amqp.broker.AmqpInterceptor;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.AbstractProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.osgi.service.component.annotations.Component;

@Component(service={ProtocolManagerFactory.class})
public class ProtonProtocolManagerFactory
extends AbstractProtocolManagerFactory<AmqpInterceptor> {
    public static final String AMQP_PROTOCOL_NAME = "AMQP";
    private static final String MODULE_NAME = "artemis-amqp-protocol";
    private static String[] SUPPORTED_PROTOCOLS = new String[]{"AMQP"};

    public Persister<Message>[] getPersister() {
        Persister[] persisters = new Persister[]{AMQPMessagePersister.getInstance(), AMQPMessagePersisterV2.getInstance()};
        return persisters;
    }

    public ProtocolManager createProtocolManager(ActiveMQServer server, Map<String, Object> parameters, List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) throws Exception {
        this.stripPasswordParameters(parameters);
        return (ProtocolManager)BeanSupport.setData((Object)((Object)new ProtonProtocolManager(this, server, incomingInterceptors, outgoingInterceptors)), parameters);
    }

    public List<AmqpInterceptor> filterInterceptors(List<BaseInterceptor> interceptors) {
        return this.internalFilterInterceptors(AmqpInterceptor.class, interceptors);
    }

    public String[] getProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

