package org.apache.activemq.artemis.protocol.amqp.logger;

import java.util.Locale;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInvalidFieldException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPSecurityException;
import java.lang.String;
import java.util.Arrays;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2020-11-02T18:46:47-0500")
public class ActiveMQAMQPProtocolMessageBundle_$bundle implements ActiveMQAMQPProtocolMessageBundle, Serializable {
    private static final long serialVersionUID = 1L;
    protected ActiveMQAMQPProtocolMessageBundle_$bundle() {}
    public static final ActiveMQAMQPProtocolMessageBundle_$bundle INSTANCE = new ActiveMQAMQPProtocolMessageBundle_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String targetAddressNotSet$str() {
        return "AMQ119000: target address not set";
    }
    @Override
    public final ActiveMQAMQPInvalidFieldException targetAddressNotSet() {
        final ActiveMQAMQPInvalidFieldException result = new ActiveMQAMQPInvalidFieldException(String.format(getLoggingLocale(), targetAddressNotSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String errorCreatingTemporaryQueue$str() {
        return "AMQ119001: error creating temporary queue, {0}";
    }
    @Override
    public final ActiveMQAMQPInternalErrorException errorCreatingTemporaryQueue(final String message) {
        final ActiveMQAMQPInternalErrorException result = new ActiveMQAMQPInternalErrorException(_formatMessage(errorCreatingTemporaryQueue$str(), message));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    protected String addressDoesntExist$str() {
        return "AMQ119002: target address does not exist";
    }
    @Override
    public final ActiveMQAMQPNotFoundException addressDoesntExist() {
        final ActiveMQAMQPNotFoundException result = new ActiveMQAMQPNotFoundException(String.format(getLoggingLocale(), addressDoesntExist$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorFindingTemporaryQueue$str() {
        return "AMQ119003: error finding temporary queue, {0}";
    }
    @Override
    public final ActiveMQAMQPNotFoundException errorFindingTemporaryQueue(final String message) {
        final ActiveMQAMQPNotFoundException result = new ActiveMQAMQPNotFoundException(_formatMessage(errorFindingTemporaryQueue$str(), message));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorCreatingConsumer$str() {
        return "AMQ119005: error creating consumer, {0}";
    }
    @Override
    public final ActiveMQAMQPInternalErrorException errorCreatingConsumer(final String message) {
        final ActiveMQAMQPInternalErrorException result = new ActiveMQAMQPInternalErrorException(_formatMessage(errorCreatingConsumer$str(), message));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorStartingConsumer$str() {
        return "AMQ119006: error starting consumer, {0}";
    }
    @Override
    public final ActiveMQAMQPIllegalStateException errorStartingConsumer(final String message) {
        final ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(_formatMessage(errorStartingConsumer$str(), message));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorAcknowledgingMessage$str() {
        return "AMQ119007: error acknowledging message {0}, {1}";
    }
    @Override
    public final ActiveMQAMQPIllegalStateException errorAcknowledgingMessage(final String messageID, final String message) {
        final ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(_formatMessage(errorAcknowledgingMessage$str(), messageID, message));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorCancellingMessage$str() {
        return "AMQ119008: error cancelling message {0}, {1}";
    }
    @Override
    public final ActiveMQAMQPIllegalStateException errorCancellingMessage(final String messageID, final String message) {
        final ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(_formatMessage(errorCancellingMessage$str(), messageID, message));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sourceAddressDoesntExist$str() {
        return "AMQ119010: source address does not exist";
    }
    @Override
    public final ActiveMQAMQPNotFoundException sourceAddressDoesntExist() {
        final ActiveMQAMQPNotFoundException result = new ActiveMQAMQPNotFoundException(String.format(getLoggingLocale(), sourceAddressDoesntExist$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sourceAddressNotSet$str() {
        return "AMQ119011: source address not set";
    }
    @Override
    public final ActiveMQAMQPInvalidFieldException sourceAddressNotSet() {
        final ActiveMQAMQPInvalidFieldException result = new ActiveMQAMQPInvalidFieldException(String.format(getLoggingLocale(), sourceAddressNotSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorRollingbackCoordinator$str() {
        return "AMQ119012: error rolling back coordinator: {0}";
    }
    @Override
    public final ActiveMQAMQPIllegalStateException errorRollingbackCoordinator(final String message) {
        final ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(_formatMessage(errorRollingbackCoordinator$str(), message));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorCommittingCoordinator$str() {
        return "AMQ119013: error committing coordinator: {0}";
    }
    @Override
    public final ActiveMQAMQPIllegalStateException errorCommittingCoordinator(final String message) {
        final ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(_formatMessage(errorCommittingCoordinator$str(), message));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String txNotFound$str() {
        return "AMQ119014: Transaction not found: xid={0}";
    }
    @Override
    public final ActiveMQAMQPIllegalStateException txNotFound(final String xidToString) {
        final ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(_formatMessage(txNotFound$str(), xidToString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String securityErrorCreatingConsumer$str() {
        return "AMQ119015: not authorized to create consumer, {0}";
    }
    @Override
    public final ActiveMQAMQPSecurityException securityErrorCreatingConsumer(final String message) {
        final ActiveMQAMQPSecurityException result = new ActiveMQAMQPSecurityException(_formatMessage(securityErrorCreatingConsumer$str(), message));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String securityErrorCreatingTempDestination$str() {
        return "AMQ119016: not authorized to create temporary destination, {0}";
    }
    @Override
    public final ActiveMQAMQPSecurityException securityErrorCreatingTempDestination(final String message) {
        final ActiveMQAMQPSecurityException result = new ActiveMQAMQPSecurityException(_formatMessage(securityErrorCreatingTempDestination$str(), message));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String securityErrorCreatingProducer$str() {
        return "AMQ119017: not authorized to create producer, {0}";
    }
    @Override
    public final ActiveMQAMQPSecurityException securityErrorCreatingProducer(final String message) {
        final ActiveMQAMQPSecurityException result = new ActiveMQAMQPSecurityException(_formatMessage(securityErrorCreatingProducer$str(), message));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
