/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageIdHelper;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSBytesMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMapMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSObjectMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSStreamMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSTextMessage;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.spi.core.protocol.EmbedMessageUtil;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.jboss.logging.Logger;

public class CoreAmqpConverter {
    private static Logger logger = Logger.getLogger(CoreAmqpConverter.class);

    public static AMQPMessage checkAMQP(Message message, StorageManager storageManager) throws Exception {
        if (message instanceof AMQPMessage) {
            return (AMQPMessage)message;
        }
        return CoreAmqpConverter.fromCore(message.toCore(), storageManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMQPMessage fromCore(ICoreMessage coreMessage, StorageManager storageManager) throws Exception {
        long timeStamp;
        Object correlationID;
        Destination replyTo;
        Destination destination;
        String messageId;
        String type;
        byte priority;
        ServerJMSMessage message;
        if (coreMessage == null) {
            return null;
        }
        if (coreMessage.isServerMessage() && coreMessage.isLargeMessage() && coreMessage.getType() == 7 && (message = EmbedMessageUtil.extractEmbedded((ICoreMessage)coreMessage, (StorageManager)storageManager)) instanceof AMQPMessage) {
            return (AMQPMessage)((Object)message);
        }
        message = ServerJMSMessage.wrapCoreMessage(coreMessage);
        message.decode();
        long messageFormat = 0L;
        Header header = null;
        Properties properties = new Properties();
        HashMap<Symbol, Object> daMap = null;
        HashMap<Symbol, Object> maMap = new HashMap<Symbol, Object>();
        HashMap<String, Object> apMap = null;
        HashMap<Symbol, Object> footerMap = null;
        Section body = CoreAmqpConverter.convertBody(message, maMap, properties);
        if (message.getInnerMessage().isDurable()) {
            if (header == null) {
                header = new Header();
            }
            header.setDurable(Boolean.valueOf(true));
        }
        if ((priority = (byte)message.getJMSPriority()) != 4) {
            if (header == null) {
                header = new Header();
            }
            header.setPriority(UnsignedByte.valueOf((byte)priority));
        }
        if ((type = message.getJMSType()) != null) {
            properties.setSubject(type);
        }
        if ((messageId = message.getJMSMessageID()) != null) {
            try {
                properties.setMessageId(AMQPMessageIdHelper.INSTANCE.toIdObject(messageId));
            }
            catch (ActiveMQAMQPIllegalStateException e) {
                properties.setMessageId((Object)messageId);
            }
        } else if (message.getInnerMessage().getUserID() != null) {
            properties.setMessageId((Object)("ID:" + message.getInnerMessage().getUserID().toString()));
        }
        if ((destination = message.getJMSDestination()) != null) {
            properties.setTo(AMQPMessageSupport.toAddress(destination));
            maMap.put(AMQPMessageSupport.JMS_DEST_TYPE_MSG_ANNOTATION, AMQPMessageSupport.destinationType(destination));
        }
        if ((replyTo = message.getJMSReplyTo()) != null) {
            properties.setReplyTo(AMQPMessageSupport.toAddress(replyTo));
            maMap.put(AMQPMessageSupport.JMS_REPLY_TO_TYPE_MSG_ANNOTATION, AMQPMessageSupport.destinationType(replyTo));
        }
        if ((correlationID = message.getInnerMessage().getCorrelationID()) instanceof String || correlationID instanceof SimpleString) {
            String c = correlationID instanceof String ? (String)correlationID : ((SimpleString)correlationID).toString();
            try {
                properties.setCorrelationId(AMQPMessageIdHelper.INSTANCE.toIdObject(c));
            }
            catch (ActiveMQAMQPIllegalStateException e) {
                properties.setCorrelationId(correlationID);
            }
        } else {
            properties.setCorrelationId(correlationID);
        }
        long expiration = message.getJMSExpiration();
        if (expiration != 0L) {
            long ttl = expiration - System.currentTimeMillis();
            if (ttl < 0L) {
                ttl = 1L;
            }
            if (header == null) {
                header = new Header();
            }
            header.setTtl(new UnsignedInteger((int)ttl));
            properties.setAbsoluteExpiryTime(new Date(expiration));
        }
        if ((timeStamp = message.getJMSTimestamp()) != 0L) {
            properties.setCreationTime(new Date(timeStamp));
        }
        Set keySet = MessageUtil.getPropertyNames((Message)message.getInnerMessage());
        for (String key : keySet) {
            Object objectProperty;
            if (key.startsWith("JMSX")) {
                if (key.equals("JMSXUserID")) {
                    String value = message.getStringProperty(key);
                    if (value == null) continue;
                    properties.setUserId(Binary.create((ByteBuffer)StandardCharsets.UTF_8.encode(value)));
                    continue;
                }
                if (key.equals("JMSXGroupID")) {
                    String value = message.getStringProperty(key);
                    properties.setGroupId(value);
                    continue;
                }
                if (key.equals("JMSXGroupSeq")) {
                    int value = message.getIntProperty(key);
                    properties.setGroupSequence(UnsignedInteger.valueOf((int)value));
                    continue;
                }
            } else if (key.startsWith("JMS_AMQP_")) {
                if (key.equals("JMS_AMQP_NATIVE")) continue;
                if (key.equals("JMS_AMQP_FirstAcquirer")) {
                    if (header == null) {
                        header = new Header();
                    }
                    header.setFirstAcquirer(Boolean.valueOf(message.getBooleanProperty(key)));
                    continue;
                }
                if (key.equals("JMS_AMQP_HEADER")) {
                    if (header != null) continue;
                    header = new Header();
                    continue;
                }
                if (key.equals("JMS_AMQP_HEADERDURABLE")) {
                    if (header == null) {
                        header = new Header();
                    }
                    header.setDurable(Boolean.valueOf(message.getInnerMessage().isDurable()));
                    continue;
                }
                if (key.equals("JMS_AMQP_HEADERPRIORITY")) {
                    if (header == null) {
                        header = new Header();
                    }
                    header.setPriority(UnsignedByte.valueOf((byte)priority));
                    continue;
                }
                if (key.startsWith("JMS_AMQP_PROPERTIES")) continue;
                if (key.startsWith("JMS_AMQP_DA_")) {
                    if (daMap == null) {
                        daMap = new HashMap<Symbol, Object>();
                    }
                    String name = key.substring("JMS_AMQP_DA_".length());
                    daMap.put(Symbol.valueOf((String)name), message.getObjectProperty(key));
                    continue;
                }
                if (key.startsWith("JMS_AMQP_ENCODED_DA_")) {
                    if (daMap == null) {
                        daMap = new HashMap();
                    }
                    String name = key.substring("JMS_AMQP_ENCODED_DA_".length());
                    daMap.put(Symbol.valueOf((String)name), CoreAmqpConverter.decodeEmbeddedAMQPType(message.getObjectProperty(key)));
                    continue;
                }
                if (key.startsWith("JMS_AMQP_MA_")) {
                    String name = key.substring("JMS_AMQP_MA_".length());
                    maMap.put(Symbol.valueOf((String)name), message.getObjectProperty(key));
                    continue;
                }
                if (key.startsWith("JMS_AMQP_ENCODED_MA_")) {
                    String name = key.substring("JMS_AMQP_ENCODED_MA_".length());
                    maMap.put(Symbol.valueOf((String)name), CoreAmqpConverter.decodeEmbeddedAMQPType(message.getObjectProperty(key)));
                    continue;
                }
                if (key.equals("JMS_AMQP_ContentType")) {
                    properties.setContentType(Symbol.getSymbol((String)message.getStringProperty(key)));
                    continue;
                }
                if (key.equals("JMS_AMQP_ContentEncoding")) {
                    properties.setContentEncoding(Symbol.getSymbol((String)message.getStringProperty(key)));
                    continue;
                }
                if (key.equals("JMS_AMQP_ReplyToGroupID")) {
                    properties.setReplyToGroupId(message.getStringProperty(key));
                    continue;
                }
                if (key.equals("JMS_AMQP_ORIGINAL_ENCODING")) continue;
                if (key.startsWith("JMS_AMQP_ENCODED_FT_")) {
                    if (footerMap == null) {
                        footerMap = new HashMap<Symbol, Object>();
                    }
                    String name = key.substring("JMS_AMQP_ENCODED_FT_".length());
                    footerMap.put(Symbol.valueOf((String)name), CoreAmqpConverter.decodeEmbeddedAMQPType(message.getObjectProperty(key)));
                    continue;
                }
                if (key.startsWith("JMS_AMQP_FT_")) {
                    if (footerMap == null) {
                        footerMap = new HashMap();
                    }
                    String name = key.substring("JMS_AMQP_FT_".length());
                    footerMap.put(Symbol.valueOf((String)name), message.getObjectProperty(key));
                    continue;
                }
            } else {
                if (key.equals(Message.HDR_GROUP_ID.toString())) {
                    String value = message.getStringProperty(key);
                    properties.setGroupId(value);
                    continue;
                }
                if (key.equals(Message.HDR_GROUP_SEQUENCE.toString())) {
                    int value = message.getIntProperty(key);
                    properties.setGroupSequence(UnsignedInteger.valueOf((int)value));
                    continue;
                }
                if (key.equals("NATIVE_MESSAGE_ID") || key.endsWith(Message.HDR_SCHEDULED_DELIVERY_TIME.toString())) continue;
            }
            if (apMap == null) {
                apMap = new HashMap<String, Object>();
            }
            if ((objectProperty = message.getObjectProperty(key)) instanceof byte[]) {
                objectProperty = new Binary((byte[])objectProperty);
            }
            apMap.put(key, objectProperty);
        }
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
        try {
            EncoderImpl encoder = TLSEncode.getEncoder();
            encoder.setByteBuffer((WritableBuffer)new NettyWritable(buffer));
            if (header != null) {
                encoder.writeObject((Object)header);
            }
            if (daMap != null) {
                encoder.writeObject((Object)new DeliveryAnnotations(daMap));
            }
            encoder.writeObject((Object)new MessageAnnotations(maMap));
            encoder.writeObject((Object)properties);
            if (apMap != null) {
                encoder.writeObject((Object)new ApplicationProperties(apMap));
            }
            if (body != null) {
                encoder.writeObject((Object)body);
            }
            if (footerMap != null) {
                encoder.writeObject((Object)new Footer(footerMap));
            }
            byte[] data = new byte[buffer.writerIndex()];
            buffer.readBytes(data);
            AMQPStandardMessage amqpMessage = new AMQPStandardMessage(messageFormat, data, null);
            amqpMessage.setMessageID(message.getInnerMessage().getMessageID());
            amqpMessage.setReplyTo(coreMessage.getReplyTo());
            AMQPStandardMessage aMQPStandardMessage = amqpMessage;
            return aMQPStandardMessage;
        }
        finally {
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object decodeEmbeddedAMQPType(Object payload) {
        byte[] encodedType = (byte[])payload;
        DecoderImpl decoder = TLSEncode.getDecoder();
        Object decodedType = null;
        decoder.setBuffer((ReadableBuffer)ReadableBuffer.ByteBufferReader.wrap((byte[])encodedType));
        try {
            decodedType = decoder.readObject();
        }
        finally {
            decoder.setBuffer(null);
        }
        return decodedType;
    }

    private static Section convertBody(ServerJMSMessage message, Map<Symbol, Object> maMap, Properties properties) throws JMSException {
        AmqpValue body = null;
        short orignalEncoding = 0;
        try {
            orignalEncoding = message.getShortProperty("JMS_AMQP_ORIGINAL_ENCODING");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (message instanceof ServerJMSBytesMessage) {
            Binary payload = CoreAmqpConverter.getBinaryFromMessageBody((ServerJMSBytesMessage)message);
            maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)3);
            if (payload == null) {
                payload = AMQPMessageSupport.EMPTY_BINARY;
            }
            switch (orignalEncoding) {
                case 1: {
                    break;
                }
                case 6: {
                    body = new AmqpValue((Object)payload);
                    break;
                }
                default: {
                    body = new Data(payload);
                    break;
                }
            }
        } else if (message instanceof ServerJMSTextMessage) {
            String text = ((TextMessage)message).getText();
            switch (orignalEncoding) {
                case 1: {
                    break;
                }
                case 2: {
                    if (text == null) {
                        body = new Data(AMQPMessageSupport.EMPTY_BINARY);
                        break;
                    }
                    body = new Data(new Binary(text.getBytes(StandardCharsets.UTF_8)));
                    break;
                }
                default: {
                    body = new AmqpValue((Object)text);
                }
            }
            maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)5);
        } else if (message instanceof ServerJMSMapMessage) {
            body = new AmqpValue(CoreAmqpConverter.getMapFromMessageBody((ServerJMSMapMessage)message));
            maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)2);
        } else if (message instanceof ServerJMSStreamMessage) {
            maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)4);
            ArrayList<Object> list = new ArrayList<Object>();
            ServerJMSStreamMessage m = (ServerJMSStreamMessage)message;
            try {
                while (true) {
                    list.add(m.readObject());
                }
            }
            catch (MessageEOFException messageEOFException) {
                switch (orignalEncoding) {
                    case 3: {
                        body = new AmqpSequence(list);
                        break;
                    }
                    default: {
                        body = new AmqpValue(list);
                        break;
                    }
                }
            }
        } else if (message instanceof ServerJMSObjectMessage) {
            properties.setContentType(AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE);
            maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)1);
            Binary payload = CoreAmqpConverter.getBinaryFromMessageBody((ServerJMSObjectMessage)message);
            if (payload == null) {
                payload = AMQPMessageSupport.EMPTY_BINARY;
            }
            switch (orignalEncoding) {
                case 6: {
                    body = new AmqpValue((Object)payload);
                    break;
                }
                default: {
                    body = new Data(payload);
                }
            }
            if (!message.propertyExists("JMS_AMQP_ContentType")) {
                message.setStringProperty("JMS_AMQP_ContentType", AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE.toString());
            }
        } else {
            maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)0);
            ICoreMessage internalMessage = message.getInnerMessage();
            ActiveMQBuffer buffer = internalMessage.getDataBuffer();
            try {
                SimpleString s;
                if (buffer.readableBytes() > 0 && (s = buffer.readNullableSimpleString()) != null) {
                    body = new AmqpValue((Object)s.toString());
                }
            }
            catch (Throwable e) {
                logger.debug("Exception ignored during conversion", (Object)e.getMessage(), e);
                body = new AmqpValue((Object)("Conversion to AMQP error: " + e.getMessage()));
            }
        }
        return body;
    }

    private static Binary getBinaryFromMessageBody(ServerJMSBytesMessage message) throws JMSException {
        byte[] data = new byte[(int)message.getBodyLength()];
        message.readBytes(data);
        message.reset();
        return new Binary(data);
    }

    private static Binary getBinaryFromMessageBody(ServerJMSObjectMessage message) throws JMSException {
        return message.getSerializedForm();
    }

    private static Map<String, Object> getMapFromMessageBody(ServerJMSMapMessage message) throws JMSException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Enumeration names = message.getMapNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            Object value = message.getObject(key);
            if (value instanceof byte[]) {
                value = new Binary((byte[])value);
            }
            map.put(key, value);
        }
        return map;
    }
}

