/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.logger;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="AMQ")
public interface ActiveMQAMQPProtocolLogger
extends BasicLogger {
    public static final ActiveMQAMQPProtocolLogger LOGGER = (ActiveMQAMQPProtocolLogger)Logger.getMessageLogger(ActiveMQAMQPProtocolLogger.class, (String)ActiveMQAMQPProtocolLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=111000, value="Scheduled task can't be removed from scheduledPool.", format=Message.Format.MESSAGE_FORMAT)
    public void cantRemovingScheduledTask();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=111001, value="\n*******************************************************************************************************************************\nCould not re-establish AMQP Server Connection {0} on {1} after {2} retries\n*******************************************************************************************************************************\n", format=Message.Format.MESSAGE_FORMAT)
    public void retryConnectionFailed(String var1, String var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111002, value="\n*******************************************************************************************************************************\nRetrying Server AMQP Connection {0} on {1} retry {2} of {3}\n*******************************************************************************************************************************\n", format=Message.Format.MESSAGE_FORMAT)
    public void retryConnection(String var1, String var2, int var3, int var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=111003, value="\n*******************************************************************************************************************************\nSuccess on Server AMQP Connection {0} on {1} after {2} retries\n*******************************************************************************************************************************\n", format=Message.Format.MESSAGE_FORMAT)
    public void successReconnect(String var1, String var2, int var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=111004, value="AddressFullPolicy clash on an anonymous producer between destinations {0}(addressFullPolicy={1}) and {2}(addressFullPolicy={3}). This could lead to semantic inconsistencies on your clients. Notice you could have other instances of this scenario however this message will only be logged once. log.debug output would show all instances of this event.", format=Message.Format.MESSAGE_FORMAT)
    public void incompatibleAddressFullMessagePolicy(String var1, String var2, String var3, String var4);
}

