/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.logger;

import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInvalidFieldException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPSecurityException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="AMQ")
public interface ActiveMQAMQPProtocolMessageBundle {
    public static final ActiveMQAMQPProtocolMessageBundle BUNDLE = (ActiveMQAMQPProtocolMessageBundle)Messages.getBundle(ActiveMQAMQPProtocolMessageBundle.class);

    @Message(id=119000, value="target address not set")
    public ActiveMQAMQPInvalidFieldException targetAddressNotSet();

    @Message(id=119001, value="error creating temporary queue, {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPInternalErrorException errorCreatingTemporaryQueue(String var1);

    @Message(id=119002, value="target address does not exist")
    public ActiveMQAMQPNotFoundException addressDoesntExist();

    @Message(id=119003, value="error finding temporary queue, {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPNotFoundException errorFindingTemporaryQueue(String var1);

    @Message(id=119005, value="error creating consumer, {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPInternalErrorException errorCreatingConsumer(String var1);

    @Message(id=119006, value="error starting consumer, {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException errorStartingConsumer(String var1);

    @Message(id=119007, value="error acknowledging message {0}, {1}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException errorAcknowledgingMessage(String var1, String var2);

    @Message(id=119008, value="error cancelling message {0}, {1}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException errorCancellingMessage(String var1, String var2);

    @Message(id=119010, value="source address does not exist")
    public ActiveMQAMQPNotFoundException sourceAddressDoesntExist();

    @Message(id=119011, value="source address not set")
    public ActiveMQAMQPInvalidFieldException sourceAddressNotSet();

    @Message(id=119012, value="error rolling back coordinator: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException errorRollingbackCoordinator(String var1);

    @Message(id=119013, value="error committing coordinator: {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException errorCommittingCoordinator(String var1);

    @Message(id=119014, value="Transaction not found: xid={0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException txNotFound(String var1);

    @Message(id=119015, value="not authorized to create consumer, {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPSecurityException securityErrorCreatingConsumer(String var1);

    @Message(id=119016, value="not authorized to create temporary destination, {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPSecurityException securityErrorCreatingTempDestination(String var1);

    @Message(id=119017, value="not authorized to create producer, {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPSecurityException securityErrorCreatingProducer(String var1);

    @Message(id=119018, value="link is missing an offered capability declaration {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException missingOfferedCapability(String var1);

    @Message(id=119019, value="There is no brokerID defined on the target connection. Connection will be closed.", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException missingBrokerID();

    @Message(id=119020, value="The Broker Connection Open Callback Has Timed Out.", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException brokerConnectionTimeout();

    @Message(id=119021, value="The broker connection had a remote link closed unexpectedly", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException brokerConnectionRemoteLinkClosed();

    @Message(id=119022, value="The broker connection is trying to connect to itself. Check your configuration.", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException brokerConnectionMirrorItself();

    @Message(id=119023, value="Sender link refused for address {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException senderLinkRefused(String var1);

    @Message(id=119024, value="link is missing a desired capability declaration {0}", format=Message.Format.MESSAGE_FORMAT)
    public ActiveMQAMQPIllegalStateException missingDesiredCapability(String var1);
}

