/** This class is auto generated by org.apache.activemq.artemis.logs.annotation.processor.LogAnnotationProcessor
    and it inherits whatever license is declared at org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolLogger */

package org.apache.activemq.artemis.protocol.amqp.logger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

// @org.apache.activemq.artemis.logs.annotation.LogBundle(regexID="11[0-9]{4}", projectCode="AMQ")
public class ActiveMQAMQPProtocolLogger_impl implements ActiveMQAMQPProtocolLogger
{
   private final Logger logger;

   private static void _copyStackTraceMinusOne(final Throwable e) {
      final StackTraceElement[] st = e.getStackTrace();
      e.setStackTrace(java.util.Arrays.copyOfRange(st, 1, st.length));
   }

   public ActiveMQAMQPProtocolLogger_impl(Logger logger ) {
      this.logger = logger;
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=111000, value=\"Scheduled task can't be removed from scheduledPool.\", level=WARN)
   @Override
   public void cantRemovingScheduledTask() {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ111000: Scheduled task can't be removed from scheduledPool.");
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=111001, value=\"\n*******************************************************************************************************************************\nCould not re-establish AMQP Server Connection {} on {} after {} retries\n*******************************************************************************************************************************\n\", level=WARN)
   @Override
   public void retryConnectionFailed(java.lang.String name, java.lang.String hostAndPort, int currentRetry) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ111001: \n*******************************************************************************************************************************\nCould not re-establish AMQP Server Connection {} on {} after {} retries\n*******************************************************************************************************************************\n", name, hostAndPort, currentRetry);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=111002, value=\"\n*******************************************************************************************************************************\nRetrying Server AMQP Connection {} on {} retry {} of {}\n*******************************************************************************************************************************\n\", level=INFO)
   @Override
   public void retryConnection(java.lang.String name, java.lang.String hostAndPort, int currentRetry, int maxRetry) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ111002: \n*******************************************************************************************************************************\nRetrying Server AMQP Connection {} on {} retry {} of {}\n*******************************************************************************************************************************\n", name, hostAndPort, currentRetry, maxRetry);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=111003, value=\"\n*******************************************************************************************************************************\nConnected on Server AMQP Connection {} on {} after {} retries\n*******************************************************************************************************************************\n\", level=INFO)
   @Override
   public void successReconnect(java.lang.String name, java.lang.String hostAndPort, int currentRetry) {
      if (logger.isInfoEnabled()) {
         logger.info("AMQ111003: \n*******************************************************************************************************************************\nConnected on Server AMQP Connection {} on {} after {} retries\n*******************************************************************************************************************************\n", name, hostAndPort, currentRetry);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=111004, value=\"AddressFullPolicy clash on an anonymous producer between destinations {}(addressFullPolicy={}) and {}(addressFullPolicy={}). This could lead to semantic inconsistencies on your clients. Notice you could have other instances of this scenario however this message will only be logged once. log.debug output would show all instances of this event.\", level=WARN)
   @Override
   public void incompatibleAddressFullMessagePolicy(java.lang.String oldAddress, java.lang.String oldPolicy, java.lang.String newAddress, java.lang.String newPolicy) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ111004: AddressFullPolicy clash on an anonymous producer between destinations {}(addressFullPolicy={}) and {}(addressFullPolicy={}). This could lead to semantic inconsistencies on your clients. Notice you could have other instances of this scenario however this message will only be logged once. log.debug output would show all instances of this event.", oldAddress, oldPolicy, newAddress, newPolicy);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=111005, value=\"Failed to convert message. Sending it to Dead Letter Address.\", level=WARN)
   @Override
   public void messageConversionFailed(java.lang.Throwable t) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ111005: Failed to convert message. Sending it to Dead Letter Address.", t);
      }
   }

   // @org.apache.activemq.artemis.logs.annotation.LogMessage(id=111006, value=\"Unable to send message {} to Dead Letter Address.\", level=WARN)
   @Override
   public void unableToSendMessageToDLA(org.apache.activemq.artemis.core.server.MessageReference ref, java.lang.Throwable t) {
      if (logger.isWarnEnabled()) {
         logger.warn("AMQ111006: Unable to send message {} to Dead Letter Address.", ref, t);
      }
   }

}
