/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotImplementedException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.SenderController;
import org.apache.activemq.artemis.selector.filter.FilterException;
import org.apache.activemq.artemis.selector.impl.SelectorParser;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.qpid.proton.amqp.DescribedType;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.Sender;

public final class AMQPFederationQueueSenderController
implements SenderController {
    private static final Symbol[] OFFERED_LINK_CAPABILITIES = new Symbol[]{AMQPFederationConstants.FEDERATION_QUEUE_RECEIVER};
    private final AMQPSessionContext session;
    private final AMQPSessionCallback sessionSPI;

    public AMQPFederationQueueSenderController(AMQPSessionContext session) {
        this.session = session;
        this.sessionSPI = session.getSessionSPI();
    }

    public AMQPSessionContext getSessionContext() {
        return this.session;
    }

    public AMQPSessionCallback getSessionCallback() {
        return this.sessionSPI;
    }

    @Override
    public Consumer init(ProtonServerSenderContext senderContext) throws Exception {
        SimpleString targetQueue;
        SimpleString targetAddress;
        String selector;
        Sender sender = senderContext.getSender();
        Source source = (Source)sender.getRemoteSource();
        Connection protonConnection = sender.getSession().getConnection();
        Record attachments = protonConnection.attachments();
        if (attachments.get((Object)"FEDERATION_INSTANCE_RECORD", AMQPFederation.class) == null) {
            throw new ActiveMQAMQPIllegalStateException("Cannot create a federation link from non-federation connection");
        }
        if (source == null) {
            throw new ActiveMQAMQPNotImplementedException("Null source lookup not supported on federation links.");
        }
        Map.Entry<Symbol, DescribedType> filter = AmqpSupport.findFilter(source.getFilter(), AmqpSupport.JMS_SELECTOR_FILTER_IDS);
        if (filter != null) {
            selector = filter.getValue().getDescribed().toString();
            try {
                SelectorParser.parse((String)selector);
            }
            catch (FilterException e) {
                throw new ActiveMQAMQPException(AmqpError.INVALID_FIELD, "Invalid filter", ActiveMQExceptionType.INVALID_FILTER_EXPRESSION);
            }
        } else {
            selector = null;
        }
        RoutingType routingType = AMQPFederationQueueSenderController.getRoutingType(source);
        if (CompositeAddress.isFullyQualified((String)source.getAddress())) {
            targetAddress = SimpleString.toSimpleString((String)CompositeAddress.extractAddressName((String)source.getAddress()));
            targetQueue = SimpleString.toSimpleString((String)CompositeAddress.extractQueueName((String)source.getAddress()));
        } else {
            targetAddress = null;
            targetQueue = SimpleString.toSimpleString((String)source.getAddress());
        }
        QueueQueryResult result = this.sessionSPI.queueQuery(targetQueue, routingType, false, null);
        if (!result.isExists()) {
            throw new ActiveMQAMQPNotFoundException("Queue: '" + targetQueue + "' does not exist");
        }
        if (targetAddress != null && !result.getAddress().equals((Object)targetAddress)) {
            throw new ActiveMQAMQPNotFoundException("Queue: '" + targetQueue + "' is not mapped to specified address: " + targetAddress);
        }
        sender.setSenderSettleMode(sender.getRemoteSenderSettleMode());
        sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
        sender.setOfferedCapabilities(OFFERED_LINK_CAPABILITIES);
        return (Consumer)this.sessionSPI.createSender(senderContext, targetQueue, selector, false);
    }

    private static RoutingType getRoutingType(Source source) {
        if (source != null && source.getCapabilities() != null) {
            for (Symbol capability : source.getCapabilities()) {
                if (AmqpSupport.TOPIC_CAPABILITY.equals(capability)) {
                    return RoutingType.MULTICAST;
                }
                if (!AmqpSupport.QUEUE_CAPABILITY.equals(capability)) continue;
                return RoutingType.ANYCAST;
            }
        }
        return ActiveMQDefaultConfiguration.getDefaultRoutingType();
    }

    @Override
    public void close() throws Exception {
    }
}

