/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreMessageWrapper;
import org.apache.activemq.artemis.reader.TextMessageUtil;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;

public class CoreTextMessageWrapper
extends CoreMessageWrapper {
    public static final byte TYPE = 3;
    private SimpleString text;

    public CoreTextMessageWrapper(ICoreMessage message) {
        super(message);
    }

    @Override
    public Section createAMQPSection(Map<Symbol, Object> maMap, Properties properties) {
        AmqpValue body = null;
        String text = this.getText();
        switch (this.getOrignalEncoding()) {
            case 1: {
                break;
            }
            case 2: {
                if (text == null) {
                    body = new Data(AMQPMessageSupport.EMPTY_BINARY);
                    break;
                }
                body = new Data(new Binary(text.getBytes(StandardCharsets.UTF_8)));
                break;
            }
            default: {
                body = new AmqpValue((Object)text);
            }
        }
        maMap.put(AMQPMessageSupport.JMS_MSG_TYPE, (byte)5);
        return body;
    }

    public void setText(String text) {
        this.text = text != null ? SimpleString.of((String)text) : null;
        TextMessageUtil.writeBodyText((ActiveMQBuffer)this.getWriteBodyBuffer(), (SimpleString)this.text);
    }

    public String getText() {
        if (this.text != null) {
            return this.text.toString();
        }
        return null;
    }

    @Override
    public void clearBody() {
        super.clearBody();
        this.text = null;
    }

    @Override
    public void encode() {
        super.encode();
        TextMessageUtil.writeBodyText((ActiveMQBuffer)this.getWriteBodyBuffer(), (SimpleString)this.text);
    }

    @Override
    public void decode() {
        super.decode();
        this.text = TextMessageUtil.readBodyText((ActiveMQBuffer)this.getReadBodyBuffer());
    }
}

