/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.federation.internal;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromResourcePolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationType;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationConsumerInternal;
import org.apache.activemq.artemis.protocol.amqp.federation.internal.FederationInternal;

public abstract class FederationPolicyManager
implements ActiveMQServerBindingPlugin {
    protected final ActiveMQServer server;
    protected final FederationInternal federation;
    protected volatile boolean started;

    public FederationPolicyManager(FederationInternal federation) throws ActiveMQException {
        Objects.requireNonNull(federation, "The Federation instance cannot be null");
        this.federation = federation;
        this.server = federation.getServer();
    }

    public abstract FederationReceiveFromResourcePolicy getPolicy();

    public final FederationType getPolicyType() {
        return this.getPolicy().getPolicyType();
    }

    public final String getPolicyName() {
        return this.getPolicy().getPolicyName();
    }

    public final boolean isStarted() {
        return this.started;
    }

    public FederationInternal getFederation() {
        return this.federation;
    }

    protected abstract void handlePolicyManagerStarted(FederationReceiveFromResourcePolicy var1);

    protected abstract FederationConsumerInternal createFederationConsumer(FederationConsumerInfo var1);

    protected abstract void signalBeforeCreateFederationConsumer(FederationConsumerInfo var1);

    protected abstract void signalAfterCreateFederationConsumer(FederationConsumer var1);

    protected abstract void signalBeforeCloseFederationConsumer(FederationConsumer var1);

    protected abstract void signalAfterCloseFederationConsumer(FederationConsumer var1);
}

