/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.qpid.proton.amqp.Symbol;

public abstract class AMQPBridgePolicy {
    private final Map<String, Object> properties;
    private final String policyName;
    private final String remoteAddress;
    private final String remoteAddressPrefix;
    private final String remoteAddressSuffix;
    private final Collection<Symbol> remoteTerminusCapabilities;
    private final Integer priority;
    private final String filter;
    private final TransformerConfiguration transformerConfig;

    public AMQPBridgePolicy(String policyName, Integer priority, String filter, String remoteAddress, String remoteAddressPrefix, String remoteAddressSuffix, Collection<Symbol> remoteTerminusCapabilities, Map<String, Object> properties, TransformerConfiguration transformerConfig, WildcardConfiguration wildcardConfig) {
        Objects.requireNonNull(policyName, "The provided policy name cannot be null");
        Objects.requireNonNull(wildcardConfig, "The provided wild card configuration cannot be null");
        this.policyName = policyName;
        this.remoteAddress = remoteAddress;
        this.remoteAddressPrefix = remoteAddressPrefix;
        this.remoteAddressSuffix = remoteAddressSuffix;
        this.remoteTerminusCapabilities = remoteTerminusCapabilities;
        this.priority = priority;
        this.filter = filter;
        this.transformerConfig = transformerConfig;
        this.properties = properties == null || properties.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, Object>(properties));
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getRemoteAddressPrefix() {
        return this.remoteAddressPrefix;
    }

    public String getRemoteAddressSuffix() {
        return this.remoteAddressSuffix;
    }

    public Collection<Symbol> getRemoteTerminusCapabilities() {
        return this.remoteTerminusCapabilities;
    }

    public TransformerConfiguration getTransformerConfiguration() {
        return this.transformerConfig;
    }
}

