/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.Events;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASL;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.jboss.logging.Logger;

public class ProtonHandler
extends ProtonInitializable {
    private static final Logger log = Logger.getLogger(ProtonHandler.class);
    private static final byte SASL = 3;
    private static final byte BARE = 0;
    private final Transport transport = Proton.transport();
    private final Connection connection = Proton.connection();
    private final Collector collector = Proton.collector();
    private List<EventHandler> handlers = new ArrayList<EventHandler>();
    private Sasl sasl;
    private ServerSASL chosenMechanism;
    private ClientSASL clientSASLMechanism;
    private final ReentrantLock lock = new ReentrantLock();
    private final long creationTime;
    private final boolean isServer;
    private SASLResult saslResult;
    protected volatile boolean dataReceived;
    protected boolean receivedFirstPacket = false;
    private final Executor flushExecutor;
    protected final ReadyListener readyListener;
    boolean inDispatch = false;

    public ProtonHandler(Executor flushExecutor, boolean isServer) {
        this.flushExecutor = flushExecutor;
        this.readyListener = () -> flushExecutor.execute(() -> this.flush());
        this.creationTime = System.currentTimeMillis();
        this.isServer = isServer;
        try {
            ((TransportInternal)this.transport).setUseReadOnlyOutputBuffer(false);
        }
        catch (NoSuchMethodError nsme) {
            log.trace((Object)"Proton output buffer optimisation unavailable");
        }
        this.transport.bind(this.connection);
        this.connection.collect(this.collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tick(boolean firstTick) {
        this.lock.lock();
        try {
            if (!firstTick) {
                try {
                    if (this.connection.getLocalState() != EndpointState.CLOSED) {
                        long rescheduleAt = this.transport.tick(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
                        if (this.transport.isClosed()) {
                            throw new IllegalStateException("Channel was inactive for to long");
                        }
                        long l = rescheduleAt;
                        return l;
                    }
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                    this.transport.close();
                    this.connection.setCondition(new ErrorCondition());
                }
                long l = 0L;
                return l;
            }
            long l = this.transport.tick(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
            return l;
        }
        finally {
            this.lock.unlock();
            this.flushBytes();
        }
    }

    public int capacity() {
        this.lock.lock();
        try {
            int n = this.transport.capacity();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean tryLock(long time, TimeUnit timeUnit) {
        try {
            return this.lock.tryLock(time, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ProtonHandler addEventHandler(EventHandler handler) {
        this.handlers.add(handler);
        return this;
    }

    public void createServerSASL(String[] mechanisms) {
        this.sasl = this.transport.sasl();
        this.sasl.server();
        this.sasl.setMechanisms(mechanisms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBytes() {
        for (EventHandler handler : this.handlers) {
            if (handler.flowControl(this.readyListener)) continue;
            return;
        }
        this.lock.lock();
        try {
            int pending;
            while ((pending = this.transport.pending()) > 0) {
                ByteBuf buffer = PooledByteBufAllocator.DEFAULT.directBuffer(pending);
                ByteBuffer head = this.transport.head();
                buffer.writeBytes(head);
                for (EventHandler handler : this.handlers) {
                    handler.pushBytes(buffer);
                }
                this.transport.pop(pending);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public SASLResult getSASLResult() {
        return this.saslResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputBuffer(ByteBuf buffer) {
        this.dataReceived = true;
        this.lock.lock();
        try {
            while (buffer.readableBytes() > 0) {
                int capacity = this.transport.capacity();
                if (!this.receivedFirstPacket) {
                    try {
                        byte auth = buffer.getByte(4);
                        if (auth == 3 || auth == 0) {
                            if (this.isServer) {
                                this.dispatchAuth(auth == 3);
                            } else if (auth == 0 && this.clientSASLMechanism == null) {
                                this.dispatchAuthSuccess();
                            }
                            capacity = this.transport.capacity();
                        }
                    }
                    catch (Throwable e) {
                        log.warn((Object)e.getMessage(), e);
                    }
                    this.receivedFirstPacket = true;
                }
                if (capacity > 0) {
                    ByteBuffer tail = this.transport.tail();
                    int min = Math.min(capacity, buffer.readableBytes());
                    tail.limit(min);
                    buffer.readBytes(tail);
                    this.flush();
                    continue;
                }
                if (capacity == 0) {
                    log.debugf("abandoning: readableBytes=%d", buffer.readableBytes());
                } else {
                    log.debugf("transport closed, discarding: readableBytes=%d, capacity=%d", buffer.readableBytes(), this.transport.capacity());
                }
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void flush() {
        this.lock.lock();
        try {
            this.transport.process();
            this.checkSASL();
        }
        finally {
            this.lock.unlock();
        }
        this.dispatch();
    }

    public void close(ErrorCondition errorCondition) {
        this.lock.lock();
        try {
            if (errorCondition != null) {
                this.connection.setCondition(errorCondition);
            }
            this.connection.close();
        }
        finally {
            this.lock.unlock();
        }
        this.flush();
    }

    protected void checkSASL() {
        if (this.isServer) {
            if (this.sasl != null && this.sasl.getRemoteMechanisms().length > 0) {
                if (this.chosenMechanism == null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("SASL chosenMechanism: " + this.sasl.getRemoteMechanisms()[0]));
                    }
                    this.dispatchRemoteMechanismChosen(this.sasl.getRemoteMechanisms()[0]);
                }
                if (this.chosenMechanism != null) {
                    byte[] dataSASL = new byte[this.sasl.pending()];
                    int received = this.sasl.recv(dataSASL, 0, dataSASL.length);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Working on sasl ::" + (received > 0 ? ByteUtil.bytesToHex((byte[])dataSASL, (int)2) : "recv:" + received)));
                    }
                    byte[] response = null;
                    if (received != -1) {
                        response = this.chosenMechanism.processSASL(dataSASL);
                    }
                    if (response != null) {
                        this.sasl.send(response, 0, response.length);
                    }
                    this.saslResult = this.chosenMechanism.result();
                    if (this.saslResult != null) {
                        if (this.saslResult.isSuccess()) {
                            this.saslComplete(Sasl.SaslOutcome.PN_SASL_OK);
                        } else {
                            this.saslComplete(Sasl.SaslOutcome.PN_SASL_AUTH);
                        }
                    }
                } else {
                    this.saslComplete(Sasl.SaslOutcome.PN_SASL_SYS);
                }
            }
        } else if (this.sasl != null) {
            switch (this.sasl.getState()) {
                case PN_SASL_IDLE: {
                    if (this.sasl.getRemoteMechanisms().length == 0) break;
                    this.dispatchMechanismsOffered(this.sasl.getRemoteMechanisms());
                    if (this.clientSASLMechanism == null) {
                        log.infof("Outbound connection failed - unknown mechanism, offered mechanisms: %s", Arrays.asList(this.sasl.getRemoteMechanisms()));
                        this.sasl = null;
                        this.dispatchAuthFailed();
                        break;
                    }
                    this.sasl.setMechanisms(new String[]{this.clientSASLMechanism.getName()});
                    byte[] initialResponse = this.clientSASLMechanism.getInitialResponse();
                    if (initialResponse == null) break;
                    this.sasl.send(initialResponse, 0, initialResponse.length);
                    break;
                }
                case PN_SASL_STEP: {
                    int challengeSize = this.sasl.pending();
                    byte[] challenge = new byte[challengeSize];
                    this.sasl.recv(challenge, 0, challengeSize);
                    byte[] response = this.clientSASLMechanism.getResponse(challenge);
                    this.sasl.send(response, 0, response.length);
                    break;
                }
                case PN_SASL_FAIL: {
                    log.info((Object)"Outbound connection failed, authentication failure");
                    this.sasl = null;
                    this.dispatchAuthFailed();
                    break;
                }
                case PN_SASL_PASS: {
                    log.debug((Object)"Outbound connection succeeded");
                    this.saslResult = new SASLResult(){

                        @Override
                        public String getUser() {
                            return null;
                        }

                        @Override
                        public Subject getSubject() {
                            return null;
                        }

                        @Override
                        public boolean isSuccess() {
                            return true;
                        }
                    };
                    this.sasl = null;
                    this.dispatchAuthSuccess();
                    break;
                }
            }
        }
    }

    private void saslComplete(Sasl.SaslOutcome saslOutcome) {
        this.sasl.done(saslOutcome);
        this.sasl = null;
        if (this.chosenMechanism != null) {
            this.chosenMechanism.done();
        }
    }

    private void dispatchAuthFailed() {
        for (EventHandler h : this.handlers) {
            h.onAuthFailed(this, this.getConnection());
        }
    }

    private void dispatchAuthSuccess() {
        for (EventHandler h : this.handlers) {
            h.onAuthSuccess(this, this.getConnection());
        }
    }

    private void dispatchMechanismsOffered(String[] mechs) {
        for (EventHandler h : this.handlers) {
            h.onSaslMechanismsOffered(this, mechs);
        }
    }

    private void dispatchAuth(boolean sasl) {
        for (EventHandler h : this.handlers) {
            h.onAuthInit(this, this.getConnection(), sasl);
        }
    }

    private void dispatchRemoteMechanismChosen(String mech) {
        for (EventHandler h : this.handlers) {
            h.onSaslRemoteMechanismChosen(this, mech);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() {
        this.lock.lock();
        try {
            if (this.inDispatch) {
                return;
            }
            try {
                Event ev;
                this.inDispatch = true;
                while ((ev = this.collector.peek()) != null) {
                    for (EventHandler h : this.handlers) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Handling " + ev + " towards " + h));
                        }
                        try {
                            Events.dispatch(ev, h);
                        }
                        catch (Exception e) {
                            log.warn((Object)e.getMessage(), (Throwable)e);
                            ErrorCondition error = new ErrorCondition();
                            error.setCondition(AmqpError.INTERNAL_ERROR);
                            error.setDescription("Unrecoverable error: " + (e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage()));
                            this.connection.setCondition(error);
                            this.connection.close();
                        }
                    }
                    this.collector.pop();
                }
            }
            finally {
                this.inDispatch = false;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.flushBytes();
    }

    public void open(String containerId, Map<Symbol, Object> connectionProperties) {
        this.transport.open();
        this.connection.setContainer(containerId);
        this.connection.setProperties(connectionProperties);
        this.connection.open();
        this.flush();
    }

    public void setChosenMechanism(ServerSASL chosenMechanism) {
        this.chosenMechanism = chosenMechanism;
    }

    public void setClientMechanism(ClientSASL saslClientMech) {
        this.clientSASLMechanism = saslClientMech;
    }

    public void createClientSASL() {
        this.sasl = this.transport.sasl();
        this.sasl.client();
    }
}

