/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessageObjectPools;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageIdHelper;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerDestination;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.jms.ServerJMSStreamMessage;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Decimal128;
import org.apache.qpid.proton.amqp.Decimal32;
import org.apache.qpid.proton.amqp.Decimal64;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.WritableBuffer;

public class AmqpCoreConverter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICoreMessage toCore(AMQPMessage message, CoreMessageObjectPools coreMessageObjectPools) throws Exception {
        ServerJMSStreamMessage m;
        ServerJMSMessage result;
        Section body = message.getProtonMessage().getBody();
        if (body == null) {
            Charset charset;
            result = AMQPMessageSupport.isContentType(AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE.toString(), (org.apache.qpid.proton.message.Message)message.getProtonMessage()) ? AMQPMessageSupport.createObjectMessage(message.getMessageID(), coreMessageObjectPools) : (AMQPMessageSupport.isContentType("application/octet-stream", (org.apache.qpid.proton.message.Message)message.getProtonMessage()) || AMQPMessageSupport.isContentType(null, (org.apache.qpid.proton.message.Message)message.getProtonMessage()) ? AMQPMessageSupport.createBytesMessage(message.getMessageID(), coreMessageObjectPools) : ((charset = AMQPMessageSupport.getCharsetForTextualContent(message.getProtonMessage().getContentType())) != null ? AMQPMessageSupport.createTextMessage(message.getMessageID(), coreMessageObjectPools) : AMQPMessageSupport.createMessage(message.getMessageID(), coreMessageObjectPools)));
        } else if (body instanceof Data) {
            Binary payload = ((Data)body).getValue();
            if (AMQPMessageSupport.isContentType(AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE.toString(), (org.apache.qpid.proton.message.Message)message.getProtonMessage())) {
                result = AMQPMessageSupport.createObjectMessage(message.getMessageID(), payload.getArray(), payload.getArrayOffset(), payload.getLength(), coreMessageObjectPools);
            } else if (AMQPMessageSupport.isContentType("application/octet-stream", (org.apache.qpid.proton.message.Message)message.getProtonMessage())) {
                result = AMQPMessageSupport.createBytesMessage(message.getMessageID(), payload.getArray(), payload.getArrayOffset(), payload.getLength(), coreMessageObjectPools);
            } else {
                Charset charset = AMQPMessageSupport.getCharsetForTextualContent(message.getProtonMessage().getContentType());
                if (StandardCharsets.UTF_8.equals(charset)) {
                    ByteBuffer buf = ByteBuffer.wrap(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                    try {
                        CharBuffer chars = charset.newDecoder().decode(buf);
                        result = AMQPMessageSupport.createTextMessage(message.getMessageID(), String.valueOf(chars), coreMessageObjectPools);
                    }
                    catch (CharacterCodingException e) {
                        result = AMQPMessageSupport.createBytesMessage(message.getMessageID(), payload.getArray(), payload.getArrayOffset(), payload.getLength(), coreMessageObjectPools);
                    }
                } else {
                    result = AMQPMessageSupport.createBytesMessage(message.getMessageID(), payload.getArray(), payload.getArrayOffset(), payload.getLength(), coreMessageObjectPools);
                }
            }
        } else if (body instanceof AmqpSequence) {
            AmqpSequence sequence = (AmqpSequence)body;
            m = AMQPMessageSupport.createStreamMessage(message.getMessageID(), coreMessageObjectPools);
            for (Object item : sequence.getValue()) {
                m.writeObject(item);
            }
            result = m;
        } else if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value == null || value instanceof String) {
                result = AMQPMessageSupport.createTextMessage(message.getMessageID(), (String)value, coreMessageObjectPools);
            } else if (value instanceof Binary) {
                Binary payload = (Binary)value;
                result = AMQPMessageSupport.isContentType(AMQPMessageSupport.SERIALIZED_JAVA_OBJECT_CONTENT_TYPE.toString(), (org.apache.qpid.proton.message.Message)message.getProtonMessage()) ? AMQPMessageSupport.createObjectMessage(message.getMessageID(), payload, coreMessageObjectPools) : AMQPMessageSupport.createBytesMessage(message.getMessageID(), payload.getArray(), payload.getArrayOffset(), payload.getLength(), coreMessageObjectPools);
            } else if (value instanceof List) {
                m = AMQPMessageSupport.createStreamMessage(message.getMessageID(), coreMessageObjectPools);
                for (Object item : (List)value) {
                    m.writeObject(item);
                }
                result = m;
            } else if (value instanceof Map) {
                result = AMQPMessageSupport.createMapMessage(message.getMessageID(), (Map)value, coreMessageObjectPools);
            } else {
                ByteBuf buf = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
                try {
                    TLSEncode.getEncoder().setByteBuffer((WritableBuffer)new NettyWritable(buf));
                    TLSEncode.getEncoder().writeObject((Object)body);
                    result = AMQPMessageSupport.createBytesMessage(message.getMessageID(), buf.array(), 0, buf.writerIndex(), coreMessageObjectPools);
                }
                finally {
                    buf.release();
                    TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
                }
            }
        } else {
            throw new RuntimeException("Unexpected body type: " + body.getClass());
        }
        TypedProperties properties = message.getExtraProperties();
        if (properties != null) {
            for (SimpleString str : properties.getPropertyNames()) {
                result.getInnerMessage().putBytesProperty(str, properties.getBytesProperty(str));
            }
        }
        AmqpCoreConverter.populateMessage(result, (org.apache.qpid.proton.message.Message)message.getProtonMessage());
        result.getInnerMessage().setReplyTo(message.getReplyTo());
        result.getInnerMessage().setDurable(message.isDurable());
        result.getInnerMessage().setPriority(message.getPriority());
        result.getInnerMessage().setAddress(message.getAddressSimpleString());
        result.encode();
        return result != null ? result.getInnerMessage() : null;
    }

    protected static ServerJMSMessage populateMessage(ServerJMSMessage jms, org.apache.qpid.proton.message.Message amqp) throws Exception {
        Footer footer;
        Properties properties;
        ApplicationProperties ap;
        MessageAnnotations ma;
        Header header = amqp.getHeader();
        if (header != null) {
            jms.setBooleanProperty("JMS_AMQP_HEADER", true);
            if (header.getDurable() != null) {
                jms.setBooleanProperty("JMS_AMQP_HEADERDURABLE", true);
                jms.setJMSDeliveryMode(header.getDurable() != false ? 2 : 1);
            } else {
                jms.setJMSDeliveryMode(1);
            }
            if (header.getPriority() != null) {
                jms.setBooleanProperty("JMS_AMQP_HEADERPRIORITY", true);
                jms.setJMSPriority(header.getPriority().intValue());
            } else {
                jms.setJMSPriority(4);
            }
            if (header.getFirstAcquirer() != null) {
                jms.setBooleanProperty("JMS_AMQP_FirstAcquirer", header.getFirstAcquirer());
            }
            if (header.getDeliveryCount() != null) {
                jms.setLongProperty("JMSXDeliveryCount", header.getDeliveryCount().longValue() + 1L);
            }
        } else {
            jms.setJMSPriority(4);
            jms.setJMSDeliveryMode(1);
        }
        if ((ma = amqp.getMessageAnnotations()) != null) {
            for (Map.Entry entry : ma.getValue().entrySet()) {
                long delay;
                String string = entry.getKey().toString();
                if ("x-opt-delivery-time".equals(string) && entry.getValue() != null) {
                    long deliveryTime = ((Number)entry.getValue()).longValue();
                    jms.setLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME.toString(), deliveryTime);
                } else if ("x-opt-delivery-delay".equals(string) && entry.getValue() != null && (delay = ((Number)entry.getValue()).longValue()) > 0L) {
                    jms.setLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME.toString(), System.currentTimeMillis() + delay);
                }
                AmqpCoreConverter.setProperty(jms, "JMS_AMQP_MA_" + string, entry.getValue());
            }
        }
        if ((ap = amqp.getApplicationProperties()) != null) {
            for (Map.Entry entry : ap.getValue().entrySet()) {
                AmqpCoreConverter.setProperty(jms, (String)entry.getKey(), entry.getValue());
            }
        }
        if ((properties = amqp.getProperties()) != null) {
            Binary binary;
            if (properties.getMessageId() != null) {
                jms.setJMSMessageID(AMQPMessageIdHelper.INSTANCE.toMessageIdString(properties.getMessageId()));
            }
            if ((binary = properties.getUserId()) != null) {
                jms.setStringProperty("JMSXUserID", new String(binary.getArray(), binary.getArrayOffset(), binary.getLength(), StandardCharsets.UTF_8));
            }
            if (properties.getTo() != null) {
                jms.setJMSDestination((Destination)new ServerDestination(properties.getTo()));
            }
            if (properties.getSubject() != null) {
                jms.setJMSType(properties.getSubject());
            }
            if (properties.getReplyTo() != null) {
                jms.setJMSReplyTo((Destination)new ServerDestination(properties.getReplyTo()));
            }
            if (properties.getCorrelationId() != null) {
                jms.setJMSCorrelationID(AMQPMessageIdHelper.INSTANCE.toCorrelationIdString(properties.getCorrelationId()));
            }
            if (properties.getContentType() != null) {
                jms.setStringProperty("JMS_AMQP_ContentType", properties.getContentType().toString());
            }
            if (properties.getContentEncoding() != null) {
                jms.setStringProperty("JMS_AMQP_ContentEncoding", properties.getContentEncoding().toString());
            }
            if (properties.getCreationTime() != null) {
                jms.setJMSTimestamp(properties.getCreationTime().getTime());
            }
            if (properties.getGroupId() != null) {
                jms.setStringProperty("_AMQ_GROUP_ID", properties.getGroupId());
            }
            if (properties.getGroupSequence() != null) {
                jms.setIntProperty("JMSXGroupSeq", properties.getGroupSequence().intValue());
            }
            if (properties.getReplyToGroupId() != null) {
                jms.setStringProperty("JMS_AMQP_ReplyToGroupID", properties.getReplyToGroupId());
            }
            if (properties.getAbsoluteExpiryTime() != null) {
                jms.setJMSExpiration(properties.getAbsoluteExpiryTime().getTime());
            }
        }
        if (header != null && jms.getJMSExpiration() == 0L) {
            long l = 0L;
            if (header.getTtl() != null) {
                l = header.getTtl().longValue();
            }
            if (l == 0L) {
                jms.setJMSExpiration(0L);
            } else {
                jms.setJMSExpiration(System.currentTimeMillis() + l);
            }
        }
        if ((footer = amqp.getFooter()) != null) {
            for (Map.Entry entry : footer.getValue().entrySet()) {
                String key = entry.getKey().toString();
                AmqpCoreConverter.setProperty(jms, "JMS_AMQP_FT_" + key, entry.getValue());
            }
        }
        return jms;
    }

    private static void setProperty(javax.jms.Message msg, String key, Object value) throws JMSException {
        if (value instanceof UnsignedLong) {
            long v = ((UnsignedLong)value).longValue();
            msg.setLongProperty(key, v);
        } else if (value instanceof UnsignedInteger) {
            long v = ((UnsignedInteger)value).longValue();
            if (Integer.MIN_VALUE <= v && v <= Integer.MAX_VALUE) {
                msg.setIntProperty(key, (int)v);
            } else {
                msg.setLongProperty(key, v);
            }
        } else if (value instanceof UnsignedShort) {
            int v = ((UnsignedShort)value).intValue();
            if (Short.MIN_VALUE <= v && v <= Short.MAX_VALUE) {
                msg.setShortProperty(key, (short)v);
            } else {
                msg.setIntProperty(key, v);
            }
        } else if (value instanceof UnsignedByte) {
            short v = ((UnsignedByte)value).shortValue();
            if (-128 <= v && v <= 127) {
                msg.setByteProperty(key, (byte)v);
            } else {
                msg.setShortProperty(key, v);
            }
        } else if (value instanceof Symbol) {
            msg.setStringProperty(key, value.toString());
        } else if (value instanceof Decimal128) {
            msg.setDoubleProperty(key, ((Decimal128)value).doubleValue());
        } else if (value instanceof Decimal64) {
            msg.setDoubleProperty(key, ((Decimal64)value).doubleValue());
        } else if (value instanceof Decimal32) {
            msg.setFloatProperty(key, ((Decimal32)value).floatValue());
        } else if (value instanceof Binary) {
            msg.setStringProperty(key, value.toString());
        } else {
            msg.setObjectProperty(key, value);
        }
    }
}

