/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.EventHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.handler.Events;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.SASLResult;
import org.apache.activemq.artemis.protocol.amqp.sasl.ServerSASL;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.SaslListener;
import org.apache.qpid.proton.engine.Transport;
import org.apache.qpid.proton.engine.impl.TransportInternal;
import org.jboss.logging.Logger;

public class ProtonHandler
extends ProtonInitializable
implements SaslListener {
    private static final Logger log = Logger.getLogger(ProtonHandler.class);
    private static final byte SASL = 3;
    private static final byte BARE = 0;
    private final Transport transport = Proton.transport();
    private final Connection connection = Proton.connection();
    private final Collector collector = Proton.collector();
    private List<EventHandler> handlers = new ArrayList<EventHandler>();
    private ServerSASL chosenMechanism;
    private ClientSASL clientSASLMechanism;
    private final ReentrantLock lock = new ReentrantLock();
    private final long creationTime;
    private final boolean isServer;
    private SASLResult saslResult;
    protected volatile boolean dataReceived;
    protected boolean receivedFirstPacket = false;
    private final Executor flushExecutor;
    protected final ReadyListener readyListener;
    boolean inDispatch = false;

    public ProtonHandler(Executor flushExecutor, boolean isServer) {
        this.flushExecutor = flushExecutor;
        this.readyListener = () -> flushExecutor.execute(() -> this.flush());
        this.creationTime = System.currentTimeMillis();
        this.isServer = isServer;
        try {
            ((TransportInternal)this.transport).setUseReadOnlyOutputBuffer(false);
        }
        catch (NoSuchMethodError nsme) {
            log.trace((Object)"Proton output buffer optimisation unavailable");
        }
        this.transport.bind(this.connection);
        this.connection.collect(this.collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tick(boolean firstTick) {
        this.lock.lock();
        try {
            if (!firstTick) {
                try {
                    if (this.connection.getLocalState() != EndpointState.CLOSED) {
                        long rescheduleAt = this.transport.tick(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
                        if (this.transport.isClosed()) {
                            throw new IllegalStateException("Channel was inactive for to long");
                        }
                        long l = rescheduleAt;
                        return l;
                    }
                }
                catch (Exception e) {
                    log.warn((Object)e.getMessage(), (Throwable)e);
                    this.transport.close();
                    this.connection.setCondition(new ErrorCondition());
                }
                long l = 0L;
                return l;
            }
            long l = this.transport.tick(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
            return l;
        }
        finally {
            this.lock.unlock();
            this.flushBytes();
        }
    }

    public void scheduledFlush() {
        if (this.receivedFirstPacket) {
            this.flush();
        }
    }

    public int capacity() {
        this.lock.lock();
        try {
            int n = this.transport.capacity();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean tryLock(long time, TimeUnit timeUnit) {
        try {
            return this.lock.tryLock(time, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public ProtonHandler addEventHandler(EventHandler handler) {
        this.handlers.add(handler);
        return this;
    }

    public void createServerSASL(String[] mechanisms) {
        Sasl sasl = this.transport.sasl();
        sasl.server();
        sasl.setMechanisms(mechanisms);
        sasl.setListener((SaslListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBytes() {
        for (EventHandler handler : this.handlers) {
            if (handler.flowControl(this.readyListener)) continue;
            return;
        }
        this.lock.lock();
        try {
            ByteBuffer head;
            int pending;
            while ((pending = (head = this.transport.head()).remaining()) > 0) {
                ByteBuf buffer = PooledByteBufAllocator.DEFAULT.directBuffer(pending);
                buffer.writeBytes(head);
                for (EventHandler handler : this.handlers) {
                    handler.pushBytes(buffer);
                }
                this.transport.pop(pending);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public SASLResult getSASLResult() {
        return this.saslResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputBuffer(ByteBuf buffer) {
        this.dataReceived = true;
        this.lock.lock();
        try {
            while (buffer.readableBytes() > 0) {
                int capacity = this.transport.capacity();
                if (!this.receivedFirstPacket) {
                    try {
                        byte auth = buffer.getByte(4);
                        if (auth == 3 || auth == 0) {
                            if (this.isServer) {
                                this.dispatchAuth(auth == 3);
                            } else if (auth == 0 && this.clientSASLMechanism == null) {
                                this.dispatchAuthSuccess();
                            }
                            capacity = this.transport.capacity();
                        }
                    }
                    catch (Throwable e) {
                        log.warn((Object)e.getMessage(), e);
                    }
                    this.receivedFirstPacket = true;
                }
                if (capacity > 0) {
                    ByteBuffer tail = this.transport.tail();
                    int min = Math.min(capacity, buffer.readableBytes());
                    tail.limit(min);
                    buffer.readBytes(tail);
                    this.flush();
                    continue;
                }
                if (capacity == 0) {
                    log.debugf("abandoning: readableBytes=%d", buffer.readableBytes());
                } else {
                    log.debugf("transport closed, discarding: readableBytes=%d, capacity=%d", buffer.readableBytes(), this.transport.capacity());
                }
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean checkDataReceived() {
        boolean res = this.dataReceived;
        this.dataReceived = false;
        return res;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void flush() {
        this.lock.lock();
        try {
            this.transport.process();
        }
        finally {
            this.lock.unlock();
        }
        this.dispatch();
    }

    public void close(ErrorCondition errorCondition) {
        this.lock.lock();
        try {
            if (errorCondition != null) {
                this.connection.setCondition(errorCondition);
            }
            this.connection.close();
        }
        finally {
            this.lock.unlock();
        }
        this.flush();
    }

    public void onSaslInit(Sasl sasl, Transport transport) {
        log.debug((Object)("onSaslInit: " + sasl));
        this.dispatchRemoteMechanismChosen(sasl.getRemoteMechanisms()[0]);
        if (this.chosenMechanism != null) {
            this.processPending(sasl);
        } else {
            this.saslComplete(sasl, Sasl.SaslOutcome.PN_SASL_SYS);
        }
    }

    private void processPending(Sasl sasl) {
        byte[] response;
        byte[] dataSASL = new byte[sasl.pending()];
        int received = sasl.recv(dataSASL, 0, dataSASL.length);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Working on sasl, length:" + received));
        }
        if ((response = this.chosenMechanism.processSASL((byte[])(received != -1 ? dataSASL : null))) != null) {
            sasl.send(response, 0, response.length);
        }
        this.saslResult = this.chosenMechanism.result();
        if (this.saslResult != null) {
            if (this.saslResult.isSuccess()) {
                this.saslComplete(sasl, Sasl.SaslOutcome.PN_SASL_OK);
            } else {
                this.saslComplete(sasl, Sasl.SaslOutcome.PN_SASL_AUTH);
            }
        }
    }

    public void onSaslResponse(Sasl sasl, Transport transport) {
        log.debug((Object)("onSaslResponse: " + sasl));
        this.processPending(sasl);
    }

    public void onSaslMechanisms(Sasl sasl, Transport transport) {
        this.dispatchMechanismsOffered(sasl.getRemoteMechanisms());
        if (this.clientSASLMechanism == null) {
            log.infof("Outbound connection failed - unknown mechanism, offered mechanisms: %s", Arrays.asList(sasl.getRemoteMechanisms()));
            this.dispatchAuthFailed();
        } else {
            sasl.setMechanisms(new String[]{this.clientSASLMechanism.getName()});
            byte[] initialResponse = this.clientSASLMechanism.getInitialResponse();
            if (initialResponse != null) {
                sasl.send(initialResponse, 0, initialResponse.length);
            }
        }
    }

    public void onSaslChallenge(Sasl sasl, Transport transport) {
        int challengeSize = sasl.pending();
        byte[] challenge = new byte[challengeSize];
        sasl.recv(challenge, 0, challengeSize);
        byte[] response = this.clientSASLMechanism.getResponse(challenge);
        sasl.send(response, 0, response.length);
    }

    public void onSaslOutcome(Sasl sasl, Transport transport) {
        log.debug((Object)("onSaslOutcome: " + sasl));
        switch (sasl.getState()) {
            case PN_SASL_FAIL: {
                log.info((Object)"Outbound connection failed, authentication failure");
                this.dispatchAuthFailed();
                break;
            }
            case PN_SASL_PASS: {
                log.debug((Object)"Outbound connection succeeded");
                if (sasl.pending() != 0) {
                    byte[] additionalData = new byte[sasl.pending()];
                    sasl.recv(additionalData, 0, additionalData.length);
                    this.clientSASLMechanism.getResponse(additionalData);
                }
                this.saslResult = new SASLResult(){

                    @Override
                    public String getUser() {
                        return null;
                    }

                    @Override
                    public Subject getSubject() {
                        return null;
                    }

                    @Override
                    public boolean isSuccess() {
                        return true;
                    }
                };
                this.dispatchAuthSuccess();
                break;
            }
        }
    }

    private void saslComplete(Sasl sasl, Sasl.SaslOutcome saslOutcome) {
        log.debug((Object)("saslComplete: " + sasl));
        sasl.done(saslOutcome);
        if (this.chosenMechanism != null) {
            this.chosenMechanism.done();
            this.chosenMechanism = null;
        }
    }

    private void dispatchAuthFailed() {
        for (EventHandler h : this.handlers) {
            h.onAuthFailed(this, this.getConnection());
        }
    }

    private void dispatchAuthSuccess() {
        for (EventHandler h : this.handlers) {
            h.onAuthSuccess(this, this.getConnection());
        }
    }

    private void dispatchMechanismsOffered(String[] mechs) {
        for (EventHandler h : this.handlers) {
            h.onSaslMechanismsOffered(this, mechs);
        }
    }

    private void dispatchAuth(boolean sasl) {
        for (EventHandler h : this.handlers) {
            h.onAuthInit(this, this.getConnection(), sasl);
        }
    }

    private void dispatchRemoteMechanismChosen(String mech) {
        for (EventHandler h : this.handlers) {
            h.onSaslRemoteMechanismChosen(this, mech);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() {
        this.lock.lock();
        try {
            if (this.inDispatch) {
                return;
            }
            try {
                Event ev;
                this.inDispatch = true;
                while ((ev = this.collector.peek()) != null) {
                    for (EventHandler h : this.handlers) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Handling " + ev + " towards " + h));
                        }
                        try {
                            Events.dispatch(ev, h);
                        }
                        catch (Exception e) {
                            log.warn((Object)e.getMessage(), (Throwable)e);
                            ErrorCondition error = new ErrorCondition();
                            error.setCondition(AmqpError.INTERNAL_ERROR);
                            error.setDescription("Unrecoverable error: " + (e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage()));
                            this.connection.setCondition(error);
                            this.connection.close();
                        }
                    }
                    this.collector.pop();
                }
            }
            finally {
                this.inDispatch = false;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.flushBytes();
    }

    public void open(String containerId, Map<Symbol, Object> connectionProperties) {
        this.transport.open();
        this.connection.setContainer(containerId);
        this.connection.setProperties(connectionProperties);
        this.connection.open();
        this.flush();
    }

    public void setChosenMechanism(ServerSASL chosenMechanism) {
        this.chosenMechanism = chosenMechanism;
    }

    public void setClientMechanism(ClientSASL saslClientMech) {
        this.clientSASLMechanism = saslClientMech;
    }

    public void createClientSASL() {
        Sasl sasl = this.transport.sasl();
        sasl.client();
        sasl.setListener((SaslListener)this);
    }
}

