/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.logger;

import java.io.Serializable;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInvalidFieldException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPSecurityException;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;

public class ActiveMQAMQPProtocolMessageBundle_$bundle
implements ActiveMQAMQPProtocolMessageBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ActiveMQAMQPProtocolMessageBundle_$bundle INSTANCE = new ActiveMQAMQPProtocolMessageBundle_$bundle();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String targetAddressNotSet = "AMQ119000: target address not set";
    private static final String errorCreatingTemporaryQueue = "AMQ119001: error creating temporary queue, {0}";
    private static final String addressDoesntExist = "AMQ119002: target address does not exist";
    private static final String errorFindingTemporaryQueue = "AMQ119003: error finding temporary queue, {0}";
    private static final String errorCreatingConsumer = "AMQ119005: error creating consumer, {0}";
    private static final String errorStartingConsumer = "AMQ119006: error starting consumer, {0}";
    private static final String errorAcknowledgingMessage = "AMQ119007: error acknowledging message {0}, {1}";
    private static final String errorCancellingMessage = "AMQ119008: error cancelling message {0}, {1}";
    private static final String sourceAddressDoesntExist = "AMQ119010: source address does not exist";
    private static final String sourceAddressNotSet = "AMQ119011: source address not set";
    private static final String errorRollingbackCoordinator = "AMQ119012: error rolling back coordinator: {0}";
    private static final String errorCommittingCoordinator = "AMQ119013: error committing coordinator: {0}";
    private static final String txNotFound = "AMQ119014: Transaction not found: xid={0}";
    private static final String securityErrorCreatingConsumer = "AMQ119015: not authorized to create consumer, {0}";
    private static final String securityErrorCreatingTempDestination = "AMQ119016: not authorized to create temporary destination, {0}";
    private static final String securityErrorCreatingProducer = "AMQ119017: not authorized to create producer, {0}";

    protected ActiveMQAMQPProtocolMessageBundle_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String targetAddressNotSet$str() {
        return targetAddressNotSet;
    }

    @Override
    public final ActiveMQAMQPInvalidFieldException targetAddressNotSet() {
        ActiveMQAMQPInvalidFieldException result = new ActiveMQAMQPInvalidFieldException(String.format(this.getLoggingLocale(), this.targetAddressNotSet$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCreatingTemporaryQueue$str() {
        return errorCreatingTemporaryQueue;
    }

    @Override
    public final ActiveMQAMQPInternalErrorException errorCreatingTemporaryQueue(String message) {
        ActiveMQAMQPInternalErrorException result = new ActiveMQAMQPInternalErrorException(this._formatMessage(this.errorCreatingTemporaryQueue$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    private String _formatMessage(String format, Object ... args) {
        MessageFormat formatter = new MessageFormat(format, this.getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new FieldPosition(0)).toString();
    }

    protected String addressDoesntExist$str() {
        return addressDoesntExist;
    }

    @Override
    public final ActiveMQAMQPNotFoundException addressDoesntExist() {
        ActiveMQAMQPNotFoundException result = new ActiveMQAMQPNotFoundException(String.format(this.getLoggingLocale(), this.addressDoesntExist$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorFindingTemporaryQueue$str() {
        return errorFindingTemporaryQueue;
    }

    @Override
    public final ActiveMQAMQPNotFoundException errorFindingTemporaryQueue(String message) {
        ActiveMQAMQPNotFoundException result = new ActiveMQAMQPNotFoundException(this._formatMessage(this.errorFindingTemporaryQueue$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCreatingConsumer$str() {
        return errorCreatingConsumer;
    }

    @Override
    public final ActiveMQAMQPInternalErrorException errorCreatingConsumer(String message) {
        ActiveMQAMQPInternalErrorException result = new ActiveMQAMQPInternalErrorException(this._formatMessage(this.errorCreatingConsumer$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorStartingConsumer$str() {
        return errorStartingConsumer;
    }

    @Override
    public final ActiveMQAMQPIllegalStateException errorStartingConsumer(String message) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.errorStartingConsumer$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorAcknowledgingMessage$str() {
        return errorAcknowledgingMessage;
    }

    @Override
    public final ActiveMQAMQPIllegalStateException errorAcknowledgingMessage(String messageID, String message) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.errorAcknowledgingMessage$str(), messageID, message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCancellingMessage$str() {
        return errorCancellingMessage;
    }

    @Override
    public final ActiveMQAMQPIllegalStateException errorCancellingMessage(String messageID, String message) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.errorCancellingMessage$str(), messageID, message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sourceAddressDoesntExist$str() {
        return sourceAddressDoesntExist;
    }

    @Override
    public final ActiveMQAMQPNotFoundException sourceAddressDoesntExist() {
        ActiveMQAMQPNotFoundException result = new ActiveMQAMQPNotFoundException(String.format(this.getLoggingLocale(), this.sourceAddressDoesntExist$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sourceAddressNotSet$str() {
        return sourceAddressNotSet;
    }

    @Override
    public final ActiveMQAMQPInvalidFieldException sourceAddressNotSet() {
        ActiveMQAMQPInvalidFieldException result = new ActiveMQAMQPInvalidFieldException(String.format(this.getLoggingLocale(), this.sourceAddressNotSet$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorRollingbackCoordinator$str() {
        return errorRollingbackCoordinator;
    }

    @Override
    public final ActiveMQAMQPIllegalStateException errorRollingbackCoordinator(String message) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.errorRollingbackCoordinator$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String errorCommittingCoordinator$str() {
        return errorCommittingCoordinator;
    }

    @Override
    public final ActiveMQAMQPIllegalStateException errorCommittingCoordinator(String message) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.errorCommittingCoordinator$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String txNotFound$str() {
        return txNotFound;
    }

    @Override
    public final ActiveMQAMQPIllegalStateException txNotFound(String xidToString) {
        ActiveMQAMQPIllegalStateException result = new ActiveMQAMQPIllegalStateException(this._formatMessage(this.txNotFound$str(), xidToString));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String securityErrorCreatingConsumer$str() {
        return securityErrorCreatingConsumer;
    }

    @Override
    public final ActiveMQAMQPSecurityException securityErrorCreatingConsumer(String message) {
        ActiveMQAMQPSecurityException result = new ActiveMQAMQPSecurityException(this._formatMessage(this.securityErrorCreatingConsumer$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String securityErrorCreatingTempDestination$str() {
        return securityErrorCreatingTempDestination;
    }

    @Override
    public final ActiveMQAMQPSecurityException securityErrorCreatingTempDestination(String message) {
        ActiveMQAMQPSecurityException result = new ActiveMQAMQPSecurityException(this._formatMessage(this.securityErrorCreatingTempDestination$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String securityErrorCreatingProducer$str() {
        return securityErrorCreatingProducer;
    }

    @Override
    public final ActiveMQAMQPSecurityException securityErrorCreatingProducer(String message) {
        ActiveMQAMQPSecurityException result = new ActiveMQAMQPSecurityException(this._formatMessage(this.securityErrorCreatingProducer$str(), message));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

