/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.broker;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersisterV2;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageIdHelper;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.AmqpCoreConverter;
import org.apache.activemq.artemis.protocol.amqp.util.NettyReadable;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedLong;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.DroppingWritableBuffer;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.codec.TypeConstructor;
import org.apache.qpid.proton.codec.WritableBuffer;
import org.apache.qpid.proton.message.Message;
import org.apache.qpid.proton.message.impl.MessageImpl;

public class AMQPMessage
extends RefCountMessage {
    public static final SimpleString ADDRESS_PROPERTY = SimpleString.toSimpleString((String)"_AMQ_AD");
    public static final int DEFAULT_MESSAGE_FORMAT = 0;
    public static final int DEFAULT_MESSAGE_PRIORITY = 4;
    public static final int MAX_MESSAGE_PRIORITY = 9;
    private static final int VALUE_NOT_PRESENT = -1;
    private ReadableBuffer data;
    private boolean messageDataScanned;
    private boolean modified;
    private int headerPosition = -1;
    private int encodedHeaderSize;
    private int deliveryAnnotationsPosition = -1;
    private int encodedDeliveryAnnotationsSize;
    private int messageAnnotationsPosition = -1;
    private int propertiesPosition = -1;
    private int applicationPropertiesPosition = -1;
    private int remainingBodyPosition = -1;
    private final long messageFormat;
    private long messageID;
    private SimpleString address;
    private volatile int memoryEstimate = -1;
    private long expiration;
    private long scheduledTime = -1L;
    private Header header;
    private MessageAnnotations messageAnnotations;
    private Properties properties;
    private ApplicationProperties applicationProperties;
    private String connectionID;
    private final CoreMessageObjectPools coreMessageObjectPools;
    private Set<Object> rejectedConsumers;
    private DeliveryAnnotations deliveryAnnotationsForSendBuffer;
    private volatile TypedProperties extraProperties;

    public AMQPMessage(long messageFormat, byte[] data, TypedProperties extraProperties) {
        this(messageFormat, data, extraProperties, null);
    }

    public AMQPMessage(long messageFormat, byte[] data, TypedProperties extraProperties, CoreMessageObjectPools coreMessageObjectPools) {
        this(messageFormat, (ReadableBuffer)ReadableBuffer.ByteBufferReader.wrap((byte[])data), extraProperties, coreMessageObjectPools);
    }

    public AMQPMessage(long messageFormat, ReadableBuffer data, TypedProperties extraProperties, CoreMessageObjectPools coreMessageObjectPools) {
        this.data = data;
        this.messageFormat = messageFormat;
        this.coreMessageObjectPools = coreMessageObjectPools;
        this.extraProperties = extraProperties == null ? null : new TypedProperties(extraProperties);
        this.ensureMessageDataScanned();
    }

    AMQPMessage(long messageFormat) {
        this.messageFormat = messageFormat;
        this.modified = true;
        this.coreMessageObjectPools = null;
    }

    public MessageImpl getProtonMessage() {
        this.ensureMessageDataScanned();
        this.ensureDataIsValid();
        MessageImpl protonMessage = null;
        if (this.data != null) {
            protonMessage = (MessageImpl)Message.Factory.create();
            this.data.rewind();
            protonMessage.decode(this.data.duplicate());
        }
        return protonMessage;
    }

    public Header getHeader() {
        this.ensureMessageDataScanned();
        this.ensureDataIsValid();
        return (Header)this.scanForMessageSection(this.headerPosition, Header.class);
    }

    public DeliveryAnnotations getDeliveryAnnotations() {
        this.ensureMessageDataScanned();
        this.ensureDataIsValid();
        return (DeliveryAnnotations)this.scanForMessageSection(this.deliveryAnnotationsPosition, DeliveryAnnotations.class);
    }

    public void setDeliveryAnnotationsForSendBuffer(DeliveryAnnotations deliveryAnnotations) {
        this.deliveryAnnotationsForSendBuffer = deliveryAnnotations;
    }

    public MessageAnnotations getMessageAnnotations() {
        this.ensureMessageDataScanned();
        this.ensureDataIsValid();
        return (MessageAnnotations)this.scanForMessageSection(this.messageAnnotationsPosition, MessageAnnotations.class);
    }

    public Properties getProperties() {
        this.ensureMessageDataScanned();
        this.ensureDataIsValid();
        return (Properties)this.scanForMessageSection(this.propertiesPosition, Properties.class);
    }

    public ApplicationProperties getApplicationProperties() {
        this.ensureMessageDataScanned();
        this.ensureDataIsValid();
        return (ApplicationProperties)this.scanForMessageSection(this.applicationPropertiesPosition, ApplicationProperties.class);
    }

    public Section getBody() {
        this.ensureMessageDataScanned();
        this.ensureDataIsValid();
        return (Section)this.scanForMessageSection(Math.max(0, this.remainingBodyPosition), AmqpSequence.class, AmqpValue.class, Data.class);
    }

    public Footer getFooter() {
        this.ensureMessageDataScanned();
        this.ensureDataIsValid();
        return (Footer)this.scanForMessageSection(Math.max(0, this.remainingBodyPosition), Footer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T scanForMessageSection(int scanStartPosition, Class ... targetTypes) {
        this.ensureMessageDataScanned();
        if (scanStartPosition == -1) {
            return null;
        }
        ReadableBuffer buffer = this.data.duplicate().position(0);
        DecoderImpl decoder = TLSEncode.getDecoder();
        buffer.position(scanStartPosition);
        Object section = null;
        decoder.setBuffer(buffer);
        try {
            while (buffer.hasRemaining()) {
                TypeConstructor constructor = decoder.readConstructor();
                for (Class type : targetTypes) {
                    if (!type.equals(constructor.getTypeClass())) continue;
                    Object object = section = constructor.readValue();
                    return (T)object;
                }
                constructor.skipValue();
            }
        }
        finally {
            decoder.setBuffer(null);
        }
        return (T)section;
    }

    private ApplicationProperties lazyDecodeApplicationProperties() {
        if (this.applicationProperties == null && this.applicationPropertiesPosition != -1) {
            this.applicationProperties = (ApplicationProperties)this.scanForMessageSection(this.applicationPropertiesPosition, ApplicationProperties.class);
        }
        return this.applicationProperties;
    }

    private Map<String, Object> getApplicationPropertiesMap(boolean createIfAbsent) {
        ApplicationProperties appMap = this.lazyDecodeApplicationProperties();
        HashMap map = null;
        if (appMap != null) {
            map = appMap.getValue();
        }
        if (map == null) {
            if (createIfAbsent) {
                map = new HashMap();
                this.applicationProperties = new ApplicationProperties(map);
            } else {
                map = Collections.EMPTY_MAP;
            }
        }
        return map;
    }

    private Map<Symbol, Object> getMessageAnnotationsMap(boolean createIfAbsent) {
        HashMap map = null;
        if (this.messageAnnotations != null) {
            map = this.messageAnnotations.getValue();
        }
        if (map == null) {
            if (createIfAbsent) {
                map = new HashMap();
                this.messageAnnotations = new MessageAnnotations(map);
            } else {
                map = Collections.EMPTY_MAP;
            }
        }
        return map;
    }

    private Object getMessageAnnotation(String annotation) {
        return this.getMessageAnnotation(Symbol.getSymbol((String)annotation));
    }

    private Object getMessageAnnotation(Symbol annotation) {
        return this.getMessageAnnotationsMap(false).get(annotation);
    }

    private Object removeMessageAnnotation(Symbol annotation) {
        return this.getMessageAnnotationsMap(false).remove(annotation);
    }

    private void setMessageAnnotation(String annotation, Object value) {
        this.setMessageAnnotation(Symbol.getSymbol((String)annotation), value);
    }

    private void setMessageAnnotation(Symbol annotation, Object value) {
        this.getMessageAnnotationsMap(true).put(annotation, value);
    }

    private synchronized void ensureMessageDataScanned() {
        if (!this.messageDataScanned) {
            this.scanMessageData();
            this.messageDataScanned = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void scanMessageData() {
        DecoderImpl decoder = TLSEncode.getDecoder();
        decoder.setBuffer(this.data.rewind());
        this.header = null;
        this.messageAnnotations = null;
        this.properties = null;
        this.applicationProperties = null;
        this.expiration = 0L;
        this.encodedHeaderSize = 0;
        this.memoryEstimate = -1;
        this.scheduledTime = -1L;
        this.encodedDeliveryAnnotationsSize = 0;
        this.headerPosition = -1;
        this.deliveryAnnotationsPosition = -1;
        this.propertiesPosition = -1;
        this.applicationPropertiesPosition = -1;
        this.remainingBodyPosition = -1;
        try {
            while (this.data.hasRemaining()) {
                int constructorPos = this.data.position();
                TypeConstructor constructor = decoder.readConstructor();
                if (Header.class.equals((Object)constructor.getTypeClass())) {
                    this.header = (Header)constructor.readValue();
                    this.headerPosition = constructorPos;
                    this.encodedHeaderSize = this.data.position();
                    if (this.header.getTtl() == null) continue;
                    this.expiration = System.currentTimeMillis() + (long)this.header.getTtl().intValue();
                    continue;
                }
                if (DeliveryAnnotations.class.equals((Object)constructor.getTypeClass())) {
                    constructor.skipValue();
                    this.deliveryAnnotationsPosition = constructorPos;
                    this.encodedDeliveryAnnotationsSize = this.data.position() - constructorPos;
                    continue;
                }
                if (MessageAnnotations.class.equals((Object)constructor.getTypeClass())) {
                    this.messageAnnotationsPosition = constructorPos;
                    this.messageAnnotations = (MessageAnnotations)constructor.readValue();
                    continue;
                }
                if (Properties.class.equals((Object)constructor.getTypeClass())) {
                    this.propertiesPosition = constructorPos;
                    this.properties = (Properties)constructor.readValue();
                    if (this.properties.getAbsoluteExpiryTime() == null || this.properties.getAbsoluteExpiryTime().getTime() <= 0L) continue;
                    this.expiration = this.properties.getAbsoluteExpiryTime().getTime();
                    continue;
                }
                if (ApplicationProperties.class.equals((Object)constructor.getTypeClass())) {
                    this.applicationPropertiesPosition = constructorPos;
                    constructor.skipValue();
                    this.remainingBodyPosition = this.data.hasRemaining() ? this.data.position() : -1;
                } else {
                    this.remainingBodyPosition = constructorPos;
                }
                break;
            }
        }
        finally {
            decoder.setByteBuffer(null);
            this.data.rewind();
        }
    }

    public Message copy() {
        this.ensureDataIsValid();
        ReadableBuffer view = this.data.duplicate().rewind();
        byte[] newData = new byte[view.remaining()];
        view.get(newData);
        AMQPMessage newEncode = new AMQPMessage(this.messageFormat, newData, this.extraProperties, this.coreMessageObjectPools);
        newEncode.setMessageID(this.getMessageID());
        return newEncode;
    }

    public Message copy(long newID) {
        return this.copy().setMessageID(newID);
    }

    public void sendBuffer(ByteBuf buffer, int deliveryCount) {
        this.ensureDataIsValid();
        NettyWritable writable = new NettyWritable(buffer);
        writable.put(this.getSendBuffer(deliveryCount));
    }

    public ReadableBuffer getSendBuffer(int deliveryCount) {
        this.ensureDataIsValid();
        if (deliveryCount > 1) {
            return this.createCopyWithNewDeliveryCount(deliveryCount);
        }
        if (this.deliveryAnnotationsPosition != -1 || this.deliveryAnnotationsForSendBuffer != null && !this.deliveryAnnotationsForSendBuffer.getValue().isEmpty()) {
            return this.createCopyWithSkippedOrExplicitlySetDeliveryAnnotations();
        }
        return this.data.duplicate();
    }

    private ReadableBuffer createCopyWithSkippedOrExplicitlySetDeliveryAnnotations() {
        ReadableBuffer duplicate = this.data.duplicate();
        ByteBuf result = PooledByteBufAllocator.DEFAULT.heapBuffer(this.getEncodeSize());
        result.writeBytes(duplicate.limit(this.encodedHeaderSize).byteBuffer());
        this.writeDeliveryAnnotationsForSendBuffer(result);
        duplicate.clear();
        duplicate.position(this.encodedHeaderSize + this.encodedDeliveryAnnotationsSize);
        result.writeBytes(duplicate.byteBuffer());
        return new NettyReadable(result);
    }

    private ReadableBuffer createCopyWithNewDeliveryCount(int deliveryCount) {
        assert (deliveryCount > 1);
        int amqpDeliveryCount = deliveryCount - 1;
        ByteBuf result = PooledByteBufAllocator.DEFAULT.heapBuffer(this.getEncodeSize());
        Header header = this.header;
        header = header == null ? new Header() : new Header(header);
        header.setDeliveryCount(UnsignedInteger.valueOf((int)amqpDeliveryCount));
        TLSEncode.getEncoder().setByteBuffer((WritableBuffer)new NettyWritable(result));
        TLSEncode.getEncoder().writeObject((Object)header);
        TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
        this.writeDeliveryAnnotationsForSendBuffer(result);
        this.data.position(this.encodedHeaderSize + this.encodedDeliveryAnnotationsSize);
        result.writeBytes(this.data.byteBuffer());
        this.data.position(0);
        return new NettyReadable(result);
    }

    private void writeDeliveryAnnotationsForSendBuffer(ByteBuf result) {
        if (this.deliveryAnnotationsForSendBuffer != null && !this.deliveryAnnotationsForSendBuffer.getValue().isEmpty()) {
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)new NettyWritable(result));
            TLSEncode.getEncoder().writeObject((Object)this.deliveryAnnotationsForSendBuffer);
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
        }
    }

    private int getDeliveryAnnotationsForSendBufferSize() {
        if (this.deliveryAnnotationsForSendBuffer == null || this.deliveryAnnotationsForSendBuffer.getValue().isEmpty()) {
            return 0;
        }
        DroppingWritableBuffer droppingWritableBuffer = new DroppingWritableBuffer();
        TLSEncode.getEncoder().setByteBuffer((WritableBuffer)droppingWritableBuffer);
        TLSEncode.getEncoder().writeObject((Object)this.deliveryAnnotationsForSendBuffer);
        TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
        return droppingWritableBuffer.position() + 1;
    }

    public void messageChanged() {
        this.modified = true;
    }

    public ByteBuf getBuffer() {
        if (this.data == null) {
            return null;
        }
        if (this.data instanceof NettyReadable) {
            return ((NettyReadable)this.data).getByteBuf();
        }
        return Unpooled.wrappedBuffer((ByteBuffer)this.data.byteBuffer());
    }

    public AMQPMessage setBuffer(ByteBuf buffer) {
        this.data = null;
        return this;
    }

    public int getEncodeSize() {
        this.ensureDataIsValid();
        return this.data.remaining() - this.encodedDeliveryAnnotationsSize + this.getDeliveryAnnotationsForSendBufferSize();
    }

    public void receiveBuffer(ByteBuf buffer) {
    }

    public int getMemoryEstimate() {
        if (this.memoryEstimate == -1) {
            this.memoryEstimate = 352 + (this.data != null ? this.data.capacity() : 0);
        }
        return this.memoryEstimate;
    }

    public ICoreMessage toCore(CoreMessageObjectPools coreMessageObjectPools) {
        try {
            return AmqpCoreConverter.toCore(this, coreMessageObjectPools, this.header, this.messageAnnotations, this.properties, this.lazyDecodeApplicationProperties(), this.getBody(), this.getFooter());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public ICoreMessage toCore() {
        return this.toCore(this.coreMessageObjectPools);
    }

    public void persist(ActiveMQBuffer targetRecord) {
        this.ensureDataIsValid();
        targetRecord.writeInt(this.internalPersistSize());
        if (this.data.hasArray()) {
            targetRecord.writeBytes(this.data.array(), this.data.arrayOffset(), this.data.remaining());
        } else {
            targetRecord.writeBytes(this.data.byteBuffer());
        }
    }

    public int getPersistSize() {
        this.ensureDataIsValid();
        return 4 + this.internalPersistSize();
    }

    private int internalPersistSize() {
        return this.data.remaining();
    }

    public void reloadPersistence(ActiveMQBuffer record) {
        int size = record.readInt();
        byte[] recordArray = new byte[size];
        record.readBytes(recordArray);
        this.data = ReadableBuffer.ByteBufferReader.wrap((ByteBuffer)ByteBuffer.wrap(recordArray));
        this.scanMessageData();
        this.messageDataScanned = true;
        this.modified = false;
        if (!this.isDurable()) {
            this.setDurable(true);
            this.reencode();
        }
    }

    public long getPersistentSize() throws ActiveMQException {
        return this.getEncodeSize();
    }

    public Persister<Message> getPersister() {
        return AMQPMessagePersisterV2.getInstance();
    }

    public void reencode() {
        this.ensureMessageDataScanned();
        if (this.properties != null && this.address != null) {
            this.properties.setTo(this.address.toString());
        }
        this.encodeMessage();
        this.scanMessageData();
        this.messageDataScanned = true;
        this.modified = false;
    }

    private synchronized void ensureDataIsValid() {
        assert (this.data != null);
        if (this.modified) {
            this.encodeMessage();
            this.modified = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void encodeMessage() {
        int estimated = Math.max(1500, this.data != null ? this.data.capacity() + 1000 : 0);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(estimated);
        EncoderImpl encoder = TLSEncode.getEncoder();
        try {
            NettyWritable writable = new NettyWritable(buffer);
            encoder.setByteBuffer((WritableBuffer)writable);
            if (this.header != null) {
                encoder.writeObject((Object)this.header);
            }
            if (this.messageAnnotations != null) {
                encoder.writeObject((Object)this.messageAnnotations);
            }
            if (this.properties != null) {
                encoder.writeObject((Object)this.properties);
            }
            if (this.applicationProperties != null) {
                encoder.writeObject((Object)this.applicationProperties);
                if (this.data != null && this.remainingBodyPosition != -1) {
                    writable.put(this.data.position(this.remainingBodyPosition));
                }
            } else if (this.data != null && this.applicationPropertiesPosition != -1) {
                writable.put(this.data.position(this.applicationPropertiesPosition));
            } else if (this.data != null && this.remainingBodyPosition != -1) {
                writable.put(this.data.position(this.remainingBodyPosition));
            }
            byte[] bytes = new byte[buffer.writerIndex()];
            buffer.readBytes(bytes);
            this.data = ReadableBuffer.ByteBufferReader.wrap((ByteBuffer)ByteBuffer.wrap(bytes));
        }
        finally {
            encoder.setByteBuffer((WritableBuffer)null);
            buffer.release();
        }
    }

    public TypedProperties createExtraProperties() {
        if (this.extraProperties == null) {
            this.extraProperties = new TypedProperties();
        }
        return this.extraProperties;
    }

    public TypedProperties getExtraProperties() {
        return this.extraProperties;
    }

    public AMQPMessage setExtraProperties(TypedProperties extraProperties) {
        this.extraProperties = extraProperties;
        return this;
    }

    public Message putExtraBytesProperty(SimpleString key, byte[] value) {
        this.createExtraProperties().putBytesProperty(key, value);
        return this;
    }

    public byte[] getExtraBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        if (this.extraProperties == null) {
            return null;
        }
        return this.extraProperties.getBytesProperty(key);
    }

    public byte[] removeExtraBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        if (this.extraProperties == null) {
            return null;
        }
        return (byte[])this.extraProperties.removeProperty(key);
    }

    public Message setConnectionID(String connectionID) {
        this.connectionID = connectionID;
        return this;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public long getMessageFormat() {
        return this.messageFormat;
    }

    public long getMessageID() {
        return this.messageID;
    }

    public Message setMessageID(long id) {
        this.messageID = id;
        return this;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public AMQPMessage setExpiration(long expiration) {
        if (this.properties != null) {
            if (expiration <= 0L) {
                this.properties.setAbsoluteExpiryTime(null);
            } else {
                this.properties.setAbsoluteExpiryTime(new Date(expiration));
            }
        } else if (expiration > 0L) {
            this.properties = new Properties();
            this.properties.setAbsoluteExpiryTime(new Date(expiration));
        }
        if (this.header != null) {
            this.header.setTtl(null);
        }
        this.expiration = Math.max(0L, expiration);
        return this;
    }

    public Object getUserID() {
        if (this.properties != null && this.properties.getMessageId() != null) {
            return this.properties.getMessageId();
        }
        return null;
    }

    public Object getAMQPUserID() {
        if (this.properties != null && this.properties.getUserId() != null) {
            Binary binary = this.properties.getUserId();
            return new String(binary.getArray(), binary.getArrayOffset(), binary.getLength(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public Message setUserID(Object userID) {
        return this;
    }

    public Object getDuplicateProperty() {
        return null;
    }

    public boolean isDurable() {
        if (this.header != null && this.header.getDurable() != null) {
            return this.header.getDurable();
        }
        return false;
    }

    public Message setDurable(boolean durable) {
        if (this.header == null) {
            this.header = new Header();
        }
        this.header.setDurable(Boolean.valueOf(durable));
        return this;
    }

    public String getAddress() {
        SimpleString addressSimpleString = this.getAddressSimpleString();
        return addressSimpleString == null ? null : addressSimpleString.toString();
    }

    public AMQPMessage setAddress(String address) {
        this.setAddress(this.cachedAddressSimpleString(address));
        return this;
    }

    public AMQPMessage setAddress(SimpleString address) {
        this.address = address;
        this.createExtraProperties().putSimpleStringProperty(ADDRESS_PROPERTY, address);
        return this;
    }

    public SimpleString getAddressSimpleString() {
        if (this.address == null) {
            TypedProperties extraProperties = this.getExtraProperties();
            if (extraProperties != null) {
                this.address = extraProperties.getSimpleStringProperty(ADDRESS_PROPERTY);
            }
            if (this.address == null && this.properties != null && this.properties.getTo() != null) {
                this.address = this.cachedAddressSimpleString(this.properties.getTo());
            }
        }
        return this.address;
    }

    private SimpleString cachedAddressSimpleString(String address) {
        return CoreMessageObjectPools.cachedAddressSimpleString((String)address, (CoreMessageObjectPools)this.coreMessageObjectPools);
    }

    public long getTimestamp() {
        if (this.properties != null && this.properties.getCreationTime() != null) {
            return this.properties.getCreationTime().getTime();
        }
        return 0L;
    }

    public Message setTimestamp(long timestamp) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setCreationTime(new Date(timestamp));
        return this;
    }

    public byte getPriority() {
        if (this.header != null && this.header.getPriority() != null) {
            return (byte)Math.min(this.header.getPriority().intValue(), 9);
        }
        return 4;
    }

    public Message setPriority(byte priority) {
        if (this.header == null) {
            this.header = new Header();
        }
        this.header.setPriority(UnsignedByte.valueOf((byte)priority));
        return this;
    }

    public SimpleString getReplyTo() {
        if (this.properties != null) {
            return SimpleString.toSimpleString((String)this.properties.getReplyTo());
        }
        return null;
    }

    public AMQPMessage setReplyTo(SimpleString address) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setReplyTo(address != null ? address.toString() : null);
        return this;
    }

    public RoutingType getRoutingType() {
        Object routingType = this.getMessageAnnotation(AMQPMessageSupport.ROUTING_TYPE);
        if (routingType != null) {
            return RoutingType.getType((byte)((Byte)routingType));
        }
        routingType = this.getMessageAnnotation(AMQPMessageSupport.JMS_DEST_TYPE_MSG_ANNOTATION);
        if (routingType != null) {
            if (0 == (Byte)routingType || 2 == (Byte)routingType) {
                return RoutingType.ANYCAST;
            }
            if (1 == (Byte)routingType || 3 == (Byte)routingType) {
                return RoutingType.MULTICAST;
            }
        } else {
            return null;
        }
        return null;
    }

    public Message setRoutingType(RoutingType routingType) {
        if (routingType == null) {
            this.removeMessageAnnotation(AMQPMessageSupport.ROUTING_TYPE);
        } else {
            this.setMessageAnnotation(AMQPMessageSupport.ROUTING_TYPE, (Object)routingType.getType());
        }
        return this;
    }

    public SimpleString getGroupID() {
        this.ensureMessageDataScanned();
        if (this.properties != null && this.properties.getGroupId() != null) {
            return SimpleString.toSimpleString((String)this.properties.getGroupId(), this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getGroupIdStringSimpleStringPool());
        }
        return null;
    }

    public int getGroupSequence() {
        this.ensureMessageDataScanned();
        if (this.properties != null && this.properties.getGroupSequence() != null) {
            return this.properties.getGroupSequence().intValue();
        }
        return 0;
    }

    public Object getCorrelationID() {
        return this.properties != null ? this.properties.getCorrelationId() : null;
    }

    public Message setCorrelationID(Object correlationID) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setCorrelationId(correlationID);
        return this;
    }

    public Long getScheduledDeliveryTime() {
        if (this.scheduledTime < 0L) {
            Object objscheduledTime = this.getMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_TIME);
            Object objdelay = this.getMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY);
            this.scheduledTime = objscheduledTime != null && objscheduledTime instanceof Number ? ((Number)objscheduledTime).longValue() : (objdelay != null && objdelay instanceof Number ? System.currentTimeMillis() + ((Number)objdelay).longValue() : 0L);
        }
        return this.scheduledTime;
    }

    public AMQPMessage setScheduledDeliveryTime(Long time) {
        if (time != null && time > 0L) {
            this.setMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_TIME, (Object)time);
            this.removeMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY);
            this.scheduledTime = time;
        } else {
            this.removeMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_TIME);
            this.removeMessageAnnotation(AMQPMessageSupport.SCHEDULED_DELIVERY_DELAY);
            this.scheduledTime = 0L;
        }
        return this;
    }

    public Object removeAnnotation(SimpleString key) {
        return this.removeMessageAnnotation(Symbol.getSymbol((String)key.toString()));
    }

    public Object getAnnotation(SimpleString key) {
        return this.getMessageAnnotation(key.toString());
    }

    public AMQPMessage setAnnotation(SimpleString key, Object value) {
        this.setMessageAnnotation(key.toString(), value);
        return this;
    }

    public Object removeProperty(SimpleString key) {
        return this.removeProperty(key.toString());
    }

    public Object removeProperty(String key) {
        return this.getApplicationPropertiesMap(false).remove(key);
    }

    public boolean containsProperty(SimpleString key) {
        return this.containsProperty(key.toString());
    }

    public boolean containsProperty(String key) {
        return this.getApplicationPropertiesMap(false).containsKey(key);
    }

    public Boolean getBooleanProperty(String key) throws ActiveMQPropertyConversionException {
        return (Boolean)this.getApplicationPropertiesMap(false).get(key);
    }

    public Byte getByteProperty(String key) throws ActiveMQPropertyConversionException {
        return (Byte)this.getApplicationPropertiesMap(false).get(key);
    }

    public Double getDoubleProperty(String key) throws ActiveMQPropertyConversionException {
        return (Double)this.getApplicationPropertiesMap(false).get(key);
    }

    public Integer getIntProperty(String key) throws ActiveMQPropertyConversionException {
        return (Integer)this.getApplicationPropertiesMap(false).get(key);
    }

    public Long getLongProperty(String key) throws ActiveMQPropertyConversionException {
        return (Long)this.getApplicationPropertiesMap(false).get(key);
    }

    public Object getObjectProperty(String key) {
        if (key.equals(MessageUtil.TYPE_HEADER_NAME.toString())) {
            if (this.properties != null) {
                return this.properties.getSubject();
            }
        } else {
            if (key.equals(MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString())) {
                return this.getConnectionID();
            }
            if (key.equals("JMSXGroupID")) {
                return this.getGroupID();
            }
            if (key.equals("JMSXGroupSeq")) {
                return this.getGroupSequence();
            }
            if (key.equals("JMSXUserID")) {
                return this.getAMQPUserID();
            }
            if (key.equals(MessageUtil.CORRELATIONID_HEADER_NAME.toString())) {
                if (this.properties != null && this.properties.getCorrelationId() != null) {
                    return AMQPMessageIdHelper.INSTANCE.toCorrelationIdString(this.properties.getCorrelationId());
                }
            } else {
                Object value = this.getApplicationPropertiesMap(false).get(key);
                if (value instanceof UnsignedInteger || value instanceof UnsignedByte || value instanceof UnsignedLong || value instanceof UnsignedShort) {
                    return ((Number)value).longValue();
                }
                return value;
            }
        }
        return null;
    }

    public Short getShortProperty(String key) throws ActiveMQPropertyConversionException {
        return (Short)this.getApplicationPropertiesMap(false).get(key);
    }

    public Float getFloatProperty(String key) throws ActiveMQPropertyConversionException {
        return (Float)this.getApplicationPropertiesMap(false).get(key);
    }

    public String getStringProperty(String key) throws ActiveMQPropertyConversionException {
        if (key.equals(MessageUtil.TYPE_HEADER_NAME.toString())) {
            return this.properties.getSubject();
        }
        if (key.equals(MessageUtil.CONNECTION_ID_PROPERTY_NAME.toString())) {
            return this.getConnectionID();
        }
        return (String)this.getApplicationPropertiesMap(false).get(key);
    }

    public Set<SimpleString> getPropertyNames() {
        HashSet<SimpleString> values = new HashSet<SimpleString>();
        for (String k : this.getApplicationPropertiesMap(false).keySet()) {
            values.add(SimpleString.toSimpleString((String)k.toString(), (SimpleString.StringSimpleStringPool)this.getPropertyKeysPool()));
        }
        return values;
    }

    public Boolean getBooleanProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getBooleanProperty(key.toString());
    }

    public Byte getByteProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getByteProperty(key.toString());
    }

    public byte[] getBytesProperty(String key) throws ActiveMQPropertyConversionException {
        return (byte[])this.getApplicationPropertiesMap(false).get(key);
    }

    public Double getDoubleProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getDoubleProperty(key.toString());
    }

    public Integer getIntProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getIntProperty(key.toString());
    }

    public Long getLongProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getLongProperty(key.toString());
    }

    public Object getObjectProperty(SimpleString key) {
        return this.getObjectProperty(key.toString());
    }

    public Short getShortProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getShortProperty(key.toString());
    }

    public Float getFloatProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getFloatProperty(key.toString());
    }

    public String getStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getStringProperty(key.toString());
    }

    public SimpleString getSimpleStringProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getSimpleStringProperty(key.toString());
    }

    public byte[] getBytesProperty(SimpleString key) throws ActiveMQPropertyConversionException {
        return this.getBytesProperty(key.toString());
    }

    public SimpleString getSimpleStringProperty(String key) throws ActiveMQPropertyConversionException {
        return SimpleString.toSimpleString((String)((String)this.getApplicationPropertiesMap(false).get(key)), (SimpleString.StringSimpleStringPool)this.getPropertyValuesPool());
    }

    public Message putBooleanProperty(String key, boolean value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public Message putByteProperty(String key, byte value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public Message putBytesProperty(String key, byte[] value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public Message putShortProperty(String key, short value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public Message putCharProperty(String key, char value) {
        this.getApplicationPropertiesMap(true).put(key, Character.valueOf(value));
        return this;
    }

    public Message putIntProperty(String key, int value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public Message putLongProperty(String key, long value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public Message putFloatProperty(String key, float value) {
        this.getApplicationPropertiesMap(true).put(key, Float.valueOf(value));
        return this;
    }

    public Message putDoubleProperty(String key, double value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public Message putBooleanProperty(SimpleString key, boolean value) {
        this.getApplicationPropertiesMap(true).put(key.toString(), value);
        return this;
    }

    public Message putByteProperty(SimpleString key, byte value) {
        return this.putByteProperty(key.toString(), value);
    }

    public Message putBytesProperty(SimpleString key, byte[] value) {
        return this.putBytesProperty(key.toString(), value);
    }

    public Message putShortProperty(SimpleString key, short value) {
        return this.putShortProperty(key.toString(), value);
    }

    public Message putCharProperty(SimpleString key, char value) {
        return this.putCharProperty(key.toString(), value);
    }

    public Message putIntProperty(SimpleString key, int value) {
        return this.putIntProperty(key.toString(), value);
    }

    public Message putLongProperty(SimpleString key, long value) {
        return this.putLongProperty(key.toString(), value);
    }

    public Message putFloatProperty(SimpleString key, float value) {
        return this.putFloatProperty(key.toString(), value);
    }

    public Message putDoubleProperty(SimpleString key, double value) {
        return this.putDoubleProperty(key.toString(), value);
    }

    public Message putStringProperty(String key, String value) {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public Message putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
        this.getApplicationPropertiesMap(true).put(key, value);
        return this;
    }

    public Message putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
        return this.putObjectProperty(key.toString(), value);
    }

    public Message putStringProperty(SimpleString key, SimpleString value) {
        return this.putStringProperty(key.toString(), value.toString());
    }

    public Message putStringProperty(SimpleString key, String value) {
        return this.putStringProperty(key.toString(), value);
    }

    public SimpleString getLastValueProperty() {
        return this.getSimpleStringProperty(HDR_LAST_VALUE_NAME);
    }

    public Message setLastValueProperty(SimpleString lastValueName) {
        return this.putStringProperty(HDR_LAST_VALUE_NAME, lastValueName);
    }

    public String toString() {
        return "AMQPMessage [durable=" + this.isDurable() + ", messageID=" + this.getMessageID() + ", address=" + this.getAddress() + ", size=" + this.getEncodeSize() + ", applicationProperties=" + this.applicationProperties + ", properties=" + this.properties + ", extraProperties = " + this.getExtraProperties() + "]";
    }

    public synchronized boolean acceptsConsumer(long consumer) {
        if (this.rejectedConsumers == null) {
            return true;
        }
        return !this.rejectedConsumers.contains(consumer);
    }

    public synchronized void rejectConsumer(long consumer) {
        if (this.rejectedConsumers == null) {
            this.rejectedConsumers = new HashSet<Object>();
        }
        this.rejectedConsumers.add(consumer);
    }

    private SimpleString.StringSimpleStringPool getPropertyKeysPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyKeysPool();
    }

    private SimpleString.StringSimpleStringPool getPropertyValuesPool() {
        return this.coreMessageObjectPools == null ? null : this.coreMessageObjectPools.getPropertiesStringSimpleStringPools().getPropertyValuesPool();
    }
}

