/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.factory;

import java.io.File;
import org.apache.activemq.artemis.core.config.impl.FileSecurityConfiguration;
import org.apache.activemq.artemis.core.config.impl.SecurityConfiguration;
import org.apache.activemq.artemis.dto.BasicSecurityDTO;
import org.apache.activemq.artemis.dto.SecurityDTO;
import org.apache.activemq.artemis.factory.SecurityHandler;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManagerImpl;

public class BasicSecurityHandler
implements SecurityHandler {
    static String fixupFileURI(String value) {
        if (value != null && value.startsWith("file:")) {
            value = value.substring("file:".length());
            value = new File(value).toURI().toString();
        }
        return value;
    }

    @Override
    public ActiveMQSecurityManager createSecurityManager(SecurityDTO security) throws Exception {
        BasicSecurityDTO fileSecurity = (BasicSecurityDTO)security;
        String home = System.getProperty("activemq.home");
        FileSecurityConfiguration securityConfiguration = new FileSecurityConfiguration(BasicSecurityHandler.fixupFileURI(fileSecurity.users), BasicSecurityHandler.fixupFileURI(fileSecurity.roles), fileSecurity.defaultUser, fileSecurity.maskPassword, fileSecurity.passwordCodec);
        securityConfiguration.start();
        return new ActiveMQSecurityManagerImpl((SecurityConfiguration)securityConfiguration);
    }
}

