/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli;

import io.airlift.airline.Cli;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.activemq.artemis.cli.CLIException;
import org.apache.activemq.artemis.cli.ConfigurationException;
import org.apache.activemq.artemis.cli.commands.Action;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.Create;
import org.apache.activemq.artemis.cli.commands.HelpAction;
import org.apache.activemq.artemis.cli.commands.Kill;
import org.apache.activemq.artemis.cli.commands.Run;
import org.apache.activemq.artemis.cli.commands.Stop;
import org.apache.activemq.artemis.cli.commands.destination.CreateDestination;
import org.apache.activemq.artemis.cli.commands.destination.DeleteDestination;
import org.apache.activemq.artemis.cli.commands.destination.HelpDestination;
import org.apache.activemq.artemis.cli.commands.messages.Browse;
import org.apache.activemq.artemis.cli.commands.messages.Consumer;
import org.apache.activemq.artemis.cli.commands.messages.Producer;
import org.apache.activemq.artemis.cli.commands.tools.CompactJournal;
import org.apache.activemq.artemis.cli.commands.tools.DecodeJournal;
import org.apache.activemq.artemis.cli.commands.tools.EncodeJournal;
import org.apache.activemq.artemis.cli.commands.tools.HelpData;
import org.apache.activemq.artemis.cli.commands.tools.PrintData;
import org.apache.activemq.artemis.cli.commands.tools.XmlDataExporter;
import org.apache.activemq.artemis.cli.commands.tools.XmlDataImporter;

public class Artemis {
    public static void main(String ... args) throws Exception {
        String home = System.getProperty("artemis.home");
        File fileHome = home != null ? new File(home) : null;
        String instance = System.getProperty("artemis.instance");
        File fileInstance = instance != null ? new File(instance) : null;
        Artemis.execute(fileHome, fileInstance, args);
    }

    public static Object internalExecute(String ... args) throws Exception {
        return Artemis.internalExecute(null, null, args);
    }

    public static Object execute(File artemisHome, File artemisInstance, List<String> args) throws Exception {
        return Artemis.execute(artemisHome, artemisInstance, args.toArray(new String[args.size()]));
    }

    public static Object execute(File artemisHome, File artemisInstance, String ... args) throws Exception {
        try {
            return Artemis.internalExecute(artemisHome, artemisInstance, args);
        }
        catch (ConfigurationException configException) {
            System.err.println(configException.getMessage());
            System.out.println();
            System.out.println("Configuration should be specified as 'scheme:location'. Default configuration is 'xml:${ARTEMIS_INSTANCE}/etc/bootstrap.xml'");
            return configException;
        }
        catch (CLIException cliException) {
            System.err.println(cliException.getMessage());
            return cliException;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return e;
        }
        catch (RuntimeException re) {
            System.err.println(re.getMessage());
            System.out.println();
            Cli parser = Artemis.builder(null).build();
            ((Action)parser.parse(new String[]{"help"})).execute(ActionContext.system());
            return re;
        }
    }

    public static Object internalExecute(File artemisHome, File artemisInstance, String[] args) throws Exception {
        Action action = (Action)Artemis.builder(artemisInstance).build().parse(args);
        action.setHomeValues(artemisHome, artemisInstance);
        if (action.isVerbose()) {
            System.out.print("Executing " + action.getClass().getName() + " ");
            for (String arg : args) {
                System.out.print(arg + " ");
            }
            System.out.println();
            System.out.println("Home::" + action.getBrokerHome() + ", Instance::" + action.getBrokerInstance());
        }
        return action.execute(ActionContext.system());
    }

    private static Cli.CliBuilder<Action> builder(File artemisInstance) {
        String instance = artemisInstance != null ? artemisInstance.getAbsolutePath() : System.getProperty("artemis.instance");
        Cli.CliBuilder builder = Cli.builder((String)"artemis").withDescription("ActiveMQ Artemis Command Line").withCommand(HelpAction.class).withCommand(Producer.class).withCommand(Consumer.class).withCommand(Browse.class).withDefaultCommand(HelpAction.class);
        builder.withGroup("destination").withDescription("Destination tools group (create|delete) (example ./artemis destination create)").withDefaultCommand(HelpDestination.class).withCommands(CreateDestination.class, new Class[]{DeleteDestination.class});
        if (instance != null) {
            builder.withGroup("data").withDescription("data tools group (print|exp|imp|exp|encode|decode|compact) (example ./artemis data print)").withDefaultCommand(HelpData.class).withCommands(PrintData.class, new Class[]{XmlDataExporter.class, XmlDataImporter.class, DecodeJournal.class, EncodeJournal.class, CompactJournal.class});
            builder = builder.withCommands(Run.class, new Class[]{Stop.class, Kill.class});
        } else {
            builder.withGroup("data").withDescription("data tools group (print) (example ./artemis data print)").withDefaultCommand(HelpData.class).withCommands(PrintData.class, new Class[0]);
            builder = builder.withCommand(Create.class);
        }
        return builder;
    }

    public static void printBanner() throws Exception {
        Artemis.copy(Artemis.class.getResourceAsStream("banner.txt"), System.out);
    }

    private static long copy(InputStream in, OutputStream out) throws Exception {
        byte[] buffer = new byte[1024];
        int len = in.read(buffer);
        while (len != -1) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        return len;
    }
}

