/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import io.airlift.airline.Option;
import java.io.File;
import org.apache.activemq.artemis.cli.commands.Action;
import org.apache.activemq.artemis.cli.commands.ActionContext;

public abstract class ActionAbstract
implements Action {
    @Option(name={"--verbose"}, description="Adds more information on the execution")
    public boolean verbose;
    private String brokerInstance;
    private String brokerHome;
    protected ActionContext context;

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setHomeValues(File brokerHome, File brokerInstance) {
        if (brokerHome != null) {
            this.brokerHome = brokerHome.getAbsolutePath();
        }
        if (brokerInstance != null) {
            this.brokerInstance = brokerInstance.getAbsolutePath();
        }
    }

    @Override
    public String getBrokerInstance() {
        if (this.brokerInstance == null) {
            this.brokerInstance = System.getProperty("artemis.instance");
            if (this.brokerInstance != null) {
                this.brokerInstance = this.brokerInstance.replace("\\", "/");
                System.setProperty("artemis.instance", this.brokerInstance);
            }
        }
        return this.brokerInstance;
    }

    @Override
    public String getBrokerHome() {
        if (this.brokerHome == null) {
            this.brokerHome = System.getProperty("artemis.home");
            if (this.brokerHome != null) {
                this.brokerHome = this.brokerHome.replace("\\", "/");
                System.setProperty("artemis.home", this.brokerHome);
            }
            if (this.brokerHome == null) {
                this.brokerHome = ".";
            }
        }
        return this.brokerHome;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        this.context = context;
        return null;
    }
}

