/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.destination;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import javax.jms.Message;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.jms.management.JMSManagementHelper;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.destination.DestinationAction;

@Command(name="create", description="create a queue or topic")
public class CreateDestination
extends DestinationAction {
    @Option(name={"--filter"}, description="queue's filter string (default null)")
    String filter = null;
    @Option(name={"--address"}, description="address of the core queue (default queue's name)")
    String address;
    @Option(name={"--durable"}, description="whether the queue is durable or not (default false)")
    boolean durable = false;
    @Option(name={"--bindings"}, description="comma separated jndi binding names (default null)")
    String bindings = null;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        if ("jms-queue".equals(this.destType)) {
            this.createJmsQueue(context);
        } else if ("core-queue".equals(this.destType)) {
            this.createCoreQueue(context);
        } else if ("topic".equals(this.destType)) {
            this.createJmsTopic(context);
        } else {
            throw new IllegalArgumentException("--type can only be one of jms-queue, topic and core-queue");
        }
        return null;
    }

    private void createJmsTopic(final ActionContext context) throws Exception {
        CreateDestination.performJmsManagement(this.brokerURL, this.user, this.password, new DestinationAction.ManagementCallback<Message>(){

            @Override
            public void setUpInvocation(Message message) throws Exception {
                JMSManagementHelper.putOperationInvocation((Message)message, (String)"jms.server", (String)"createTopic", (Object[])new Object[]{CreateDestination.this.getName(), CreateDestination.this.bindings});
            }

            @Override
            public void requestSuccessful(Message reply) throws Exception {
                boolean result = (Boolean)JMSManagementHelper.getResult((Message)reply, Boolean.class);
                if (result) {
                    context.out.println("Topic " + CreateDestination.this.getName() + " created successfully.");
                } else {
                    context.err.println("Failed to create topic " + CreateDestination.this.getName() + ".");
                }
            }

            @Override
            public void requestFailed(Message reply) throws Exception {
                String errorMsg = (String)JMSManagementHelper.getResult((Message)reply, String.class);
                context.err.println("Failed to create topic " + CreateDestination.this.getName() + ". Reason: " + errorMsg);
            }
        });
    }

    public String getAddress() {
        if (this.address == null || "".equals(this.address.trim())) {
            this.address = this.getName();
        }
        return this.address.trim();
    }

    private void createCoreQueue(final ActionContext context) throws Exception {
        CreateDestination.performCoreManagement(this.brokerURL, this.user, this.password, new DestinationAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                String address = CreateDestination.this.getAddress();
                ManagementHelper.putOperationInvocation((org.apache.activemq.artemis.api.core.Message)message, (String)"core.server", (String)"createQueue", (Object[])new Object[]{address, CreateDestination.this.getName(), CreateDestination.this.filter, CreateDestination.this.durable});
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                context.out.println("Core queue " + CreateDestination.this.getName() + " created successfully.");
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((org.apache.activemq.artemis.api.core.Message)reply, String.class);
                context.err.println("Failed to create queue " + CreateDestination.this.getName() + ". Reason: " + errMsg);
            }
        });
    }

    private void createJmsQueue(final ActionContext context) throws Exception {
        CreateDestination.performJmsManagement(this.brokerURL, this.user, this.password, new DestinationAction.ManagementCallback<Message>(){

            @Override
            public void setUpInvocation(Message message) throws Exception {
                JMSManagementHelper.putOperationInvocation((Message)message, (String)"jms.server", (String)"createQueue", (Object[])new Object[]{CreateDestination.this.getName(), CreateDestination.this.bindings, CreateDestination.this.filter, CreateDestination.this.durable});
            }

            @Override
            public void requestSuccessful(Message reply) throws Exception {
                boolean result = (Boolean)JMSManagementHelper.getResult((Message)reply, Boolean.class);
                if (result) {
                    context.out.println("Jms queue " + CreateDestination.this.getName() + " created successfully.");
                } else {
                    context.err.println("Failed to create jms queue " + CreateDestination.this.getName() + ".");
                }
            }

            @Override
            public void requestFailed(Message reply) throws Exception {
                String errorMsg = (String)JMSManagementHelper.getResult((Message)reply, String.class);
                context.err.println("Failed to create jms queue " + CreateDestination.this.getName() + ". Reason: " + errorMsg);
            }
        });
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setBindings(String bindings) {
        this.bindings = bindings;
    }
}

