/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.DestAbstract;
import org.apache.activemq.artemis.cli.commands.util.ProducerThread;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;

@Command(name="producer", description="It will send messages to an instance")
public class Producer
extends DestAbstract {
    @Option(name={"--non-persistent"}, description="It will send messages non persistently")
    boolean nonpersistent = false;
    @Option(name={"--message-size"}, description="Size of each byteMessage (The producer will use byte message on this case)")
    int messageSize = 0;
    @Option(name={"--text-size"}, description="Size of each textNessage (The producer will use text message on this case)")
    int textMessageSize;
    @Option(name={"--msgttl"}, description="TTL for each message")
    long msgTTL = 0L;
    @Option(name={"--group"}, description="Message Group to be used")
    String msgGroupID = null;

    /*
     * WARNING - void declaration
     */
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        ActiveMQDestination dest = ActiveMQDestination.createDestination((String)this.destination, (ActiveMQDestination.TYPE)ActiveMQDestination.TYPE.QUEUE);
        try (Connection connection = factory.createConnection();){
            ProducerThread[] threadsArray = new ProducerThread[this.threads];
            for (int i = 0; i < this.threads; ++i) {
                void var8_11;
                if (this.txBatchSize > 0) {
                    Session session = connection.createSession(true, 0);
                } else {
                    Session object = connection.createSession(false, 1);
                }
                threadsArray[i] = new ProducerThread((Session)var8_11, (Destination)dest, i);
                threadsArray[i].setVerbose(this.verbose).setSleep(this.sleep).setPersistent(!this.nonpersistent).setMessageSize(this.messageSize).setTextMessageSize(this.textMessageSize).setMsgTTL(this.msgTTL).setMsgGroupID(this.msgGroupID).setTransactionBatchSize(this.txBatchSize).setMessageCount(this.messageCount);
            }
            for (ProducerThread thread : threadsArray) {
                thread.start();
            }
            int messagesProduced = 0;
            for (ProducerThread thread : threadsArray) {
                thread.join();
                messagesProduced += thread.getSentCount();
            }
            Integer n = messagesProduced;
            return n;
        }
    }
}

