/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools.xml;

import io.airlift.airline.Command;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.OptionalLocking;
import org.apache.activemq.artemis.cli.commands.tools.xml.XmlDataExporterUtil;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.message.LargeBodyEncoder;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.PagingStoreFactory;
import org.apache.activemq.artemis.core.paging.cursor.PagePosition;
import org.apache.activemq.artemis.core.paging.cursor.impl.PagePositionImpl;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.apache.activemq.artemis.core.paging.impl.PageTransactionInfoImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingManagerImpl;
import org.apache.activemq.artemis.core.paging.impl.PagingStoreFactoryNIO;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.AckDescribe;
import org.apache.activemq.artemis.core.persistence.impl.journal.DescribeJournal;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.CursorAckRecordEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PageUpdateTXEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PersistentAddressBindingEncoding;
import org.apache.activemq.artemis.core.persistence.impl.journal.codec.PersistentQueueBindingEncoding;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.settings.impl.HierarchicalObjectRepository;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.OrderedExecutorFactory;

@Command(name="exp", description="Export all message-data using an XML that could be interpreted by any system.")
public final class XmlDataExporter
extends OptionalLocking {
    private static final Long LARGE_MESSAGE_CHUNK_SIZE = 1000L;
    private JournalStorageManager storageManager;
    private Configuration config;
    private XMLStreamWriter xmlWriter;
    private final Map<Long, HashMap<Long, DescribeJournal.ReferenceDescribe>> messageRefs = new HashMap<Long, HashMap<Long, DescribeJournal.ReferenceDescribe>>();
    private final HashMap<Long, Message> messages = new HashMap();
    private final Map<Long, Set<PagePosition>> cursorRecords = new HashMap<Long, Set<PagePosition>>();
    private final Set<Long> pgTXs = new HashSet<Long>();
    private final HashMap<Long, PersistentQueueBindingEncoding> queueBindings = new HashMap();
    private final HashMap<Long, PersistentAddressBindingEncoding> addressBindings = new HashMap();
    long messagesPrinted = 0L;
    long bindingsPrinted = 0L;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        try {
            this.process(context.out, this.getBinding(), this.getJournal(), this.getPaging(), this.getLargeMessages());
        }
        catch (Exception e) {
            this.treatError(e, "data", "exp");
        }
        return null;
    }

    public void process(OutputStream out, String bindingsDir, String journalDir, String pagingDir, String largeMessagesDir) throws Exception {
        this.config = new ConfigurationImpl().setBindingsDirectory(bindingsDir).setJournalDirectory(journalDir).setPagingDirectory(pagingDir).setLargeMessagesDirectory(largeMessagesDir).setJournalType(JournalType.NIO);
        ExecutorService executor = Executors.newFixedThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
        OrderedExecutorFactory executorFactory = new OrderedExecutorFactory((Executor)executor);
        this.storageManager = new JournalStorageManager(this.config, (ExecutorFactory)executorFactory, (ExecutorFactory)executorFactory);
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter rawXmlWriter = factory.createXMLStreamWriter(out, "UTF-8");
        PrettyPrintHandler handler = new PrettyPrintHandler(rawXmlWriter);
        this.xmlWriter = (XMLStreamWriter)Proxy.newProxyInstance(XMLStreamWriter.class.getClassLoader(), new Class[]{XMLStreamWriter.class}, (InvocationHandler)handler);
        this.writeXMLData();
        executor.shutdown();
    }

    private void writeXMLData() throws Exception {
        long start = System.currentTimeMillis();
        this.getBindings();
        this.processMessageJournal();
        this.printDataAsXML();
        ActiveMQServerLogger.LOGGER.debug((Object)("\n\nProcessing took: " + (System.currentTimeMillis() - start) + "ms"));
        ActiveMQServerLogger.LOGGER.debug((Object)("Output " + this.messagesPrinted + " messages and " + this.bindingsPrinted + " bindings."));
    }

    private void processMessageJournal() throws Exception {
        ArrayList<RecordInfo> acks = new ArrayList<RecordInfo>();
        LinkedList records = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        Journal messageJournal = this.storageManager.getMessageJournal();
        ActiveMQServerLogger.LOGGER.debug((Object)("Reading journal from " + this.config.getJournalDirectory()));
        messageJournal.start();
        TransactionFailureCallback transactionFailureCallback = new TransactionFailureCallback(){

            public void failedTransaction(long transactionID, List<RecordInfo> records1, List<RecordInfo> recordsToDelete) {
                int i;
                StringBuilder message = new StringBuilder();
                message.append("Encountered failed journal transaction: ").append(transactionID);
                for (i = 0; i < records1.size(); ++i) {
                    if (i == 0) {
                        message.append("; Records: ");
                    }
                    message.append(records1.get(i));
                    if (i == records1.size() - 1) continue;
                    message.append(", ");
                }
                for (i = 0; i < recordsToDelete.size(); ++i) {
                    if (i == 0) {
                        message.append("; RecordsToDelete: ");
                    }
                    message.append(recordsToDelete.get(i));
                    if (i == recordsToDelete.size() - 1) continue;
                    message.append(", ");
                }
                ActiveMQServerLogger.LOGGER.debug((Object)message.toString());
            }
        };
        ((JournalImpl)messageJournal).load(records, preparedTransactions, transactionFailureCallback, false);
        preparedTransactions = null;
        for (RecordInfo info : records) {
            byte[] data = info.data;
            ActiveMQBuffer buff = ActiveMQBuffers.wrappedBuffer((byte[])data);
            Object o = DescribeJournal.newObjectEncoding((RecordInfo)info, (JournalStorageManager)this.storageManager);
            if (info.getUserRecordType() == 31) {
                this.messages.put(info.id, (Message)((DescribeJournal.MessageDescribe)o).getMsg().toCore());
                continue;
            }
            if (info.getUserRecordType() == 45) {
                this.messages.put(info.id, (Message)((DescribeJournal.MessageDescribe)o).getMsg().toCore());
                continue;
            }
            if (info.getUserRecordType() == 30) {
                this.messages.put(info.id, ((DescribeJournal.MessageDescribe)o).getMsg());
                continue;
            }
            if (info.getUserRecordType() == 32) {
                DescribeJournal.ReferenceDescribe ref = (DescribeJournal.ReferenceDescribe)o;
                HashMap<Long, DescribeJournal.ReferenceDescribe> map = this.messageRefs.get(info.id);
                if (map == null) {
                    HashMap<Long, DescribeJournal.ReferenceDescribe> newMap = new HashMap<Long, DescribeJournal.ReferenceDescribe>();
                    newMap.put(ref.refEncoding.queueID, ref);
                    this.messageRefs.put(info.id, newMap);
                    continue;
                }
                map.put(ref.refEncoding.queueID, ref);
                continue;
            }
            if (info.getUserRecordType() == 33) {
                acks.add(info);
                continue;
            }
            if (info.userRecordType == 39) {
                CursorAckRecordEncoding encoding = new CursorAckRecordEncoding();
                encoding.decode(buff);
                Set<PagePosition> set = this.cursorRecords.get(encoding.queueID);
                if (set == null) {
                    set = new HashSet<PagePosition>();
                    this.cursorRecords.put(encoding.queueID, set);
                }
                set.add(encoding.position);
                continue;
            }
            if (info.userRecordType != 35) continue;
            if (info.isUpdate) {
                PageUpdateTXEncoding pageUpdate = new PageUpdateTXEncoding();
                pageUpdate.decode(buff);
                this.pgTXs.add(pageUpdate.pageTX);
                continue;
            }
            PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
            pageTransactionInfo.decode(buff);
            pageTransactionInfo.setRecordID(info.id);
            this.pgTXs.add(pageTransactionInfo.getTransactionID());
        }
        messageJournal.stop();
        this.removeAcked(acks);
    }

    private void removeAcked(ArrayList<RecordInfo> acks) {
        for (RecordInfo info : acks) {
            AckDescribe ack = (AckDescribe)DescribeJournal.newObjectEncoding((RecordInfo)info, null);
            HashMap<Long, DescribeJournal.ReferenceDescribe> referenceDescribeHashMap = this.messageRefs.get(info.id);
            referenceDescribeHashMap.remove(ack.refEncoding.queueID);
            if (referenceDescribeHashMap.size() != 0) continue;
            this.messages.remove(info.id);
            this.messageRefs.remove(info.id);
        }
    }

    private void getBindings() throws Exception {
        LinkedList records = new LinkedList();
        Journal bindingsJournal = this.storageManager.getBindingsJournal();
        bindingsJournal.start();
        ActiveMQServerLogger.LOGGER.debug((Object)("Reading bindings journal from " + this.config.getBindingsDirectory()));
        ((JournalImpl)bindingsJournal).load(records, null, null, false);
        for (RecordInfo info : records) {
            PersistentQueueBindingEncoding bindingEncoding;
            if (info.getUserRecordType() == 21) {
                bindingEncoding = (PersistentQueueBindingEncoding)DescribeJournal.newObjectEncoding((RecordInfo)info, null);
                this.queueBindings.put(bindingEncoding.getId(), bindingEncoding);
                continue;
            }
            if (info.getUserRecordType() != 44) continue;
            bindingEncoding = (PersistentAddressBindingEncoding)DescribeJournal.newObjectEncoding((RecordInfo)info, null);
            this.addressBindings.put(bindingEncoding.getId(), (PersistentAddressBindingEncoding)bindingEncoding);
        }
        bindingsJournal.stop();
    }

    private void printDataAsXML() {
        try {
            this.xmlWriter.writeStartDocument("1.0");
            this.xmlWriter.writeStartElement("activemq-journal");
            this.printBindingsAsXML();
            this.printAllMessagesAsXML();
            this.xmlWriter.writeEndElement();
            this.xmlWriter.writeEndDocument();
            this.xmlWriter.flush();
            this.xmlWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printBindingsAsXML() throws XMLStreamException {
        PersistentAddressBindingEncoding bindingEncoding;
        this.xmlWriter.writeStartElement("bindings");
        for (Map.Entry<Long, PersistentAddressBindingEncoding> entry : this.addressBindings.entrySet()) {
            bindingEncoding = this.addressBindings.get(entry.getKey());
            this.xmlWriter.writeEmptyElement("address-binding");
            StringBuilder routingTypes = new StringBuilder();
            for (RoutingType routingType : bindingEncoding.getRoutingTypes()) {
                routingTypes.append(routingType.toString()).append(", ");
            }
            this.xmlWriter.writeAttribute("routing-types", routingTypes.toString().substring(0, routingTypes.length() - 2));
            this.xmlWriter.writeAttribute("name", bindingEncoding.getName().toString());
            this.xmlWriter.writeAttribute("id", Long.toString(bindingEncoding.getId()));
            ++this.bindingsPrinted;
        }
        for (Map.Entry<Long, PersistentAddressBindingEncoding> entry : this.queueBindings.entrySet()) {
            bindingEncoding = this.queueBindings.get(entry.getKey());
            this.xmlWriter.writeEmptyElement("queue-binding");
            this.xmlWriter.writeAttribute("address", bindingEncoding.getAddress().toString());
            String filter = "";
            if (bindingEncoding.getFilterString() != null) {
                filter = bindingEncoding.getFilterString().toString();
            }
            this.xmlWriter.writeAttribute("filter-string", filter);
            this.xmlWriter.writeAttribute("name", bindingEncoding.getQueueName().toString());
            this.xmlWriter.writeAttribute("id", Long.toString(bindingEncoding.getId()));
            this.xmlWriter.writeAttribute("routing-type", RoutingType.getType((byte)bindingEncoding.getRoutingType()).toString());
            ++this.bindingsPrinted;
        }
        this.xmlWriter.writeEndElement();
    }

    private void printAllMessagesAsXML() throws Exception {
        this.xmlWriter.writeStartElement("messages");
        for (Map.Entry<Long, Message> messageMapEntry : this.messages.entrySet()) {
            this.printSingleMessageAsXML(messageMapEntry.getValue().toCore(), this.extractQueueNames(this.messageRefs.get(messageMapEntry.getKey())));
        }
        this.printPagedMessagesAsXML();
        this.xmlWriter.writeEndElement();
    }

    private void printPagedMessagesAsXML() {
        try {
            SimpleString[] stores;
            ScheduledExecutorService scheduled = Executors.newScheduledThreadPool(1, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
            final ExecutorService executor = Executors.newFixedThreadPool(10, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory());
            ExecutorFactory executorFactory = new ExecutorFactory(){

                public Executor getExecutor() {
                    return executor;
                }
            };
            PagingStoreFactoryNIO pageStoreFactory = new PagingStoreFactoryNIO((StorageManager)this.storageManager, this.config.getPagingLocation(), 1000L, scheduled, executorFactory, true, null);
            HierarchicalObjectRepository addressSettingsRepository = new HierarchicalObjectRepository();
            addressSettingsRepository.setDefault((Object)new AddressSettings());
            PagingManagerImpl manager = new PagingManagerImpl((PagingStoreFactory)pageStoreFactory, (HierarchicalRepository)addressSettingsRepository);
            manager.start();
            for (SimpleString store : stores = manager.getStoreNames()) {
                PagingStore pageStore = manager.getPageStore(store);
                if (pageStore != null) {
                    File folder = pageStore.getFolder();
                    ActiveMQServerLogger.LOGGER.debug((Object)("Reading page store " + store + " folder = " + folder));
                    int pageId = (int)pageStore.getFirstPage();
                    for (int i = 0; i < pageStore.getNumberOfPages(); ++i) {
                        ActiveMQServerLogger.LOGGER.debug((Object)("Reading page " + pageId));
                        Page page = pageStore.createPage(pageId);
                        page.open();
                        List messages = page.read((StorageManager)this.storageManager);
                        page.close();
                        int messageId = 0;
                        for (PagedMessage message : messages) {
                            message.initMessage((StorageManager)this.storageManager);
                            long[] queueIDs = message.getQueueIDs();
                            ArrayList<String> queueNames = new ArrayList<String>();
                            for (long queueID : queueIDs) {
                                PersistentQueueBindingEncoding queueBinding;
                                PagePositionImpl posCheck = new PagePositionImpl((long)pageId, messageId);
                                boolean acked = false;
                                Set<PagePosition> positions = this.cursorRecords.get(queueID);
                                if (positions != null) {
                                    acked = positions.contains(posCheck);
                                }
                                if (acked || (queueBinding = this.queueBindings.get(queueID)) == null) continue;
                                SimpleString queueName = queueBinding.getQueueName();
                                queueNames.add(queueName.toString());
                            }
                            if (queueNames.size() > 0 && (message.getTransactionID() == -1L || this.pgTXs.contains(message.getTransactionID()))) {
                                this.printSingleMessageAsXML(message.getMessage().toCore(), queueNames);
                            }
                            ++messageId;
                        }
                        ++pageId;
                    }
                    continue;
                }
                ActiveMQServerLogger.LOGGER.debug((Object)"Page store was null");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printSingleMessageAsXML(ICoreMessage message, List<String> queues) throws Exception {
        this.xmlWriter.writeStartElement("message");
        this.printMessageAttributes(message);
        this.printMessageProperties((Message)message);
        this.printMessageQueues(queues);
        this.printMessageBody((Message)message.toCore());
        this.xmlWriter.writeEndElement();
        ++this.messagesPrinted;
    }

    private void printMessageBody(Message message) throws Exception {
        this.xmlWriter.writeStartElement("body");
        if (message.toCore().isLargeMessage()) {
            this.printLargeMessageBody((LargeServerMessage)message);
        } else {
            this.xmlWriter.writeCData(XmlDataExporterUtil.encodeMessageBody(message));
        }
        this.xmlWriter.writeEndElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printLargeMessageBody(LargeServerMessage message) throws XMLStreamException {
        this.xmlWriter.writeAttribute("isLarge", Boolean.TRUE.toString());
        LargeBodyEncoder encoder = null;
        try {
            encoder = message.toCore().getBodyEncoder();
            encoder.open();
            long totalBytesWritten = 0L;
            long bodySize = encoder.getLargeBodySize();
            for (long i = 0L; i < bodySize; i += LARGE_MESSAGE_CHUNK_SIZE.longValue()) {
                Long remainder = bodySize - totalBytesWritten;
                Long bufferSize = remainder >= LARGE_MESSAGE_CHUNK_SIZE ? LARGE_MESSAGE_CHUNK_SIZE : remainder;
                ActiveMQBuffer buffer = ActiveMQBuffers.fixedBuffer((int)bufferSize.intValue());
                encoder.encode(buffer, bufferSize.intValue());
                this.xmlWriter.writeCData(XmlDataExporterUtil.encode(buffer.toByteBuffer().array()));
                totalBytesWritten += bufferSize.longValue();
            }
            encoder.close();
        }
        catch (ActiveMQException e) {
            e.printStackTrace();
        }
        finally {
            if (encoder != null) {
                try {
                    encoder.close();
                }
                catch (ActiveMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void printMessageQueues(List<String> queues) throws XMLStreamException {
        this.xmlWriter.writeStartElement("queues");
        for (String queueName : queues) {
            this.xmlWriter.writeEmptyElement("queue");
            this.xmlWriter.writeAttribute("name", queueName);
        }
        this.xmlWriter.writeEndElement();
    }

    private void printMessageProperties(Message message) throws XMLStreamException {
        this.xmlWriter.writeStartElement("properties");
        for (SimpleString key : message.getPropertyNames()) {
            Object value = message.getObjectProperty(key);
            this.xmlWriter.writeEmptyElement("property");
            this.xmlWriter.writeAttribute("name", key.toString());
            this.xmlWriter.writeAttribute("value", XmlDataExporterUtil.convertProperty(value));
            String propertyType = XmlDataExporterUtil.getPropertyType(value);
            if (propertyType == null) continue;
            this.xmlWriter.writeAttribute("type", propertyType);
        }
        this.xmlWriter.writeEndElement();
    }

    private void printMessageAttributes(ICoreMessage message) throws XMLStreamException {
        this.xmlWriter.writeAttribute("id", Long.toString(message.getMessageID()));
        this.xmlWriter.writeAttribute("priority", Byte.toString(message.getPriority()));
        this.xmlWriter.writeAttribute("expiration", Long.toString(message.getExpiration()));
        this.xmlWriter.writeAttribute("timestamp", Long.toString(message.getTimestamp()));
        String prettyType = XmlDataExporterUtil.getMessagePrettyType(message.getType());
        this.xmlWriter.writeAttribute("type", prettyType);
        if (message.getUserID() != null) {
            this.xmlWriter.writeAttribute("user-id", message.getUserID().toString());
        }
    }

    private List<String> extractQueueNames(HashMap<Long, DescribeJournal.ReferenceDescribe> refMap) {
        ArrayList<String> queues = new ArrayList<String>();
        for (DescribeJournal.ReferenceDescribe ref : refMap.values()) {
            queues.add(this.queueBindings.get(ref.refEncoding.queueID).getQueueName().toString());
        }
        return queues;
    }

    static class PrettyPrintHandler
    implements InvocationHandler {
        private final XMLStreamWriter target;
        private int depth = 0;
        private static final char INDENT_CHAR = ' ';
        private static final String LINE_SEPARATOR = System.getProperty("line.separator");
        boolean wrap = true;

        PrettyPrintHandler(XMLStreamWriter target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String m;
            switch (m = method.getName()) {
                case "writeStartElement": {
                    this.target.writeCharacters(LINE_SEPARATOR);
                    this.target.writeCharacters(this.indent(this.depth));
                    ++this.depth;
                    break;
                }
                case "writeEndElement": {
                    --this.depth;
                    if (this.wrap) {
                        this.target.writeCharacters(LINE_SEPARATOR);
                        this.target.writeCharacters(this.indent(this.depth));
                    }
                    this.wrap = true;
                    break;
                }
                case "writeEmptyElement": 
                case "writeCData": {
                    this.target.writeCharacters(LINE_SEPARATOR);
                    this.target.writeCharacters(this.indent(this.depth));
                    break;
                }
                case "writeCharacters": {
                    this.wrap = false;
                }
            }
            method.invoke((Object)this.target, args);
            return null;
        }

        private String indent(int depth) {
            char[] output = new char[depth *= 3];
            while (depth-- > 0) {
                output[depth] = 32;
            }
            return new String(output);
        }
    }
}

