package org.apache.activemq.artemis.integration.bootstrap;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2022-08-30T18:13:36-0400")
public class ActiveMQBootstrapLogger_$logger extends DelegatingBasicLogger implements ActiveMQBootstrapLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ActiveMQBootstrapLogger_$logger.class.getName();
    public ActiveMQBootstrapLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void serverStarting() {
        super.log.logv(FQCN, INFO, null, serverStarting$str());
    }
    protected String serverStarting$str() {
        return "AMQ101000: Starting ActiveMQ Artemis Server";
    }
    @Override
    public final void serverStopping() {
        super.log.logv(FQCN, INFO, null, serverStopping$str());
    }
    protected String serverStopping$str() {
        return "AMQ101001: Stopping ActiveMQ Artemis Server";
    }
    @Override
    public final void startedNamingService(final String bindAddress, final int port, final String rmiBindAddress, final int rmiPort) {
        super.log.logv(FQCN, INFO, null, startedNamingService$str(), bindAddress, port, rmiBindAddress, rmiPort);
    }
    protected String startedNamingService$str() {
        return "AMQ101002: Starting Naming server on {0}:{1,number,#} (rmi {2}:{3,number,#})";
    }
    @Override
    public final void serverKilled() {
        super.log.logv(FQCN, INFO, null, serverKilled$str());
    }
    protected String serverKilled$str() {
        return "AMQ101003: Halting ActiveMQ Artemis Server after user request";
    }
    @Override
    public final void usingBrokerConfig(final String location) {
        super.log.logv(FQCN, DEBUG, null, usingBrokerConfig$str(), location);
    }
    protected String usingBrokerConfig$str() {
        return "AMQ101005: Using broker configuration: {0}";
    }
    @Override
    public final void errorDuringUndeployment(final Throwable t, final String name) {
        super.log.logv(FQCN, WARN, t, errorDuringUndeployment$str(), name);
    }
    protected String errorDuringUndeployment$str() {
        return "AMQ102000: Error during undeployment: {0}";
    }
    @Override
    public final void errorDeletingFile(final String name) {
        super.log.logv(FQCN, ERROR, null, errorDeletingFile$str(), name);
    }
    protected String errorDeletingFile$str() {
        return "AMQ104000: Failed to delete file {0}";
    }
    @Override
    public final void errorStartingServer(final Exception e) {
        super.log.logv(FQCN, ERROR, e, errorStartingServer$str());
    }
    protected String errorStartingServer$str() {
        return "AMQ104001: Failed to start server";
    }
    @Override
    public final void printDataFailed(final String exceptionMessage) {
        super.log.logv(FQCN, ERROR, null, printDataFailed$str(), exceptionMessage);
    }
    protected String printDataFailed$str() {
        return "AMQ104002: The print data operation failed: {0}";
    }
}
