/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.queue;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;

@Command(name="stat", description="prints out basic stats associated with queues. Output includes CONSUMER_COUNT (number of consumers), MESSAGE_COUNT (current message count on the queue, including scheduled, paged and in-delivery messages), MESSAGES_ADDED (messages added to the queue), DELIVERING_COUNT (messages broker is currently delivering to consumer(s)), MESSAGES_ACKED (messages acknowledged from the consumer(s)). Queues can be filtered using EITHER '--queueName X' where X is contained in the queue name OR using a full filter '--field NAME --operation EQUALS --value X'.")
public class StatQueue
extends AbstractAction {
    public static final int DEFAULT_MAX_ROWS = 50;
    public static final int DEFAULT_MAX_COLUMN_SIZE = 25;
    @Option(name={"--queueName"}, description="display queue stats for queue(s) with names containing this string.")
    private String queueName;
    @Option(name={"--field"}, description="field to use in filter. Possible values NAME, ADDRESS, MESSAGE_COUNT, MESSAGES_ADDED, DELIVERING_COUNT, MESSAGES_ACKED, SCHEDULED_COUNT, ROUTING_TYPE.")
    private String fieldName;
    @Option(name={"--operation"}, description="operation to use in filter. Possible values CONTAINS, NOT_CONTAINS, EQUALS, GREATER_THAN, LESS_THAN.")
    private String operationName;
    @Option(name={"--value"}, description="value to use in the filter.")
    private String value;
    @Option(name={"--maxRows"}, description="max number of queues displayed. Default is 50.")
    private int maxRows = 50;
    @Option(name={"--maxColumnSize"}, description="max width of data column. Set to -1 for no limit. Default is 25.")
    private int maxColumnSize = 25;

    public StatQueue setQueueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public StatQueue setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public StatQueue setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public StatQueue setValue(String value) {
        this.value = value;
        return this;
    }

    public StatQueue setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        return this;
    }

    public StatQueue setMaxColumnSize(int maxColumnSize) {
        int maxFieldSize = 0;
        for (FIELD e : FIELD.values()) {
            if (e.jsonId.length() <= maxFieldSize) continue;
            maxFieldSize = e.jsonId.length();
        }
        if (maxColumnSize != -1 && maxColumnSize < maxFieldSize) {
            throw new IllegalArgumentException("maxColumnSize must be " + maxFieldSize + " or greater or -1 (i.e. no limit).");
        }
        this.maxColumnSize = maxColumnSize;
        return this;
    }

    public StatQueue setverbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        String filter = this.createFilter();
        if (filter == null) {
            return null;
        }
        if (this.verbose) {
            this.getActionContext().out.println("filter is '" + filter + "'");
            this.getActionContext().out.println("maxRows='" + this.maxRows + "'");
        }
        this.printStats(this.getActionContext(), filter);
        return null;
    }

    private void printStats(ActionContext context, final String filter) throws Exception {
        this.performCoreManagement(new AbstractAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"listQueues", (Object[])new Object[]{filter, 1, StatQueue.this.maxRows});
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                String result = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                StatQueue.this.printStats(result);
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                ((StatQueue)StatQueue.this).getActionContext().err.println("Failed to get Stats for Queues. Reason: " + errMsg);
            }
        });
    }

    private void printStats(String result) {
        int i;
        if (result == null) {
            if (this.verbose) {
                this.getActionContext().err.println("printStats(): got NULL result string.");
            }
            return;
        }
        JsonObject queuesAsJsonObject = JsonUtil.readJsonObject((String)result);
        int count = queuesAsJsonObject.getInt("count");
        JsonArray array = queuesAsJsonObject.getJsonArray("data");
        int[] columnSizes = new int[FIELD.values().length];
        FIELD[] fields = FIELD.values();
        for (i = 0; i < fields.length; ++i) {
            columnSizes[i] = fields[i].toString().length();
        }
        for (i = 0; i < array.size(); ++i) {
            this.getColumnSizes(array.getJsonObject(i), columnSizes);
        }
        this.printHeadings(columnSizes);
        for (i = 0; i < array.size(); ++i) {
            this.printQueueStats(array.getJsonObject(i), columnSizes);
        }
        if (count > this.maxRows) {
            this.getActionContext().out.println(String.format("WARNING: the displayed queues are %d/%d, set maxRows to display more queues.", this.maxRows, count));
        }
    }

    private void getColumnSizes(JsonObject jsonObject, int[] columnSizes) {
        int i = 0;
        for (FIELD e : FIELD.values()) {
            if (jsonObject.getString(e.jsonId).length() > columnSizes[i]) {
                columnSizes[i] = jsonObject.getString(e.jsonId).length();
            }
            if (columnSizes[i] > this.maxColumnSize && this.maxColumnSize != -1) {
                columnSizes[i] = this.maxColumnSize;
            }
            ++i;
        }
    }

    private void printHeadings(int[] columnSizes) {
        StringBuilder stringBuilder = new StringBuilder(Arrays.stream(columnSizes).sum() + FIELD.values().length + 1).append('|');
        int i = 0;
        for (FIELD e : FIELD.values()) {
            stringBuilder.append((CharSequence)this.paddingString(new StringBuilder(e.toString()), columnSizes[i++])).append('|');
        }
        this.getActionContext().out.println(stringBuilder);
    }

    private void printQueueStats(JsonObject jsonObject, int[] columnSizes) {
        if (jsonObject == null) {
            if (this.verbose) {
                this.getActionContext().err.println("printQueueStats(): jsonObject is null");
            }
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(Arrays.stream(columnSizes).sum() + FIELD.values().length + 1).append('|');
        int i = 0;
        for (FIELD e : FIELD.values()) {
            stringBuilder.append((CharSequence)this.paddingString(new StringBuilder(jsonObject.getString(e.jsonId)), columnSizes[i++])).append('|');
        }
        this.getActionContext().out.println(stringBuilder);
    }

    private StringBuilder paddingString(StringBuilder value, int maxColumnSize) {
        int length;
        if (value == null) {
            return new StringBuilder(maxColumnSize);
        }
        if (value.length() == 0) {
            value.append("NO DATA");
        }
        if ((length = value.length()) > maxColumnSize && this.maxColumnSize != -1) {
            return new StringBuilder(value.substring(0, maxColumnSize - 3) + "...");
        }
        int i = 1;
        while (i + length <= maxColumnSize) {
            value.append(' ');
            ++i;
        }
        return value;
    }

    private String createFilter() {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        if (this.fieldName != null && this.fieldName.trim().length() > 0 && this.queueName != null && this.queueName.trim().length() > 0) {
            this.getActionContext().err.println("'--field' and '--queueName' cannot be specified together.");
            return null;
        }
        if (this.fieldName != null && this.fieldName.trim().length() > 0) {
            try {
                FIELD field = FIELD.valueOfJsonId(this.fieldName);
                if (field == null) {
                    field = FIELD.valueOf(this.fieldName);
                }
                filterMap.put("field", field.toString());
            }
            catch (IllegalArgumentException ex) {
                this.getActionContext().err.println("'--field' must be set to one of the following " + Arrays.toString((Object[])FIELD.values()));
                return null;
            }
            if (this.value == null || this.value.trim().length() == 0) {
                this.getActionContext().err.println("'--value' needs to be set when '--field' is specified");
                return null;
            }
            filterMap.put("value", this.value);
            if (this.operationName == null) {
                this.getActionContext().err.println("'--operation' must be set when '--field' is specified " + Arrays.toString((Object[])OPERATION.values()));
                return null;
            }
            try {
                OPERATION operation = OPERATION.valueOf(this.operationName);
                filterMap.put("operation", operation.toString());
            }
            catch (IllegalArgumentException ex) {
                this.getActionContext().err.println("'--operation' must be set to one of the following " + Arrays.toString((Object[])OPERATION.values()));
                return null;
            }
        }
        if (this.queueName != null && this.queueName.trim().length() > 0) {
            filterMap.put("field", FIELD.NAME.toString());
            filterMap.put("value", this.queueName);
            filterMap.put("operation", OPERATION.CONTAINS.toString());
        } else {
            filterMap.put("field", "");
            filterMap.put("value", "");
            filterMap.put("operation", "");
        }
        JsonObject filterJsonObject = JsonUtil.toJsonObject(filterMap);
        return filterJsonObject.toString();
    }

    public static enum OPERATION {
        CONTAINS,
        NOT_CONTAINS,
        EQUALS,
        GREATER_THAN,
        LESS_THAN;

    }

    public static enum FIELD {
        NAME("name"),
        ADDRESS("address"),
        CONSUMER_COUNT("consumerCount"),
        MESSAGE_COUNT("messageCount"),
        MESSAGES_ADDED("messagesAdded"),
        DELIVERING_COUNT("deliveringCount"),
        MESSAGES_ACKED("messagesAcked"),
        SCHEDULED_COUNT("scheduledCount"),
        ROUTING_TYPE("routingType");

        private static final Map<String, FIELD> lookup;
        private String jsonId;

        private FIELD(String jsonId) {
            this.jsonId = jsonId;
        }

        String getJsonId() {
            return this.jsonId;
        }

        public static FIELD valueOfJsonId(String jsonId) {
            return lookup.get(jsonId);
        }

        static {
            lookup = new TreeMap<String, FIELD>(String.CASE_INSENSITIVE_ORDER);
            for (FIELD e : FIELD.values()) {
                lookup.put(e.jsonId, e);
            }
        }
    }
}

