/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.address;

import io.airlift.airline.Command;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.address.AddressAbstract;

@Command(name="create", description="Create an address.")
public class CreateAddress
extends AddressAbstract {
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.createAddress(context);
        return null;
    }

    private void createAddress(final ActionContext context) throws Exception {
        this.performCoreManagement(new AbstractAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"createAddress", (Object[])new Object[]{CreateAddress.this.getName(true), CreateAddress.this.getRoutingTypes(true)});
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                String result = ManagementHelper.getResult((ICoreMessage)reply, String.class) + " created successfully.";
                context.out.println(result);
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                context.err.println("Failed to create address " + CreateAddress.this.getName(true) + ". Reason: " + errMsg);
            }
        });
    }
}

