/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.queue;

import io.airlift.airline.Option;
import org.apache.activemq.artemis.cli.commands.AbstractAction;

public class QueueAbstract
extends AbstractAction {
    @Option(name={"--name"}, description="The queue's name.")
    private String name;
    @Option(name={"--filter"}, description="The queue's filter string. Default: null.")
    private String filter = null;
    @Option(name={"--address"}, description="The queue's address. Default: queue's name.")
    private String address;
    @Option(name={"--durable"}, description="The queue is durable. Default: input.")
    private Boolean durable;
    @Option(name={"--no-durable"}, description="The queue is not durable. Default: input.")
    private Boolean noDurable;
    @Option(name={"--purge-on-no-consumers"}, description="Delete the contents of this queue when its last consumer disconnects. Default: input.")
    private Boolean purgeOnNoConsumers;
    @Option(name={"--preserve-on-no-consumers"}, description="Preserve the contents of this queue when its last consumer disconnects. Default: input.")
    private Boolean preserveOnNoConsumers;
    @Option(name={"--max-consumers"}, description="The maximum number of concurrent consumers allowed on this queue. Default: no limit.")
    private Integer maxConsumers;
    @Option(name={"--auto-create-address"}, description="Automatically create the address (if it doesn't exist) with default values. Default: input.")
    private Boolean autoCreateAddress;
    @Option(name={"--anycast"}, description="Create an anycast queue. Default: input.")
    private Boolean anycast;
    @Option(name={"--multicast"}, description="Create a multicast queue. Default: input.")
    private Boolean multicast;

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getAddress(boolean requireInput) {
        String queueName = this.getName();
        if (requireInput && (this.address == null || "".equals(this.address.trim()))) {
            this.address = this.input("--address", "What is the name of the address? <Enter for " + queueName + ">", null, true);
        }
        if (this.address == null || "".equals(this.address.trim())) {
            this.address = queueName;
        }
        return this.address;
    }

    public boolean isDurable() {
        if (this.durable == null && this.noDurable != null) {
            this.durable = this.noDurable == false;
        }
        if (this.durable == null) {
            this.durable = this.inputBoolean("--durable", "Is this a durable queue?", false);
        }
        return this.durable;
    }

    public QueueAbstract setDurable(boolean durable) {
        this.durable = durable;
        return this;
    }

    public boolean getPreserveOnNoConsumers() {
        return this.preserveOnNoConsumers;
    }

    public QueueAbstract setPreserveOnNoConsumers(boolean preserveOnNoConsumers) {
        this.preserveOnNoConsumers = preserveOnNoConsumers;
        return this;
    }

    public Integer getMaxConsumers(Integer defaultValue) {
        if (this.maxConsumers == null) {
            return defaultValue;
        }
        return this.maxConsumers;
    }

    public boolean isAutoCreateAddress() {
        if (this.autoCreateAddress == null) {
            this.autoCreateAddress = this.inputBoolean("--auto-create-address", "Automatically create the address if it doesn't exist?", false);
        }
        return this.autoCreateAddress;
    }

    public QueueAbstract setAutoCreateAddress(boolean autoCreateAddress) {
        this.autoCreateAddress = autoCreateAddress;
        return this;
    }

    public boolean isAnycast() {
        if (this.anycast == null) {
            if (this.multicast != null) {
                this.anycast = this.multicast == false;
            }
            if (this.anycast == null) {
                this.anycast = this.inputBoolean("--anycast", "Is this an anycast queue?", false);
            }
        }
        return this.anycast;
    }

    public QueueAbstract setAnycast(boolean anycast) {
        this.anycast = anycast;
        return this;
    }

    public boolean isMulticast() {
        if (this.multicast == null) {
            if (this.anycast != null) {
                this.multicast = this.anycast == false;
            }
            if (this.multicast == null) {
                this.multicast = this.inputBoolean("--multicast", "Is this a multicast queue?", false);
            }
        }
        return this.multicast;
    }

    public QueueAbstract setMulticast(boolean multicast) {
        this.multicast = multicast;
        return this;
    }

    public Boolean isPurgeOnNoConsumers() {
        return this.isPurgeOnNoConsumers(false);
    }

    public Boolean isPurgeOnNoConsumers(boolean useInput) {
        Boolean value = null;
        if (this.purgeOnNoConsumers != null) {
            value = (boolean)this.purgeOnNoConsumers;
        } else if (this.preserveOnNoConsumers != null) {
            value = this.preserveOnNoConsumers == false;
        }
        if (value == null && useInput) {
            value = this.inputBoolean("--purge-on-no-consumers", "Purge the contents of the queue once the last consumer disconnects?", false);
        }
        if (value == null) {
            return null;
        }
        this.purgeOnNoConsumers = (boolean)value;
        this.preserveOnNoConsumers = value == false;
        return value;
    }

    public void setMaxConsumers(int maxConsumers) {
        this.maxConsumers = maxConsumers;
    }

    public void setPurgeOnNoConsumers(boolean purgeOnNoConsumers) {
        this.purgeOnNoConsumers = purgeOnNoConsumers;
    }

    public QueueAbstract setAddress(String address) {
        this.address = address;
        return this;
    }

    public QueueAbstract setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.input("--name", "What is the name of the queue?", "");
        }
        return this.name;
    }

    public String getRoutingType() {
        if (this.isAnycast() && this.isMulticast()) {
            throw new IllegalArgumentException("--multicast and --anycast are exclusive options for a queue");
        }
        if (this.isMulticast()) {
            return "MULTICAST";
        }
        if (this.anycast.booleanValue()) {
            return "ANYCAST";
        }
        return null;
    }
}

