/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.queue;

import io.airlift.airline.Command;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.AbstractAction;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.queue.QueueAbstract;

@Command(name="update", description="Update a queue.")
public class UpdateQueue
extends QueueAbstract {
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.updateQueue(context);
        return null;
    }

    private void updateQueue(final ActionContext context) throws Exception {
        this.performCoreManagement(new AbstractAction.ManagementCallback<ClientMessage>(){

            @Override
            public void setUpInvocation(ClientMessage message) throws Exception {
                ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"updateQueue", (Object[])new Object[]{UpdateQueue.this.getName(), UpdateQueue.this.getRoutingType(), UpdateQueue.this.getMaxConsumers(null), UpdateQueue.this.isPurgeOnNoConsumers()});
            }

            @Override
            public void requestSuccessful(ClientMessage reply) throws Exception {
                String result = ManagementHelper.getResult((ICoreMessage)reply, String.class) + " updated successfully.";
                context.out.println(result);
            }

            @Override
            public void requestFailed(ClientMessage reply) throws Exception {
                String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
                context.err.println("Failed to update " + UpdateQueue.this.getName() + ". Reason: " + errMsg);
            }
        });
    }
}

