/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import com.github.rvesse.airline.annotations.AirlineModule;
import com.github.rvesse.airline.annotations.Arguments;
import com.github.rvesse.airline.annotations.Option;
import com.github.rvesse.airline.help.Help;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.cli.commands.ActionAbstract;
import org.apache.activemq.artemis.cli.factory.BrokerFactory;
import org.apache.activemq.artemis.cli.factory.jmx.ManagementFactory;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.dto.BrokerDTO;
import org.apache.activemq.artemis.dto.ManagementContextDTO;
import org.apache.activemq.artemis.jms.server.config.impl.FileJMSConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Configurable
extends ActionAbstract {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Arguments(description="Broker Configuration URI. Default: xml:${ARTEMIS_INSTANCE}/etc/bootstrap.xml.")
    String configuration;
    @Option(name={"--broker"}, description="Override the broker configuration from the bootstrap.xml.")
    String brokerConfig;
    @AirlineModule
    public GlobalMetadata<Object> global;
    private BrokerDTO brokerDTO = null;
    private FileConfiguration fileConfiguration;

    protected void treatError(Exception e, String group, String command) {
        logger.debug(e.getMessage(), (Throwable)e);
        System.err.println();
        System.err.println("Error:" + e.getMessage());
        System.err.println();
        if (!(e instanceof ActiveMQException)) {
            e.printStackTrace();
        }
        this.helpGroup(group, command);
    }

    protected void helpGroup(String groupName, String commandName) {
        for (CommandGroupMetadata group : this.global.getCommandGroups()) {
            if (!group.getName().equals(groupName)) continue;
            for (CommandMetadata command : group.getCommands()) {
                if (!command.getName().equals(commandName)) continue;
                try {
                    Help.help((CommandMetadata)command);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    protected FileConfiguration getFileConfiguration() throws Exception {
        if (this.fileConfiguration == null) {
            this.fileConfiguration = this.readConfiguration();
        }
        return this.fileConfiguration;
    }

    protected FileConfiguration readConfiguration() throws Exception {
        FileConfiguration fileConfiguration = new FileConfiguration();
        if (this.getBrokerInstance() == null) {
            String defaultLocation = "./data";
            fileConfiguration = new FileConfiguration();
            fileConfiguration.setBindingsDirectory("./data/bindings");
            fileConfiguration.setJournalDirectory("./data/journal");
            fileConfiguration.setLargeMessagesDirectory("./data/largemessages");
            fileConfiguration.setPagingDirectory("./data/paging");
            fileConfiguration.setBrokerInstance(new File("."));
        } else {
            FileJMSConfiguration jmsConfiguration = new FileJMSConfiguration();
            String serverConfiguration = this.getBrokerDTO().server.getConfigurationURI().toASCIIString();
            FileDeploymentManager fileDeploymentManager = new FileDeploymentManager(serverConfiguration);
            fileDeploymentManager.addDeployable((Deployable)fileConfiguration).addDeployable((Deployable)jmsConfiguration);
            fileDeploymentManager.readConfiguration();
            fileConfiguration.setBrokerInstance(new File(this.getBrokerInstance()));
        }
        return fileConfiguration;
    }

    protected BrokerDTO getBrokerDTO() throws Exception {
        if (this.brokerDTO == null) {
            this.getConfiguration();
            this.brokerDTO = BrokerFactory.createBrokerConfiguration(this.configuration, this.getBrokerHome(), this.getBrokerInstance(), this.getBrokerURIInstance());
            if (this.brokerConfig != null) {
                if (!this.brokerConfig.startsWith("file:")) {
                    this.brokerConfig = "file:" + this.brokerConfig;
                }
                this.brokerDTO.server.configuration = this.brokerConfig;
            }
        }
        return this.brokerDTO;
    }

    protected ManagementContextDTO getManagementDTO() throws Exception {
        String configuration = this.getManagementConfiguration();
        return ManagementFactory.createJmxAclConfiguration(configuration, this.getBrokerHome(), this.getBrokerInstance(), this.getBrokerURIInstance());
    }

    protected String getConfiguration() {
        if (this.configuration == null) {
            File xmlFile = new File(new File(this.getBrokerEtc()), "bootstrap.xml");
            this.configuration = "xml:" + xmlFile.toURI().toString().substring("file:".length());
            this.configuration = this.configuration.replace("\\", "/");
            logger.debug("Using broker configuration: {}", (Object)this.configuration);
        }
        return this.configuration;
    }

    protected String getManagementConfiguration() {
        File xmlFile = new File(new File(this.getBrokerEtc()), "management.xml");
        Object configuration = "xml:" + xmlFile.toURI().toString().substring("file:".length());
        configuration = ((String)configuration).replace("\\", "/");
        return configuration;
    }
}

