/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.queue;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionAbstract;

@Command(name="delete", description="Delete a queue.")
public class DeleteQueue
extends ConnectionAbstract {
    @Option(name={"--name"}, description="The queue's name")
    String name;
    @Option(name={"--removeConsumers"}, description="Whether to delete the queue even if it has active consumers. Default: false.")
    boolean removeConsumers = false;
    @Option(name={"--autoDeleteAddress"}, description="Whether to delete the address if this is its only queue.")
    boolean autoDeleteAddress = false;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.deleteQueue(context);
        return null;
    }

    private void deleteQueue(ActionContext context) throws Exception {
        this.performCoreManagement(message -> ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"destroyQueue", (Object[])new Object[]{this.getName(), this.removeConsumers, this.autoDeleteAddress}), reply -> context.out.println("Queue " + this.getName() + " deleted successfully."), reply -> {
            String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
            context.err.println("Failed to delete queue " + this.getName() + ". Reason: " + errMsg);
        });
    }

    public void setRemoveConsumers(boolean removeConsumers) {
        this.removeConsumers = removeConsumers;
    }

    public void setAutoDeleteAddress(boolean autoDeleteAddress) {
        this.autoDeleteAddress = autoDeleteAddress;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.input("--name", "What is the name of the queue?", "");
        }
        return this.name;
    }
}

