/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.queue;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionAbstract;

@Command(name="purge", description="Delete all messages in a queue.")
public class PurgeQueue
extends ConnectionAbstract {
    @Option(name={"--name"}, description="The queue's name.")
    String name;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.purgeQueue(context);
        return null;
    }

    private void purgeQueue(ActionContext context) throws Exception {
        this.performCoreManagement(message -> ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)("queue." + this.getName()), (String)"removeAllMessages"), reply -> context.out.println("Queue " + this.getName() + " purged successfully."), reply -> {
            String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
            context.err.println("Failed to purge queue " + this.getName() + ". Reason: " + errMsg);
        });
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.input("--name", "What is the name of the queue?", "");
        }
        return this.name;
    }
}

