/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.user;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.user.PasswordAction;

@Command(name="add", description="Add a user.")
public class AddUser
extends PasswordAction {
    @Option(name={"--plaintext"}, description="Store the password in plaintext. Default: false.")
    boolean plaintext = false;

    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.checkInputUser();
        this.checkInputPassword();
        this.checkInputRole();
        this.add();
        return null;
    }

    private void add() throws Exception {
        this.performCoreManagement(message -> ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"addUser", (Object[])new Object[]{this.userCommandUser, this.userCommandPassword, this.role, this.plaintext}), reply -> this.getActionContext().out.println(this.userCommandUser + " added successfully."), reply -> {
            String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
            this.getActionContext().err.println("Failed to add user " + this.userCommandUser + ". Reason: " + errMsg);
        });
    }
}

