/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.user;

import com.github.rvesse.airline.annotations.Command;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.user.UserAction;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonObject;

@Command(name="list", description="List user(s).")
public class ListUser
extends UserAction {
    @Override
    public Object execute(ActionContext context) throws Exception {
        super.execute(context);
        this.list();
        return null;
    }

    private void list() throws Exception {
        StringBuilder logMessage = new StringBuilder("--- \"user\"(roles) ---\n");
        int userCount = 0;
        String[] result = new String[1];
        this.performCoreManagement(message -> ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"listUser", (Object[])new Object[]{this.userCommandUser}), reply -> {
            result[0] = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
        }, reply -> {
            String errMsg = (String)ManagementHelper.getResult((ICoreMessage)reply, String.class);
            this.getActionContext().err.println("Failed to list user " + this.userCommandUser + ". Reason: " + errMsg);
        });
        JsonArray array = JsonUtil.readJsonArray((String)result[0]);
        for (int arrayIndex = 0; arrayIndex < array.size(); ++arrayIndex) {
            JsonObject object = array.getJsonObject(arrayIndex);
            logMessage.append("\"").append(object.getString("username")).append("\"").append("(");
            JsonArray roles = object.getJsonArray("roles");
            for (int i = 0; i < roles.size(); ++i) {
                logMessage.append(roles.getString(i));
                if (i + 1 >= roles.size()) continue;
                logMessage.append(",");
            }
            logMessage.append(")\n");
            ++userCount;
        }
        logMessage.append("\n Total: ").append(userCount);
        this.getActionContext().out.println(logMessage);
    }
}

