/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools.xml;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLMessageImporter {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private XMLStreamReader reader;
    private ClientSession session;
    Map<String, String> oldPrefixTranslation = new HashMap<String, String>();

    public XMLMessageImporter(XMLStreamReader xmlStreamReader, ClientSession session) {
        this.reader = xmlStreamReader;
        this.session = session;
    }

    public void setOldPrefixTranslation(Map<String, String> oldPrefixTranslation) {
        this.oldPrefixTranslation = oldPrefixTranslation;
    }

    public XMLStreamReader getRawXMLReader() {
        return this.reader;
    }

    public MessageInfo readMessage(boolean decodeUTF8) throws Exception {
        if (!this.reader.hasNext()) {
            return null;
        }
        Byte type = 0;
        Byte priority = 0;
        long expiration = 0L;
        long timestamp = 0L;
        long id = 0L;
        UUID userId = null;
        ArrayList<String> queues = new ArrayList<String>();
        block20: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "type": {
                    type = this.getMessageType(this.reader.getAttributeValue(i));
                    continue block20;
                }
                case "priority": {
                    priority = Byte.parseByte(this.reader.getAttributeValue(i));
                    continue block20;
                }
                case "expiration": {
                    expiration = Long.parseLong(this.reader.getAttributeValue(i));
                    continue block20;
                }
                case "timestamp": {
                    timestamp = Long.parseLong(this.reader.getAttributeValue(i));
                    continue block20;
                }
                case "user-id": {
                    userId = UUIDGenerator.getInstance().generateUUID();
                    continue block20;
                }
                case "id": {
                    id = Long.parseLong(this.reader.getAttributeValue(i));
                }
            }
        }
        ClientMessage message = this.session.createMessage(type.byteValue(), true, expiration, timestamp, priority.byteValue());
        message.setUserID(userId);
        boolean endLoop = false;
        Object largeMessageTemporaryFile = null;
        while (this.reader.hasNext()) {
            int eventType = this.reader.getEventType();
            switch (eventType) {
                case 1: {
                    if ("body".equals(this.reader.getLocalName())) {
                        this.processMessageBody(message.toCore(), decodeUTF8);
                        break;
                    }
                    if ("property".equals(this.reader.getLocalName())) {
                        this.processMessageProperties((Message)message);
                        break;
                    }
                    if (!"queue".equals(this.reader.getLocalName())) break;
                    this.processMessageQueues(queues);
                    break;
                }
                case 2: {
                    if (!"message".equals(this.reader.getLocalName())) break;
                    endLoop = true;
                }
            }
            if (endLoop) break;
            this.reader.next();
        }
        return new MessageInfo(id, queues, (Message)message);
    }

    private Byte getMessageType(String value) {
        Byte type = 0;
        switch (value) {
            case "default": {
                type = 0;
                break;
            }
            case "bytes": {
                type = 4;
                break;
            }
            case "map": {
                type = 5;
                break;
            }
            case "object": {
                type = 2;
                break;
            }
            case "stream": {
                type = 6;
                break;
            }
            case "text": {
                type = 3;
            }
        }
        return type;
    }

    private void processMessageQueues(ArrayList<String> queues) {
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (!"name".equals(this.reader.getAttributeLocalName(i))) continue;
            String queueName = this.reader.getAttributeValue(i);
            String translation = this.checkPrefix(queueName);
            queues.add(translation);
        }
    }

    private String checkPrefix(String queueName) {
        String newQueueName = this.oldPrefixTranslation.get(queueName);
        if (newQueueName == null) {
            newQueueName = queueName;
        }
        return newQueueName;
    }

    private void processMessageProperties(Message message) {
        String key = "";
        String value = "";
        String propertyType = "";
        block34: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "name": {
                    key = this.reader.getAttributeValue(i);
                    continue block34;
                }
                case "value": {
                    value = this.reader.getAttributeValue(i);
                    continue block34;
                }
                case "type": {
                    propertyType = this.reader.getAttributeValue(i);
                }
            }
        }
        if (value.equals("_AMQ_NULL")) {
            value = null;
        }
        switch (propertyType) {
            case "short": {
                message.putShortProperty(key, Short.parseShort(value));
                break;
            }
            case "boolean": {
                message.putBooleanProperty(key, Boolean.parseBoolean(value));
                break;
            }
            case "byte": {
                message.putByteProperty(key, Byte.parseByte(value));
                break;
            }
            case "bytes": {
                message.putBytesProperty(key, value == null ? null : XMLMessageImporter.decode(value));
                break;
            }
            case "double": {
                message.putDoubleProperty(key, Double.parseDouble(value));
                break;
            }
            case "float": {
                message.putFloatProperty(key, Float.parseFloat(value));
                break;
            }
            case "integer": {
                message.putIntProperty(key, Integer.parseInt(value));
                break;
            }
            case "long": {
                message.putLongProperty(key, Long.parseLong(value));
                break;
            }
            case "simple-string": {
                message.putStringProperty(SimpleString.of((String)key), value == null ? null : SimpleString.of((String)value));
                break;
            }
            case "string": {
                message.putStringProperty(key, value);
            }
        }
    }

    private void processMessageBody(ICoreMessage message, boolean decodeTextMessage) throws XMLStreamException, IOException {
        Object tempFileName = null;
        boolean isLarge = false;
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName = this.reader.getAttributeLocalName(i);
            if (!"isLarge".equals(attributeName)) continue;
            isLarge = Boolean.parseBoolean(this.reader.getAttributeValue(i));
        }
        this.reader.next();
        logger.debug("XMLStreamReader impl: {}", (Object)this.reader);
        this.getMessageBodyBytes(bytes -> message.getBodyBuffer().writeBytes(bytes), message.toCore().getType() == 3 && decodeTextMessage);
    }

    private void getMessageBodyBytes(MessageBodyBytesProcessor processor, boolean decodeTextMessage) throws IOException, XMLStreamException {
        int currentEventType;
        StringBuilder cdata = new StringBuilder();
        while (this.reader.hasNext() && (currentEventType = this.reader.getEventType()) != 2) {
            if (currentEventType == 4 && this.reader.isWhiteSpace() && cdata.length() > 0) {
                if (decodeTextMessage) {
                    SimpleString text = SimpleString.of((String)cdata.toString());
                    ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer(SimpleString.sizeofNullableString((SimpleString)text));
                    SimpleString.writeNullableSimpleString((ByteBuf)byteBuf, (SimpleString)text);
                    byte[] bytes = new byte[SimpleString.sizeofNullableString((SimpleString)text)];
                    byteBuf.readBytes(bytes);
                    processor.processBodyBytes(bytes);
                } else {
                    processor.processBodyBytes(XMLMessageImporter.decode(cdata.toString()));
                    cdata.setLength(0);
                }
            } else {
                cdata.append(new String(this.reader.getTextCharacters(), this.reader.getTextStart(), this.reader.getTextLength()).trim());
            }
            this.reader.next();
        }
    }

    private static byte[] decode(String data) {
        return Base64.decode((String)data, (int)24);
    }

    public class MessageInfo {
        public long id;
        public List<String> queues;
        public Message message;

        MessageInfo(long id, List<String> queues, Message message) {
            this.message = message;
            this.queues = queues;
            this.id = id;
        }
    }

    private static interface MessageBodyBytesProcessor {
        public void processBodyBytes(byte[] var1) throws IOException;
    }
}

