/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.util;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.jlibaio.LibaioContext;
import org.apache.activemq.artemis.utils.ReusableLatch;

public class SyncCalculation {
    private static final long MAX_FLUSH_NANOS = TimeUnit.SECONDS.toNanos(5L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long syncTest(File datafolder, int blockSize, int blocks, int tries, boolean verbose, boolean fsync, boolean syncWrites, String fileName, int maxAIO, JournalType journalType) throws Exception {
        boolean asyncWrites;
        SequentialFileFactory factory = SyncCalculation.newFactory(datafolder, fsync, journalType, blockSize * blocks, maxAIO);
        boolean bl = asyncWrites = journalType == JournalType.ASYNCIO && !syncWrites;
        if (journalType == JournalType.ASYNCIO && syncWrites) {
            System.out.println();
            System.out.println("*******************************************************************************************");
            System.out.println("*** Notice: The recommendation for AsyncIO journal is to not use --sync-writes          ***");
            System.out.println("***         The measures here will be useful to understand your device                  ***");
            System.out.println("***         however the result here won't represent the best configuration option       ***");
            System.out.println("*******************************************************************************************");
            System.out.println();
        }
        if (verbose) {
            System.out.println("Using " + factory.getClass().getName() + " to calculate sync times, alignment=" + factory.getAlignment());
        }
        SequentialFile file = factory.createSequentialFile(fileName);
        file.getJavaFile().deleteOnExit();
        try {
            ByteBuffer bufferBlock = SyncCalculation.allocateAlignedBlock(blockSize, factory);
            blockSize = bufferBlock.remaining();
            file.delete();
            file.open();
            file.fill(blockSize * blocks);
            file.close();
            long[] result = new long[tries];
            final ReusableLatch latch = new ReusableLatch(0);
            IOCallback callback = new IOCallback(){

                public void done() {
                    latch.countDown();
                }

                public void onError(int errorCode, String errorMessage) {
                }
            };
            DecimalFormat dcformat = new DecimalFormat("###.##");
            for (int ntry = 0; ntry < tries; ++ntry) {
                if (verbose) {
                    System.out.println("**************************************************");
                    System.out.println(ntry + " of " + tries + " calculation");
                }
                file.open();
                file.position(0L);
                long start = System.currentTimeMillis();
                for (int i = 0; i < blocks; ++i) {
                    bufferBlock.position(0);
                    latch.countUp();
                    long startWrite = 0L;
                    file.writeDirect(bufferBlock, true, callback);
                    if (!syncWrites) continue;
                    SyncCalculation.flushLatch(latch);
                }
                if (!syncWrites) {
                    SyncCalculation.flushLatch(latch);
                }
                long end = System.currentTimeMillis();
                result[ntry] = end - start;
                if (verbose) {
                    double writesPerMillisecond = (double)blocks / (double)result[ntry];
                    System.out.println("Time = " + result[ntry] + " milliseconds");
                    System.out.println("Writes / millisecond = " + dcformat.format(writesPerMillisecond));
                    System.out.println("bufferTimeout = " + SyncCalculation.toNanos(result[ntry], blocks, verbose));
                    System.out.println("**************************************************");
                }
                file.close();
            }
            factory.releaseDirectBuffer(bufferBlock);
            long totalTime = Long.MAX_VALUE;
            for (int i = 0; i < tries; ++i) {
                if (result[i] >= totalTime) continue;
                totalTime = result[i];
            }
            long l = totalTime;
            return l;
        }
        finally {
            try {
                file.close();
            }
            catch (Exception exception) {}
            try {
                file.delete();
            }
            catch (Exception exception) {}
            try {
                factory.stop();
            }
            catch (Exception exception) {}
        }
    }

    private static ByteBuffer allocateAlignedBlock(int blockSize, SequentialFileFactory factory) {
        ByteBuffer bufferBlock = factory.newBuffer(blockSize);
        byte[] block = new byte[bufferBlock.remaining()];
        Arrays.fill(block, (byte)116);
        bufferBlock.put(block);
        bufferBlock.position(0);
        return bufferBlock;
    }

    private static void flushLatch(ReusableLatch latch) throws InterruptedException, IOException {
        if (!latch.await(MAX_FLUSH_NANOS, TimeUnit.NANOSECONDS)) {
            throw new IOException("Timed out on receiving IO callback");
        }
    }

    public static long toNanos(long time, long blocks, boolean verbose) {
        double blocksPerMillisecond = (double)blocks / (double)time;
        if (verbose) {
            System.out.println("Blocks per millisecond::" + blocksPerMillisecond);
        }
        long nanoSeconds = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
        long timeWait = (long)((double)nanoSeconds / blocksPerMillisecond);
        if (verbose) {
            System.out.println("your system could make a sync every " + timeWait + " nanoseconds, and this will be your timeout");
        }
        return timeWait;
    }

    private static SequentialFileFactory newFactory(File datafolder, boolean datasync, JournalType journalType, int fileSize, int maxAIO) {
        if (journalType == JournalType.ASYNCIO && !LibaioContext.isLoaded()) {
            journalType = JournalType.NIO;
        }
        switch (journalType) {
            case NIO: {
                SequentialFileFactory factory = new NIOSequentialFileFactory(datafolder, 1).setDatasync(datasync);
                ((NIOSequentialFileFactory)factory).disableBufferReuse();
                factory.start();
                return factory;
            }
            case ASYNCIO: {
                SequentialFileFactory factory = new AIOSequentialFileFactory(datafolder, maxAIO).setDatasync(datasync);
                factory.start();
                ((AIOSequentialFileFactory)factory).disableBufferReuse();
                return factory;
            }
            case MAPPED: {
                MappedSequentialFileFactory factory = new MappedSequentialFileFactory(datafolder, fileSize, false, 0, 0, null).setDatasync(datasync).disableBufferReuse();
                factory.start();
                return factory;
            }
        }
        throw ActiveMQMessageBundle.BUNDLE.invalidJournalType2(journalType);
    }
}

