/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.uri;

import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.utils.uri.URIFactory;
import org.apache.commons.beanutils.BeanIntrospector;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;

public abstract class URISchema<T, P> {
    private URIFactory<T, P> parentFactory;
    private static final BeanUtilsBean beanUtils = new BeanUtilsBean();

    public abstract String getSchemaName();

    public T newObject(URI uri, P param) throws Exception {
        return this.newObject(uri, null, param);
    }

    public void populateObject(URI uri, T bean) throws Exception {
        URISchema.setData(uri, bean, URISchema.parseQuery(uri.getQuery(), null));
    }

    public URI newURI(T bean) throws Exception {
        return this.internalNewURI(bean);
    }

    void setFactory(URIFactory<T, P> factory) {
        this.parentFactory = factory;
    }

    protected URIFactory<T, P> getFactory() {
        return this.parentFactory;
    }

    protected String getHost(URI uri) {
        URI defaultFactory = this.getDefaultURI();
        if (defaultFactory != null && uri.getHost() == null && defaultFactory.getScheme().equals(uri.getScheme())) {
            uri = defaultFactory;
        }
        return uri.getHost();
    }

    protected URI getDefaultURI() {
        URIFactory<T, P> factory = this.getFactory();
        if (factory == null) {
            return null;
        }
        return factory.getDefaultURI();
    }

    protected int getPort(URI uri) {
        URI defaultFactory = this.getDefaultURI();
        if (defaultFactory != null && uri.getPort() < 0 && defaultFactory.getScheme().equals(uri.getScheme())) {
            uri = defaultFactory;
        }
        return uri.getPort();
    }

    public T newObject(URI uri, Map<String, String> propertyOverrides, P param) throws Exception {
        return this.internalNewObject(uri, URISchema.parseQuery(uri.getQuery(), propertyOverrides), param);
    }

    protected abstract T internalNewObject(URI var1, Map<String, String> var2, P var3) throws Exception;

    protected abstract URI internalNewURI(T var1) throws Exception;

    public static Map<String, String> parseQuery(String uri, Map<String, String> propertyOverrides) throws URISyntaxException {
        try {
            HashMap<String, String> rc = new HashMap<String, String>();
            if (uri != null && !uri.isEmpty()) {
                String[] parameters = uri.split("&");
                for (int i = 0; i < parameters.length; ++i) {
                    int p = parameters[i].indexOf("=");
                    if (p >= 0) {
                        String name = URLDecoder.decode(parameters[i].substring(0, p), "UTF-8");
                        String value = URLDecoder.decode(parameters[i].substring(p + 1), "UTF-8");
                        rc.put(name, value);
                        continue;
                    }
                    rc.put(parameters[i], null);
                }
            }
            if (propertyOverrides != null) {
                for (Map.Entry<String, String> entry : propertyOverrides.entrySet()) {
                    rc.put(entry.getKey(), entry.getValue());
                }
            }
            return rc;
        }
        catch (UnsupportedEncodingException e) {
            throw (URISyntaxException)new URISyntaxException(e.toString(), "Invalid encoding").initCause(e);
        }
    }

    protected String printQuery(Map<String, String> query) {
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry<String, String> entry : query.entrySet()) {
            buffer.append(entry.getKey() + "=" + entry.getValue());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <P> P copyData(P source, P target) throws Exception {
        BeanUtilsBean beanUtilsBean = beanUtils;
        synchronized (beanUtilsBean) {
            beanUtils.copyProperties(source, target);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <P> P setData(URI uri, P obj, Map<String, String> query) throws Exception {
        BeanUtilsBean beanUtilsBean = beanUtils;
        synchronized (beanUtilsBean) {
            beanUtils.setProperty(obj, "host", (Object)uri.getHost());
            beanUtils.setProperty(obj, "port", (Object)uri.getPort());
            beanUtils.setProperty(obj, "userInfo", (Object)uri.getUserInfo());
            beanUtils.populate(obj, query);
        }
        return obj;
    }

    public static void setData(URI uri, HashMap<String, Object> properties, Set<String> allowableProperties, Map<String, String> query) {
        if (allowableProperties.contains("host")) {
            properties.put("host", "" + uri.getHost());
        }
        if (allowableProperties.contains("port")) {
            properties.put("port", "" + uri.getPort());
        }
        if (allowableProperties.contains("userInfo")) {
            properties.put("userInfo", "" + uri.getUserInfo());
        }
        for (Map.Entry<String, String> entry : query.entrySet()) {
            if (!allowableProperties.contains(entry.getKey())) continue;
            properties.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getData(List<String> ignored, Object ... beans) throws Exception {
        StringBuilder sb = new StringBuilder();
        BeanUtilsBean beanUtilsBean = beanUtils;
        synchronized (beanUtilsBean) {
            for (Object bean : beans) {
                PropertyDescriptor[] descriptors;
                if (bean == null) continue;
                for (PropertyDescriptor descriptor : descriptors = beanUtils.getPropertyUtils().getPropertyDescriptors(bean)) {
                    String value;
                    if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null || !URISchema.isWriteable(descriptor, ignored) || (value = beanUtils.getProperty(bean, descriptor.getName())) == null) continue;
                    sb.append("&").append(descriptor.getName()).append("=").append(value);
                }
            }
        }
        return sb.toString();
    }

    private static boolean isWriteable(PropertyDescriptor descriptor, List<String> ignored) {
        if (ignored != null && ignored.contains(descriptor.getName())) {
            return false;
        }
        Class<?> type = descriptor.getPropertyType();
        return type == Double.class || type == Double.TYPE || type == Long.class || type == Long.TYPE || type == Integer.class || type == Integer.TYPE || type == Float.class || type == Float.TYPE || type == Boolean.class || type == Boolean.TYPE || type == String.class;
    }

    static {
        beanUtils.getPropertyUtils().addBeanIntrospector((BeanIntrospector)new FluentPropertyBeanIntrospector());
    }
}

