/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ActiveMQThreadPoolExecutor
extends ThreadPoolExecutor {
    private int maxPoolSize;
    private final AtomicInteger active = new AtomicInteger(0);

    public ActiveMQThreadPoolExecutor(int coreSize, int maxSize, long keep, TimeUnit keepUnits, ThreadFactory factory) {
        this(coreSize, maxSize, keep, keepUnits, new ThreadPoolQueue(), factory);
    }

    private ActiveMQThreadPoolExecutor(int coreSize, int maxSize, long keep, TimeUnit keepUnits, ThreadPoolQueue myQueue, ThreadFactory factory) {
        super(coreSize, Integer.MAX_VALUE, keep, keepUnits, (BlockingQueue<Runnable>)myQueue, factory);
        this.maxPoolSize = maxSize;
        myQueue.setExecutor(this);
    }

    private int getActive() {
        return this.active.get();
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int maxSize) {
        this.maxPoolSize = maxSize;
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        this.active.incrementAndGet();
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        this.active.decrementAndGet();
        super.afterExecute(runnable, throwable);
    }

    private static class ThreadPoolQueue
    extends LinkedBlockingQueue<Runnable> {
        private ActiveMQThreadPoolExecutor executor = null;

        private ThreadPoolQueue() {
        }

        public void setExecutor(ActiveMQThreadPoolExecutor executor) {
            this.executor = executor;
        }

        @Override
        public boolean offer(Runnable runnable) {
            int poolSize = this.executor.getPoolSize();
            if (poolSize < this.executor.getMaximumPoolSize() && this.size() + this.executor.getActive() >= poolSize) {
                return false;
            }
            return super.offer(runnable);
        }
    }
}

