/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.ThreadLeakCheckRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ActiveMQScheduledComponentTest {
    @Rule
    public ThreadLeakCheckRule rule = new ThreadLeakCheckRule();
    ScheduledExecutorService scheduledExecutorService;
    ExecutorService executorService;

    @Before
    public void before() {
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(5);
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @After
    public void after() {
        this.executorService.shutdown();
        this.scheduledExecutorService.shutdown();
    }

    @Test
    public void testAccumulation() throws Exception {
        final AtomicInteger count = new AtomicInteger(0);
        ActiveMQScheduledComponent local = new ActiveMQScheduledComponent(this.scheduledExecutorService, this.executorService, 100L, TimeUnit.MILLISECONDS, false){

            public void run() {
                if (count.get() == 0) {
                    try {
                        Thread.sleep(800L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                count.incrementAndGet();
            }
        };
        local.start();
        Thread.sleep(1000L);
        local.stop();
        Assert.assertTrue((String)("just because one took a lot of time, it doesn't mean we can accumulate many, we got " + count + " executions"), (count.get() < 5 ? 1 : 0) != 0);
    }

    @Test
    public void testSubMillisDelay() throws InterruptedException {
        final CountDownLatch triggered = new CountDownLatch(2);
        long nsInterval = TimeUnit.MICROSECONDS.toNanos(900L);
        ActiveMQScheduledComponent local = new ActiveMQScheduledComponent(this.scheduledExecutorService, this.executorService, nsInterval, TimeUnit.NANOSECONDS, false){

            public void run() {
                triggered.countDown();
            }
        };
        local.start();
        Assert.assertTrue((boolean)triggered.await(10L, TimeUnit.SECONDS));
        local.stop();
    }

    @Test
    public void testVerifyInitialDelayChanged() {
        long initialDelay = 10L;
        long period = 100L;
        ActiveMQScheduledComponent local = new ActiveMQScheduledComponent(this.scheduledExecutorService, this.executorService, 10L, 100L, TimeUnit.MILLISECONDS, false){

            public void run() {
            }
        };
        local.start();
        long newInitialDelay = 1000L;
        local.setInitialDelay(1000L);
        local.stop();
        Assert.assertEquals((String)"the initial dalay can't change", (long)1000L, (long)local.getInitialDelay());
    }

    @Test
    public void testAccumulationOwnPool() throws Exception {
        final AtomicInteger count = new AtomicInteger(0);
        ActiveMQScheduledComponent local = new ActiveMQScheduledComponent(100L, TimeUnit.MILLISECONDS, false){

            public void run() {
                if (count.get() == 0) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                count.incrementAndGet();
            }
        };
        local.start();
        Thread.sleep(1000L);
        local.stop();
        Assert.assertTrue((String)("just because one took a lot of time, it doesn't mean we can accumulate many, we got " + count + " executions"), (count.get() <= 5 && count.get() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testUsingOwnExecutors() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        ActiveMQScheduledComponent local = new ActiveMQScheduledComponent(10L, TimeUnit.MILLISECONDS, false){

            public void run() {
                latch.countDown();
            }
        };
        local.start();
        local.start();
        try {
            Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
            local.setTimeUnit(TimeUnit.HOURS);
            local.setPeriod(1L);
        }
        finally {
            local.stop();
            local.stop();
        }
    }

    @Test
    public void testUsingOwnExecutorsOnDemand() throws Throwable {
        final ReusableLatch latch = new ReusableLatch(1);
        ActiveMQScheduledComponent local = new ActiveMQScheduledComponent(10L, TimeUnit.MILLISECONDS, true){

            public void run() {
                latch.countDown();
            }
        };
        local.start();
        local.start();
        try {
            Assert.assertFalse((boolean)latch.await(20L, TimeUnit.MILLISECONDS));
            local.delay();
            Assert.assertTrue((boolean)latch.await(20L, TimeUnit.MILLISECONDS));
            latch.setCount(1);
            Assert.assertFalse((boolean)latch.await(20L, TimeUnit.MILLISECONDS));
            local.setTimeUnit(TimeUnit.HOURS);
            local.setPeriod(1L);
        }
        finally {
            local.stop();
            local.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUsingCustomInitialDelay() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        long initialDelayMillis = 100L;
        long checkPeriodMillis = 10000L;
        ActiveMQScheduledComponent local = new ActiveMQScheduledComponent(this.scheduledExecutorService, this.executorService, 100L, 10000L, TimeUnit.MILLISECONDS, false){

            public void run() {
                latch.countDown();
            }
        };
        long start = System.nanoTime();
        local.start();
        try {
            boolean triggeredBeforePeriod = latch.await(local.getPeriod(), local.getTimeUnit());
            long timeToFirstTrigger = TimeUnit.NANOSECONDS.convert(System.nanoTime() - start, local.getTimeUnit());
            Assert.assertTrue((String)"Takes too long to start", (boolean)triggeredBeforePeriod);
            Assert.assertTrue((String)"Started too early", (timeToFirstTrigger >= local.getInitialDelay() ? 1 : 0) != 0);
        }
        finally {
            local.stop();
        }
    }
}

