/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.SizeAwareMetric;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class SizeAwareMetricTest {
    ExecutorService executor;

    private void setupExecutor(int threads) throws Exception {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(threads);
        }
    }

    @After
    public void shutdownExecutor() throws Exception {
        if (this.executor != null) {
            this.executor.shutdownNow();
            Assert.assertTrue((boolean)this.executor.awaitTermination(10L, TimeUnit.SECONDS));
            this.executor = null;
        }
    }

    @Test
    public void testWithParent() throws Exception {
        int i;
        AtomicBoolean childBoolean = new AtomicBoolean(false);
        AtomicBoolean parentBoolean = new AtomicBoolean(false);
        SizeAwareMetric child = new SizeAwareMetric(5L, 5L, 2L, 2L);
        SizeAwareMetric parent = new SizeAwareMetric(10L, 10L, 15L, 15L);
        child.setOnSizeCallback((arg_0, arg_1) -> ((SizeAwareMetric)parent).addSize(arg_0, arg_1));
        child.setOverCallback(() -> childBoolean.set(true));
        child.setUnderCallback(() -> childBoolean.set(false));
        parent.setOverCallback(() -> parentBoolean.set(true));
        parent.setUnderCallback(() -> parentBoolean.set(false));
        for (i = 0; i < 4; ++i) {
            child.addSize(1, true);
        }
        Assert.assertEquals((long)4L, (long)child.getSize());
        Assert.assertEquals((long)4L, (long)parent.getSize());
        Assert.assertEquals((long)0L, (long)child.getElements());
        Assert.assertEquals((long)0L, (long)parent.getElements());
        Assert.assertFalse((boolean)childBoolean.get());
        Assert.assertFalse((boolean)parentBoolean.get());
        child.addSize(1, true);
        Assert.assertEquals((long)5L, (long)child.getSize());
        Assert.assertTrue((boolean)childBoolean.get());
        Assert.assertFalse((boolean)parentBoolean.get());
        Assert.assertEquals((long)0L, (long)child.getElements());
        Assert.assertEquals((long)0L, (long)parent.getElements());
        child.addSize(-5, true);
        Assert.assertEquals((long)0L, (long)child.getSize());
        Assert.assertEquals((long)0L, (long)parent.getSize());
        for (i = 0; i < 5; ++i) {
            child.addSize(1, false);
        }
        Assert.assertEquals((long)5L, (long)child.getSize());
        Assert.assertEquals((long)5L, (long)parent.getSize());
        Assert.assertEquals((long)5L, (long)child.getElements());
        Assert.assertEquals((long)5L, (long)parent.getElements());
        Assert.assertTrue((boolean)childBoolean.get());
        Assert.assertFalse((boolean)parentBoolean.get());
        Assert.assertTrue((boolean)child.isOverElements());
        for (i = 0; i < 5; ++i) {
            child.addSize(1, false);
        }
        Assert.assertEquals((long)10L, (long)child.getSize());
        Assert.assertEquals((long)10L, (long)parent.getSize());
        Assert.assertEquals((long)10L, (long)child.getElements());
        Assert.assertEquals((long)10L, (long)parent.getElements());
        Assert.assertTrue((boolean)childBoolean.get());
        Assert.assertTrue((boolean)parentBoolean.get());
        Assert.assertTrue((boolean)child.isOverElements());
        Assert.assertFalse((boolean)parent.isOverElements());
        Assert.assertTrue((boolean)parent.isOverSize());
    }

    @Test
    public void testMultipleSizeAdd() throws Exception {
        int istart;
        int THREADS = 10;
        int ELEMENTS = 1000;
        this.setupExecutor(10);
        AtomicInteger errors = new AtomicInteger(0);
        AtomicInteger globalMetricOverCalls = new AtomicInteger(0);
        AtomicInteger metricOverCalls = new AtomicInteger(0);
        AtomicInteger globalMetricUnderCalls = new AtomicInteger(0);
        AtomicInteger metricUnderCalls = new AtomicInteger(0);
        AtomicBoolean globalMetricOver = new AtomicBoolean(false);
        AtomicBoolean metricOver = new AtomicBoolean(false);
        SizeAwareMetric metric = new SizeAwareMetric(1000L, 500L, -1L, -1L);
        SizeAwareMetric globalMetric = new SizeAwareMetric(10000L, 500L, -1L, -1L);
        metric.setOnSizeCallback((arg_0, arg_1) -> ((SizeAwareMetric)globalMetric).addSize(arg_0, arg_1));
        metric.setOverCallback(() -> {
            metricOver.set(true);
            metricOverCalls.incrementAndGet();
        });
        metric.setUnderCallback(() -> {
            metricOver.set(false);
            metricUnderCalls.incrementAndGet();
        });
        globalMetric.setOverCallback(() -> {
            globalMetricOver.set(true);
            globalMetricOverCalls.incrementAndGet();
        });
        globalMetric.setUnderCallback(() -> {
            globalMetricOver.set(false);
            globalMetricOverCalls.incrementAndGet();
        });
        ReusableLatch latchDone = new ReusableLatch(10);
        CyclicBarrier flagStart = new CyclicBarrier(11);
        for (istart = 0; istart < 10; ++istart) {
            this.executor.execute(() -> {
                try {
                    flagStart.await(10L, TimeUnit.SECONDS);
                    for (int iadd = 0; iadd < 1000; ++iadd) {
                        metric.addSize(1, false);
                    }
                    latchDone.countDown();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            });
        }
        flagStart.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)latchDone.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)metricOver.get());
        Assert.assertTrue((boolean)metric.isOver());
        Assert.assertTrue((boolean)metric.isOverSize());
        Assert.assertFalse((boolean)metric.isOverElements());
        Assert.assertTrue((boolean)globalMetricOver.get());
        Assert.assertTrue((boolean)globalMetric.isOver());
        Assert.assertEquals((long)1L, (long)metricOverCalls.get());
        Assert.assertEquals((long)1L, (long)globalMetricOverCalls.get());
        Assert.assertEquals((long)0L, (long)metricUnderCalls.get());
        Assert.assertEquals((long)0L, (long)globalMetricUnderCalls.get());
        Assert.assertEquals((long)10000L, (long)metric.getSize());
        Assert.assertEquals((long)10000L, (long)metric.getElements());
        Assert.assertEquals((long)10000L, (long)globalMetric.getSize());
        Assert.assertEquals((long)10000L, (long)globalMetric.getElements());
        Assert.assertEquals((long)0L, (long)errors.get());
        latchDone.setCount(10);
        for (istart = 0; istart < 10; ++istart) {
            this.executor.execute(() -> {
                try {
                    flagStart.await(10L, TimeUnit.SECONDS);
                    for (int iadd = 0; iadd < 1000; ++iadd) {
                        metric.addSize(-1, false);
                    }
                    latchDone.countDown();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            });
        }
        flagStart.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)latchDone.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)globalMetric.getSize());
        Assert.assertEquals((long)0L, (long)globalMetric.getElements());
        Assert.assertEquals((long)0L, (long)metric.getSize());
        Assert.assertEquals((long)0L, (long)metric.getElements());
        Assert.assertFalse((boolean)globalMetricOver.get());
        Assert.assertFalse((boolean)globalMetric.isOver());
    }

    @Test
    public void testMaxElements() throws Exception {
        int i;
        SizeAwareMetric metric = new SizeAwareMetric(10000L, 500L, 10L, 10L);
        AtomicBoolean over = new AtomicBoolean(false);
        metric.setOverCallback(() -> over.set(true));
        metric.setUnderCallback(() -> over.set(false));
        for (i = 0; i < 11; ++i) {
            metric.addSize(10, false);
        }
        Assert.assertTrue((boolean)over.get());
        Assert.assertEquals((long)110L, (long)metric.getSize());
        Assert.assertEquals((long)11L, (long)metric.getElements());
        metric.addSize(1000, false);
        for (i = 0; i < 12; ++i) {
            metric.addSize(-10, false);
        }
        Assert.assertFalse((boolean)over.get());
    }

    @Test
    public void testMaxElementsReleaseNonSizeParentMetric() throws Exception {
        int i;
        SizeAwareMetric metricMaster = new SizeAwareMetric(10000L, 500L, 10L, 10L);
        SizeAwareMetric metric = new SizeAwareMetric(10000L, 500L, 1000L, 1000L);
        metric.setOnSizeCallback((arg_0, arg_1) -> ((SizeAwareMetric)metricMaster).addSize(arg_0, arg_1));
        AtomicBoolean over = new AtomicBoolean(false);
        metricMaster.setOverCallback(() -> over.set(true));
        metricMaster.setUnderCallback(() -> over.set(false));
        for (i = 0; i < 11; ++i) {
            metric.addSize(10);
        }
        metric.addSize(1000, true);
        Assert.assertEquals((long)1110L, (long)metricMaster.getSize());
        Assert.assertEquals((long)11L, (long)metricMaster.getElements());
        Assert.assertEquals((long)1110L, (long)metric.getSize());
        Assert.assertEquals((long)11L, (long)metric.getElements());
        Assert.assertTrue((boolean)metricMaster.isOverElements());
        Assert.assertFalse((boolean)metricMaster.isOverSize());
        Assert.assertFalse((boolean)metric.isOverElements());
        Assert.assertFalse((boolean)metric.isOverSize());
        Assert.assertTrue((boolean)over.get());
        metric.addSize(-1000, true);
        Assert.assertEquals((long)110L, (long)metricMaster.getSize());
        Assert.assertEquals((long)11L, (long)metricMaster.getElements());
        Assert.assertTrue((boolean)metricMaster.isOverElements());
        Assert.assertFalse((boolean)metricMaster.isOverSize());
        Assert.assertTrue((boolean)over.get());
        for (i = 0; i < 11; ++i) {
            metric.addSize(-10);
        }
        Assert.assertEquals((long)0L, (long)metricMaster.getSize());
        Assert.assertEquals((long)0L, (long)metricMaster.getElements());
        Assert.assertFalse((boolean)metricMaster.isOver());
        Assert.assertEquals((long)0L, (long)metric.getSize());
        Assert.assertEquals((long)0L, (long)metric.getElements());
        Assert.assertFalse((boolean)metric.isOver());
        Assert.assertFalse((boolean)over.get());
    }

    @Test
    public void testMaxElementsReleaseNonSize() throws Exception {
        int i;
        SizeAwareMetric metric = new SizeAwareMetric(10000L, 500L, 10L, 10L);
        AtomicBoolean over = new AtomicBoolean(false);
        metric.setOverCallback(() -> over.set(true));
        metric.setUnderCallback(() -> over.set(false));
        for (i = 0; i < 11; ++i) {
            metric.addSize(10);
        }
        metric.addSize(1000, true);
        Assert.assertEquals((long)1110L, (long)metric.getSize());
        Assert.assertEquals((long)11L, (long)metric.getElements());
        Assert.assertTrue((boolean)metric.isOverElements());
        Assert.assertFalse((boolean)metric.isOverSize());
        Assert.assertTrue((boolean)over.get());
        metric.addSize(-1000, true);
        Assert.assertEquals((long)110L, (long)metric.getSize());
        Assert.assertEquals((long)11L, (long)metric.getElements());
        Assert.assertTrue((boolean)metric.isOverElements());
        Assert.assertFalse((boolean)metric.isOverSize());
        Assert.assertTrue((boolean)over.get());
        for (i = 0; i < 11; ++i) {
            metric.addSize(-10);
        }
        Assert.assertEquals((long)0L, (long)metric.getSize());
        Assert.assertEquals((long)0L, (long)metric.getElements());
        Assert.assertFalse((boolean)metric.isOver());
        Assert.assertFalse((boolean)over.get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMultipleSizeAddMultipleInstances() throws Exception {
        void var14_19;
        void var14_15;
        int THREADS = 10;
        int ELEMENTS = 1000;
        this.setupExecutor(10);
        AtomicInteger errors = new AtomicInteger(0);
        AtomicInteger globalMetricOverCalls = new AtomicInteger(0);
        AtomicInteger metricOverCalls = new AtomicInteger(0);
        AtomicInteger globalMetricUnderCalls = new AtomicInteger(0);
        AtomicInteger metricUnderCalls = new AtomicInteger(0);
        AtomicBoolean globalMetricOver = new AtomicBoolean(false);
        AtomicBoolean[] metricOverArray = new AtomicBoolean[10];
        SizeAwareMetric globalMetric = new SizeAwareMetric(10000L, 500L, 0L, 0L);
        SizeAwareMetric[] metric = new SizeAwareMetric[10];
        globalMetric.setOverCallback(() -> {
            globalMetricOver.set(true);
            globalMetricOverCalls.incrementAndGet();
        });
        globalMetric.setUnderCallback(() -> {
            globalMetricOver.set(false);
            globalMetricUnderCalls.incrementAndGet();
        });
        ReusableLatch latchDone = new ReusableLatch(10);
        CyclicBarrier flagStart = new CyclicBarrier(11);
        boolean bl = false;
        while (var14_15 < 10) {
            AtomicBoolean metricOver = new AtomicBoolean(false);
            SizeAwareMetric themetric = new SizeAwareMetric(1000L, 500L, 0L, 0L);
            themetric.setOnSizeCallback((arg_0, arg_1) -> ((SizeAwareMetric)globalMetric).addSize(arg_0, arg_1));
            themetric.setOverCallback(() -> {
                metricOver.set(true);
                metricOverCalls.incrementAndGet();
            });
            themetric.setUnderCallback(() -> {
                metricOver.set(false);
                metricUnderCalls.incrementAndGet();
            });
            metric[var14_15] = themetric;
            metricOverArray[var14_15] = metricOver;
            this.executor.execute(() -> {
                try {
                    flagStart.await(10L, TimeUnit.SECONDS);
                    for (int iadd = 0; iadd < 1000; ++iadd) {
                        themetric.addSize(1);
                    }
                    latchDone.countDown();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            });
            ++var14_15;
        }
        flagStart.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)latchDone.await(10L, TimeUnit.SECONDS));
        for (SizeAwareMetric sizeAwareMetric : metric) {
            Assert.assertTrue((boolean)sizeAwareMetric.isOver());
            Assert.assertEquals((long)1000L, (long)sizeAwareMetric.getSize());
            Assert.assertEquals((long)1000L, (long)sizeAwareMetric.getElements());
        }
        AtomicBoolean[] atomicBooleanArray = metricOverArray;
        int metricOver = atomicBooleanArray.length;
        for (int i = 0; i < metricOver; ++i) {
            AtomicBoolean atomicBoolean = atomicBooleanArray[i];
            Assert.assertTrue((boolean)atomicBoolean.get());
        }
        Assert.assertTrue((boolean)globalMetricOver.get());
        Assert.assertTrue((boolean)globalMetric.isOver());
        Assert.assertEquals((long)10L, (long)metricOverCalls.get());
        Assert.assertEquals((long)1L, (long)globalMetricOverCalls.get());
        Assert.assertEquals((long)0L, (long)metricUnderCalls.get());
        Assert.assertEquals((long)0L, (long)globalMetricUnderCalls.get());
        Assert.assertEquals((long)10000L, (long)globalMetric.getSize());
        Assert.assertEquals((long)10000L, (long)globalMetric.getElements());
        Assert.assertEquals((long)0L, (long)errors.get());
        latchDone.setCount(10);
        boolean bl2 = false;
        while (var14_19 < 10) {
            SizeAwareMetric theMetric = metric[var14_19];
            this.executor.execute(() -> {
                try {
                    flagStart.await(10L, TimeUnit.SECONDS);
                    for (int iadd = 0; iadd < 1000; ++iadd) {
                        theMetric.addSize(-1);
                    }
                    latchDone.countDown();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
            });
            ++var14_19;
        }
        flagStart.await(10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)latchDone.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)globalMetric.getSize());
        Assert.assertEquals((long)0L, (long)globalMetric.getElements());
        for (SizeAwareMetric sizeAwareMetric : metric) {
            Assert.assertEquals((long)0L, (long)sizeAwareMetric.getSize());
            Assert.assertEquals((long)0L, (long)sizeAwareMetric.getElements());
        }
        Assert.assertEquals((long)10L, (long)metricOverCalls.get());
        Assert.assertEquals((long)1L, (long)globalMetricOverCalls.get());
        Assert.assertEquals((long)10L, (long)metricUnderCalls.get());
        Assert.assertEquals((long)1L, (long)globalMetricUnderCalls.get());
        Assert.assertFalse((boolean)globalMetricOver.get());
        Assert.assertFalse((boolean)globalMetric.isOver());
        for (AtomicBoolean atomicBoolean : metricOverArray) {
            Assert.assertFalse((boolean)atomicBoolean.get());
        }
    }

    @Test
    public void testUpdateMax() throws Exception {
        AtomicBoolean over = new AtomicBoolean(false);
        SizeAwareMetric metric = new SizeAwareMetric(1000L, 500L, -1L, -1L);
        metric.setOverCallback(() -> over.set(true));
        metric.setUnderCallback(() -> over.set(false));
        metric.addSize(900);
        Assert.assertFalse((boolean)over.get());
        metric.setMax(800L, 700L, 0L, 0L);
        Assert.assertTrue((boolean)over.get());
        metric.addSize(-200);
        Assert.assertFalse((boolean)over.get());
    }

    @Test
    public void testDisabled() throws Exception {
        AtomicBoolean over = new AtomicBoolean(false);
        SizeAwareMetric metric = new SizeAwareMetric(0L, 0L, -1L, -1L);
        metric.setSizeEnabled(false);
        metric.setOverCallback(() -> over.set(true));
        metric.addSize(100);
        Assert.assertEquals((long)100L, (long)metric.getSize());
        Assert.assertEquals((long)1L, (long)metric.getElements());
        Assert.assertFalse((boolean)over.get());
    }

    @Test
    public void testMultipleNonSized() throws Exception {
        int i;
        AtomicBoolean over = new AtomicBoolean(false);
        SizeAwareMetric metricMaster = new SizeAwareMetric(0L, 0L, 1L, 1L);
        SizeAwareMetric metric = new SizeAwareMetric(0L, 0L, 1L, 1L);
        metric.setSizeEnabled(false);
        metric.setOverCallback(() -> over.set(true));
        metric.setOnSizeCallback((arg_0, arg_1) -> ((SizeAwareMetric)metricMaster).addSize(arg_0, arg_1));
        for (i = 0; i < 10; ++i) {
            metric.addSize(10, true);
        }
        Assert.assertEquals((long)100L, (long)metricMaster.getSize());
        Assert.assertEquals((long)100L, (long)metric.getSize());
        Assert.assertEquals((long)0L, (long)metricMaster.getElements());
        Assert.assertEquals((long)0L, (long)metric.getElements());
        for (i = 0; i < 10; ++i) {
            metric.addSize(10, false);
        }
        Assert.assertEquals((long)200L, (long)metricMaster.getSize());
        Assert.assertEquals((long)200L, (long)metric.getSize());
        Assert.assertEquals((long)10L, (long)metricMaster.getElements());
        Assert.assertEquals((long)10L, (long)metric.getElements());
    }

    @Test
    public void testResetNeverUsed() throws Exception {
        SizeAwareMetric metric = new SizeAwareMetric(0L, 0L, 0L, 0L);
        AtomicBoolean over = new AtomicBoolean(false);
        metric.setOverCallback(() -> over.set(true));
        metric.setElementsEnabled(true);
        metric.setSizeEnabled(true);
        metric.setMax(0L, 0L, 0L, 0L);
        Assert.assertFalse((boolean)over.get());
        Assert.assertFalse((boolean)metric.isOver());
    }

    @Test
    public void testSwitchSides() throws Exception {
        SizeAwareMetric metric = new SizeAwareMetric(2000L, 2000L, 1L, 1L);
        AtomicBoolean over = new AtomicBoolean(false);
        metric.setOverCallback(() -> over.set(true));
        metric.setUnderCallback(() -> over.set(false));
        metric.setElementsEnabled(true);
        metric.setSizeEnabled(true);
        metric.addSize(2500, true);
        Assert.assertTrue((boolean)over.get());
        metric.addSize(1000);
        Assert.assertTrue((boolean)metric.isOverSize());
        metric.addSize(-2500, true);
        Assert.assertTrue((boolean)over.get());
        Assert.assertTrue((String)"Switch did not work", (boolean)metric.isOverElements());
        Assert.assertEquals((long)1L, (long)metric.getElements());
        Assert.assertEquals((long)1000L, (long)metric.getSize());
        metric.addSize(5000, true);
        Assert.assertTrue((boolean)metric.isOverElements());
        Assert.assertEquals((long)6000L, (long)metric.getSize());
        metric.addSize(-1000);
        Assert.assertTrue((boolean)metric.isOverSize());
        Assert.assertEquals((long)0L, (long)metric.getElements());
        Assert.assertEquals((long)5000L, (long)metric.getSize());
        metric.addSize(-5000, true);
        Assert.assertFalse((boolean)metric.isOver());
        Assert.assertEquals((long)0L, (long)metric.getSize());
        Assert.assertEquals((long)0L, (long)metric.getElements());
    }

    @Test
    public void testMTOverAndUnder() throws Exception {
        int THREADS = 10;
        int ELEMENTS = 100;
        this.setupExecutor(20);
        SizeAwareMetric metric = new SizeAwareMetric(1L, 1L, -1L, -1L);
        AtomicInteger overCounter = new AtomicInteger(0);
        AtomicInteger errors = new AtomicInteger(0);
        metric.setOverCallback(() -> {
            int value = overCounter.incrementAndGet();
            if (value > 1) {
                new Exception("Value = " + value).printStackTrace();
                errors.incrementAndGet();
            }
        });
        metric.setUnderCallback(() -> {
            int value = overCounter.decrementAndGet();
            if (value < 0) {
                new Exception("Value = " + value).printStackTrace();
                errors.incrementAndGet();
            }
        });
        CyclicBarrier flagStart = new CyclicBarrier(20);
        CountDownLatch done = new CountDownLatch(20);
        for (int i = 0; i < 10; ++i) {
            this.executor.execute(() -> {
                try {
                    flagStart.await(10L, TimeUnit.SECONDS);
                    for (int repeat = 0; repeat < 100; ++repeat) {
                        metric.addSize(1);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                done.countDown();
            });
            this.executor.execute(() -> {
                try {
                    flagStart.await(10L, TimeUnit.SECONDS);
                    for (int repeat = 0; repeat < 100; ++repeat) {
                        metric.addSize(-1);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                done.countDown();
            });
        }
        Assert.assertTrue((boolean)done.await(10L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)metric.getSize());
        Assert.assertEquals((long)0L, (long)metric.getElements());
        Assert.assertEquals((long)0L, (long)errors.get());
    }
}

