/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.File;
import java.io.IOException;
import org.apache.activemq.artemis.utils.TimeUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TimeUnitsTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testWaitOnBoolean() throws IOException {
        File tmpFile = this.folder.newFile("myfile.txt");
        Assert.assertTrue((boolean)tmpFile.exists());
        long begin = System.currentTimeMillis();
        boolean result = TimeUtils.waitOnBoolean((boolean)false, (long)100L, tmpFile::exists);
        long end = System.currentTimeMillis();
        Assert.assertFalse((boolean)result);
        Assert.assertTrue((boolean)tmpFile.exists());
        Assert.assertTrue((end - begin >= 100L ? 1 : 0) != 0);
        tmpFile.delete();
        begin = System.currentTimeMillis();
        result = TimeUtils.waitOnBoolean((boolean)false, (long)5000L, tmpFile::exists);
        end = System.currentTimeMillis();
        Assert.assertTrue((boolean)result);
        Assert.assertFalse((boolean)tmpFile.exists());
        Assert.assertTrue((end - begin < 5000L ? 1 : 0) != 0);
    }
}

