/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TypedPropertiesConversionTest {
    private TypedProperties props;
    private SimpleString key;
    private final SimpleString unknownKey = new SimpleString("this.key.is.never.used");

    @Before
    public void setUp() throws Exception {
        this.key = RandomUtil.randomSimpleString();
        this.props = new TypedProperties();
    }

    @Test
    public void testBooleanProperty() throws Exception {
        Boolean val = RandomUtil.randomBoolean();
        this.props.putBooleanProperty(this.key, val.booleanValue());
        Assert.assertEquals((Object)val, (Object)this.props.getBooleanProperty(this.key));
        Assert.assertEquals((Object)new SimpleString(Boolean.toString(val)), (Object)this.props.getSimpleStringProperty(this.key));
        this.props.putSimpleStringProperty(this.key, new SimpleString(Boolean.toString(val)));
        Assert.assertEquals((Object)val, (Object)this.props.getBooleanProperty(this.key));
        try {
            this.props.putByteProperty(this.key, RandomUtil.randomByte());
            this.props.getBooleanProperty(this.key);
            Assert.fail();
        }
        catch (ActiveMQPropertyConversionException activeMQPropertyConversionException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.props.getBooleanProperty(this.unknownKey));
    }

    @Test
    public void testCharProperty() throws Exception {
        Character val = Character.valueOf(RandomUtil.randomChar());
        this.props.putCharProperty(this.key, val.charValue());
        Assert.assertEquals((Object)val, (Object)this.props.getCharProperty(this.key));
        Assert.assertEquals((Object)new SimpleString(Character.toString(val.charValue())), (Object)this.props.getSimpleStringProperty(this.key));
        try {
            this.props.putByteProperty(this.key, RandomUtil.randomByte());
            this.props.getCharProperty(this.key);
            Assert.fail();
        }
        catch (ActiveMQPropertyConversionException activeMQPropertyConversionException) {
            // empty catch block
        }
        try {
            this.props.getCharProperty(this.unknownKey);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testByteProperty() throws Exception {
        Byte val = RandomUtil.randomByte();
        this.props.putByteProperty(this.key, val.byteValue());
        Assert.assertEquals((Object)val, (Object)this.props.getByteProperty(this.key));
        Assert.assertEquals((Object)new SimpleString(Byte.toString(val)), (Object)this.props.getSimpleStringProperty(this.key));
        this.props.putSimpleStringProperty(this.key, new SimpleString(Byte.toString(val)));
        Assert.assertEquals((Object)val, (Object)this.props.getByteProperty(this.key));
        try {
            this.props.putBooleanProperty(this.key, RandomUtil.randomBoolean());
            this.props.getByteProperty(this.key);
            Assert.fail();
        }
        catch (ActiveMQPropertyConversionException activeMQPropertyConversionException) {
            // empty catch block
        }
        try {
            this.props.getByteProperty(this.unknownKey);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testNoByteProperty() {
        Assert.assertEquals((long)0L, (long)this.props.size());
        Assert.assertNull((Object)this.props.getByteProperty(this.key, () -> null));
        this.props.putByteProperty(this.key.concat('0'), RandomUtil.randomByte());
        Assert.assertEquals((long)1L, (long)this.props.size());
        Assert.assertNull((Object)this.props.getByteProperty(this.key, () -> null));
        this.props.putNullValue(this.key);
        Assert.assertTrue((boolean)this.props.containsProperty(this.key));
        Assert.assertNull((Object)this.props.getByteProperty(this.key, () -> null));
    }

    @Test
    public void testIntProperty() throws Exception {
        Integer val = RandomUtil.randomInt();
        this.props.putIntProperty(this.key, val.intValue());
        Assert.assertEquals((Object)val, (Object)this.props.getIntProperty(this.key));
        Assert.assertEquals((Object)new SimpleString(Integer.toString(val)), (Object)this.props.getSimpleStringProperty(this.key));
        this.props.putSimpleStringProperty(this.key, new SimpleString(Integer.toString(val)));
        Assert.assertEquals((Object)val, (Object)this.props.getIntProperty(this.key));
        Byte byteVal = RandomUtil.randomByte();
        this.props.putByteProperty(this.key, byteVal.byteValue());
        Assert.assertEquals((Object)byteVal, (Object)this.props.getIntProperty(this.key));
        try {
            this.props.putBooleanProperty(this.key, RandomUtil.randomBoolean());
            this.props.getIntProperty(this.key);
            Assert.fail();
        }
        catch (ActiveMQPropertyConversionException activeMQPropertyConversionException) {
            // empty catch block
        }
        try {
            this.props.getIntProperty(this.unknownKey);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testLongProperty() throws Exception {
        Long val = RandomUtil.randomLong();
        this.props.putLongProperty(this.key, val.longValue());
        Assert.assertEquals((Object)val, (Object)this.props.getLongProperty(this.key));
        Assert.assertEquals((Object)new SimpleString(Long.toString(val)), (Object)this.props.getSimpleStringProperty(this.key));
        this.props.putSimpleStringProperty(this.key, new SimpleString(Long.toString(val)));
        Assert.assertEquals((Object)val, (Object)this.props.getLongProperty(this.key));
        Byte byteVal = RandomUtil.randomByte();
        this.props.putByteProperty(this.key, byteVal.byteValue());
        Assert.assertEquals((Object)byteVal, (Object)this.props.getLongProperty(this.key));
        Short shortVal = RandomUtil.randomShort();
        this.props.putShortProperty(this.key, shortVal.shortValue());
        Assert.assertEquals((Object)shortVal, (Object)this.props.getLongProperty(this.key));
        Integer intVal = RandomUtil.randomInt();
        this.props.putIntProperty(this.key, intVal.intValue());
        Assert.assertEquals((Object)intVal, (Object)this.props.getLongProperty(this.key));
        try {
            this.props.putBooleanProperty(this.key, RandomUtil.randomBoolean());
            this.props.getLongProperty(this.key);
            Assert.fail();
        }
        catch (ActiveMQPropertyConversionException activeMQPropertyConversionException) {
            // empty catch block
        }
        try {
            this.props.getLongProperty(this.unknownKey);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleProperty() throws Exception {
        Double val = RandomUtil.randomDouble();
        this.props.putDoubleProperty(this.key, val.doubleValue());
        Assert.assertEquals((Object)val, (Object)this.props.getDoubleProperty(this.key));
        Assert.assertEquals((Object)new SimpleString(Double.toString(val)), (Object)this.props.getSimpleStringProperty(this.key));
        this.props.putSimpleStringProperty(this.key, new SimpleString(Double.toString(val)));
        Assert.assertEquals((Object)val, (Object)this.props.getDoubleProperty(this.key));
        try {
            this.props.putBooleanProperty(this.key, RandomUtil.randomBoolean());
            this.props.getDoubleProperty(this.key);
            Assert.fail();
        }
        catch (ActiveMQPropertyConversionException activeMQPropertyConversionException) {
            // empty catch block
        }
        try {
            this.props.getDoubleProperty(this.unknownKey);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testFloatProperty() throws Exception {
        Float val = Float.valueOf(RandomUtil.randomFloat());
        this.props.putFloatProperty(this.key, val.floatValue());
        Assert.assertEquals((Object)val, (Object)this.props.getFloatProperty(this.key));
        Assert.assertEquals((Object)val.floatValue(), (Object)this.props.getDoubleProperty(this.key));
        Assert.assertEquals((Object)new SimpleString(Float.toString(val.floatValue())), (Object)this.props.getSimpleStringProperty(this.key));
        this.props.putSimpleStringProperty(this.key, new SimpleString(Float.toString(val.floatValue())));
        Assert.assertEquals((Object)val, (Object)this.props.getFloatProperty(this.key));
        try {
            this.props.putBooleanProperty(this.key, RandomUtil.randomBoolean());
            this.props.getFloatProperty(this.key);
            Assert.fail();
        }
        catch (ActiveMQPropertyConversionException activeMQPropertyConversionException) {
            // empty catch block
        }
        try {
            this.props.getFloatProperty(this.unknownKey);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testShortProperty() throws Exception {
        Short val = RandomUtil.randomShort();
        this.props.putShortProperty(this.key, val.shortValue());
        Assert.assertEquals((Object)val, (Object)this.props.getShortProperty(this.key));
        Assert.assertEquals((Object)val, (Object)this.props.getIntProperty(this.key));
        Assert.assertEquals((Object)new SimpleString(Short.toString(val)), (Object)this.props.getSimpleStringProperty(this.key));
        this.props.putSimpleStringProperty(this.key, new SimpleString(Short.toString(val)));
        Assert.assertEquals((Object)val, (Object)this.props.getShortProperty(this.key));
        Byte byteVal = RandomUtil.randomByte();
        this.props.putByteProperty(this.key, byteVal.byteValue());
        Assert.assertEquals((Object)byteVal, (Object)this.props.getShortProperty(this.key));
        try {
            this.props.putBooleanProperty(this.key, RandomUtil.randomBoolean());
            this.props.getShortProperty(this.key);
            Assert.fail();
        }
        catch (ActiveMQPropertyConversionException activeMQPropertyConversionException) {
            // empty catch block
        }
        try {
            this.props.getShortProperty(this.unknownKey);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testSimpleStringProperty() throws Exception {
        SimpleString strVal = RandomUtil.randomSimpleString();
        this.props.putSimpleStringProperty(this.key, strVal);
        Assert.assertEquals((Object)strVal, (Object)this.props.getSimpleStringProperty(this.key));
    }

    @Test
    public void testBytesProperty() throws Exception {
        byte[] val = RandomUtil.randomBytes();
        this.props.putBytesProperty(this.key, val);
        Assert.assertArrayEquals((byte[])val, (byte[])this.props.getBytesProperty(this.key));
        try {
            this.props.putBooleanProperty(this.key, RandomUtil.randomBoolean());
            this.props.getBytesProperty(this.key);
            Assert.fail();
        }
        catch (ActiveMQPropertyConversionException activeMQPropertyConversionException) {
            // empty catch block
        }
        Assert.assertNull((Object)this.props.getBytesProperty(this.unknownKey));
    }
}

