/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.activemq.artemis.utils.ThreadDumpUtil;
import org.junit.Assert;

public class Wait {
    public static final long MAX_WAIT_MILLIS = 30000L;
    public static final int SLEEP_MILLIS = 100;
    public static final String DEFAULT_FAILURE_MESSAGE = "Condition wasn't met";

    public static boolean waitFor(Condition condition) throws Exception {
        return Wait.waitFor(condition, 30000L);
    }

    public static void assertEquals(Object obj, ObjectCondition condition) throws Exception {
        Wait.assertEquals(obj, condition, 30000L, 100L);
    }

    public static void assertEquals(long size, LongCondition condition) throws Exception {
        Wait.assertEquals(size, condition, 30000L);
    }

    public static void assertEquals(long size, LongCondition condition, long timeout) throws Exception {
        Wait.assertEquals(size, condition, timeout, 100L);
    }

    public static void assertEquals(Long size, LongCondition condition, long timeout, long sleepMillis) throws Exception {
        Wait.assertEquals(size, condition, timeout, sleepMillis, false);
    }

    public static void assertEquals(Long size, LongCondition condition, long timeout, long sleepMillis, boolean printThreadDump) throws Exception {
        boolean result = Wait.waitFor(() -> condition.getCount() == size.longValue(), timeout, sleepMillis, printThreadDump);
        if (!result) {
            if (printThreadDump) {
                System.out.println(ThreadDumpUtil.threadDump((String)"thread dump"));
            }
            Assert.fail((String)(size + " != " + condition.getCount()));
        }
    }

    public static void assertEquals(int size, IntCondition condition) throws Exception {
        Wait.assertEquals(size, condition, 30000L);
    }

    public static void assertEquals(int size, IntCondition condition, long timeout) throws Exception {
        Wait.assertEquals(size, condition, timeout, 100L);
    }

    public static void assertEquals(Object obj, ObjectCondition condition, long timeout, long sleepMillis) throws Exception {
        boolean result = Wait.waitFor(() -> obj == condition || obj.equals(condition.getObject()), timeout, sleepMillis);
        if (!result) {
            Assert.assertEquals((Object)obj, (Object)condition.getObject());
        }
    }

    public static void assertEquals(int size, IntCondition condition, long timeout, long sleepMillis) throws Exception {
        boolean result = Wait.waitFor(() -> condition.getCount() == size, timeout, sleepMillis);
        if (!result) {
            Assert.fail((String)(size + " != " + condition.getCount()));
        }
    }

    public static void assertTrue(Condition condition) {
        Wait.assertTrue(DEFAULT_FAILURE_MESSAGE, condition);
    }

    public static void assertFalse(Condition condition) {
        Wait.assertTrue(() -> !condition.isSatisfied());
    }

    public static void assertFalse(String failureMessage, Condition condition) {
        Wait.assertTrue(failureMessage, () -> !condition.isSatisfied());
    }

    public static void assertFalse(String failureMessage, Condition condition, long duration) {
        Wait.assertTrue(failureMessage, () -> !condition.isSatisfied(), duration, 100L);
    }

    public static void assertFalse(Condition condition, long duration, long sleep) {
        Wait.assertTrue(DEFAULT_FAILURE_MESSAGE, () -> !condition.isSatisfied(), duration, sleep);
    }

    public static void assertTrue(Condition condition, long duration) {
        Wait.assertTrue(DEFAULT_FAILURE_MESSAGE, condition, duration, 100L);
    }

    public static void assertTrue(String failureMessage, Condition condition) {
        Wait.assertTrue(failureMessage, condition, 30000L);
    }

    public static void assertTrue(String failureMessage, Condition condition, long duration) {
        Wait.assertTrue(failureMessage, condition, duration, 100L);
    }

    public static void assertTrue(Condition condition, long duration, long sleep) {
        Wait.assertTrue(DEFAULT_FAILURE_MESSAGE, condition, duration, sleep);
    }

    public static void assertTrue(String failureMessage, Condition condition, long duration, long sleep) {
        boolean result = Wait.waitFor(condition, duration, sleep);
        if (!result) {
            Assert.fail((String)failureMessage);
        }
    }

    public static boolean waitFor(Condition condition, long duration) throws Exception {
        return Wait.waitFor(condition, duration, 100L);
    }

    public static boolean waitFor(Condition condition, long durationMillis, long sleepMillis) {
        return Wait.waitFor(condition, durationMillis, sleepMillis, false);
    }

    public static boolean waitFor(Condition condition, long durationMillis, long sleepMillis, boolean printThreadDump) {
        try {
            long expiry = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(durationMillis);
            boolean conditionSatisified = condition.isSatisfied();
            while (!conditionSatisified && System.nanoTime() - expiry < 0L) {
                if (sleepMillis == 0L) {
                    Thread.yield();
                } else {
                    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(sleepMillis));
                }
                conditionSatisified = condition.isSatisfied();
            }
            if (!conditionSatisified && printThreadDump) {
                System.out.println(ThreadDumpUtil.threadDump((String)"thread dump"));
            }
            return conditionSatisified;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static interface IntCondition {
        public int getCount() throws Exception;
    }

    public static interface ObjectCondition {
        public Object getObject() throws Exception;
    }

    public static interface LongCondition {
        public long getCount() throws Exception;
    }

    public static interface Condition {
        public boolean isSatisfied() throws Exception;
    }
}

