/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.actors;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.utils.actors.OrderedExecutor;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class OrderedExecutorSanityTest {
    private static final Logger log = Logger.getLogger(OrderedExecutorSanityTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldExecuteTasksInOrder() throws InterruptedException {
        int threads = 3;
        int tasks = 100;
        long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        try {
            OrderedExecutor executor = new OrderedExecutor((Executor)executorService);
            ArrayList results = new ArrayList(100);
            ArrayList<Integer> expectedResults = new ArrayList<Integer>(100);
            CountDownLatch executed = new CountDownLatch(100);
            int i = 0;
            while (i < 100) {
                int value = i++;
                executor.execute(() -> {
                    results.add(value);
                    executed.countDown();
                });
                expectedResults.add(value);
            }
            Assert.assertTrue((String)("The tasks must be executed in " + timeoutMillis + " ms"), (boolean)executed.await(timeoutMillis, TimeUnit.MILLISECONDS));
            Assert.assertArrayEquals((String)"The processing of tasks must be ordered", (Object[])expectedResults.toArray(), (Object[])results.toArray());
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldShutdownNowDoNotExecuteFurtherTasks() throws InterruptedException {
        long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            OrderedExecutor executor = new OrderedExecutor((Executor)executorService);
            CountDownLatch executed = new CountDownLatch(1);
            executor.execute(executed::countDown);
            Assert.assertTrue((String)("The task must be executed in " + timeoutMillis + " ms"), (boolean)executed.await(timeoutMillis, TimeUnit.MILLISECONDS));
            executor.shutdownNow();
            Assert.assertEquals((String)"There are no remaining tasks to be executed", (long)0L, (long)executor.remaining());
            executor.execute(() -> System.out.println("this will never happen"));
            Assert.assertEquals((String)"Any new task submitted after death must be collected", (long)0L, (long)executor.remaining());
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shutdownNowOnDelegateExecutor() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            OrderedExecutor executor = new OrderedExecutor((Executor)executorService);
            CyclicBarrier latch = new CyclicBarrier(2);
            AtomicInteger numberOfTasks = new AtomicInteger(0);
            CountDownLatch ran = new CountDownLatch(1);
            executor.execute(() -> {
                try {
                    latch.await(1L, TimeUnit.MINUTES);
                    numberOfTasks.set(executor.shutdownNow());
                    ran.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            for (int i = 0; i < 100; ++i) {
                executor.execute(() -> System.out.println("Dont worry, this will never happen"));
            }
            latch.await();
            ran.await(1L, TimeUnit.SECONDS);
            Assert.assertEquals((long)100L, (long)numberOfTasks.get());
            Assert.assertEquals((long)2L, (long)executor.status());
            Assert.assertEquals((long)0L, (long)executor.remaining());
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shutdownNowWithBlocked() throws Exception {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            OrderedExecutor executor = new OrderedExecutor((Executor)executorService);
            CyclicBarrier latch = new CyclicBarrier(2);
            CyclicBarrier secondlatch = new CyclicBarrier(2);
            CountDownLatch ran = new CountDownLatch(1);
            executor.execute(() -> {
                try {
                    latch.await(1L, TimeUnit.MINUTES);
                    secondlatch.await(1L, TimeUnit.MINUTES);
                    ran.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            for (int i = 0; i < 100; ++i) {
                executor.execute(() -> System.out.println("Dont worry, this will never happen"));
            }
            latch.await();
            try {
                Assert.assertEquals((long)100L, (long)executor.shutdownNow());
            }
            finally {
                secondlatch.await();
            }
            Assert.assertEquals((long)2L, (long)executor.status());
            Assert.assertEquals((long)0L, (long)executor.remaining());
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMeasure() throws InterruptedException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            OrderedExecutor executor = new OrderedExecutor((Executor)executorService);
            int MAX_LOOP = 1000000;
            int runs = 10;
            for (int i = 0; i < runs; ++i) {
                long start = System.nanoTime();
                CountDownLatch executed = new CountDownLatch(MAX_LOOP);
                for (int l = 0; l < MAX_LOOP; ++l) {
                    executor.execute(executed::countDown);
                }
                Assert.assertTrue((boolean)executed.await(1L, TimeUnit.MINUTES));
                long end = System.nanoTime();
                long elapsed = end - start;
                log.info((Object)("execution " + i + " in " + TimeUnit.NANOSECONDS.toMillis(elapsed) + " milliseconds"));
            }
        }
        finally {
            executorService.shutdown();
        }
    }
}

