/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.util.ArrayList;
import org.apache.activemq.artemis.utils.collections.ArrayResettableIterator;
import org.apache.activemq.artemis.utils.collections.MultiResettableIterator;
import org.apache.activemq.artemis.utils.collections.ResettableIterator;
import org.junit.Assert;
import org.junit.Test;

public class MultiResettableIteratorTest {
    @Test
    public void testSingleIterator() {
        int i;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < 1000; ++i2) {
            arrayList.add(i2);
        }
        MultiResettableIterator iterator = new MultiResettableIterator(new ResettableIterator[]{ArrayResettableIterator.iterator(arrayList)});
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)i, (Object)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.reset();
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)i, (Object)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMutlipleIterators() {
        int i;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < 1000; ++i2) {
            arrayList.add(i2);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i3 = 1000; i3 < 2000; ++i3) {
            arrayList2.add(i3);
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i4 = 2000; i4 < 3000; ++i4) {
            arrayList3.add(i4);
        }
        MultiResettableIterator iterator = new MultiResettableIterator(new ResettableIterator[]{ArrayResettableIterator.iterator(arrayList), ArrayResettableIterator.iterator(arrayList2), ArrayResettableIterator.iterator(arrayList3)});
        for (i = 0; i < 3000; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)i, (Object)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator.reset();
        for (i = 0; i < 3000; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)i, (Object)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMutlipleIteratorsResetMidIteration() {
        int i;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < 1000; ++i2) {
            arrayList.add(i2);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i3 = 1000; i3 < 2000; ++i3) {
            arrayList2.add(i3);
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i4 = 2000; i4 < 3000; ++i4) {
            arrayList3.add(i4);
        }
        MultiResettableIterator iterator = new MultiResettableIterator(new ResettableIterator[]{ArrayResettableIterator.iterator(arrayList), ArrayResettableIterator.iterator(arrayList2), ArrayResettableIterator.iterator(arrayList3)});
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertEquals((Object)i, (Object)iterator.next());
        }
        iterator.reset();
        for (i = 0; i < 3000; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertNotNull((Object)iterator.next());
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

